# coding: UTF-8

# noinspection PyUnresolvedReferences
from com.huawei.ism.exception import IsmException

import common
import cli_util
import hardware_util
import constant
import redfish_util

# noinspection PyUnresolvedReferences
LANG = common.getLang(py_java_env)
# noinspection PyUnresolvedReferences
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "hardware_system_health_status"
# noinspection PyUnresolvedReferences
PY_JAVA_ENV = py_java_env


def execute(rest):
    """
    检查系统健康状态
    :param env:
    :return:
    """
    ret_list = []
    err_info_list = []
    observer = PY_JAVA_ENV.get("progressObserver")
    progress_map = {}
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        param_dict = dict()
        param_dict["env"] = PY_JAVA_ENV
        param_dict["ret_list"] = ret_list
        param_dict["logger"] = LOGGER
        param_dict["err_info_list"] = err_info_list
        param_dict["ITEM_ID"] = ITEM_ID
        param_dict["progress_map"] = progress_map
        check_alarm(param_dict, None, err_info_list, ret_list)
        all_ret = common.save_cli_ret_to_file(
            ret_list, ITEM_ID, PY_JAVA_ENV, LOGGER
        )
        if err_info_list:
            # 判断服务器类型，如果是TaiShan V1服务器，显示不涉及
            palindrome_list = []
            check_is_tai_shan_v1(param_dict, None, err_info_list, palindrome_list)
            if palindrome_list:
                all_palindrome = common.save_cli_ret_to_file(
                    palindrome_list, ITEM_ID, PY_JAVA_ENV, LOGGER
                )
                return common.INSPECT_NOSUPPORT, all_palindrome, ""
            return common.INSPECT_UNNORMAL, all_ret, "".join(err_info_list)
        return common.INSPECT_PASS, all_ret, ""

    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            common.save_cli_ret_to_file(
                ret_list, ITEM_ID, PY_JAVA_ENV, LOGGER
            ),
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


@common.check_all_ibmc_node
def check_alarm(param_dict, cluster_dev_node, err_info_list, ret_list):
    cluster_node_ip = common.get_node_ip(cluster_dev_node)
    flag, ret_json = common.get_system_over_view_info(cluster_dev_node)
    show_ret = "{}\n{}".format("/SystemOverview", ret_json)
    ret_list.append(cli_util.get_format_header_ret(cluster_node_ip, show_ret))
    if flag is not True:
        err_info_list.append(
            common.get_err_msg(
                LANG,
                "hardware.status.check.failed",
                cluster_node_ip,
            )
        )
        return

    sys_list = ret_json.get("Systems", [])

    err_alarm_list = []
    for sys_info in sys_list:
        health_summary_dict = sys_info.get("HealthSummary", {})
        cri_count = health_summary_dict.get("CriticalAlarmCount", "")
        maj_count = health_summary_dict.get("MajorAlarmCount", "")
        if str(cri_count) != "0":
            err_alarm_list.append("CriticalAlarm")
        if str(maj_count) != "0":
            err_alarm_list.append("MajorAlarm")

    if err_alarm_list:
        err_info_list.append(
            common.get_err_msg(
                LANG,
                "hardware.system.health.status.not.pass",
                (cluster_node_ip, ",".join(err_alarm_list)),
            )
        )


@common.check_all_ibmc_node
def check_is_tai_shan_v1(param_dict, cluster_dev_node, err_info_list, palindrome_list):
    """
    判断设备是否为TaiShan V1类型的服务器
    :param param_dict: 参数
    :param cluster_dev_node: 节点
    :param err_info_list: 错误信息列表
    :param palindrome_list: 回文
    :return:
    """
    redfish = common.get_redfish_conn(cluster_dev_node)
    uid, ret = redfish_util.get_product_unique_id(redfish, LOGGER)
    platform_type = hardware_util.get_platform_id(uid)
    if constant.Platform.TAI_SHAN_V1 == platform_type:
        cluster_node_ip = common.get_node_ip(cluster_dev_node)
        palindrome_list.append(
            u"{}".format(
                cli_util.get_format_header_ret(cluster_node_ip, common.get_err_msg(LANG, "not.involved"))))
