# coding: UTF-8

# noinspection PyUnresolvedReferences
from com.huawei.ism.exception import IsmException

import common
import cli_util

# noinspection PyUnresolvedReferences
LANG = common.getLang(py_java_env)
# noinspection PyUnresolvedReferences
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "hardware_temper_health_status"
# noinspection PyUnresolvedReferences
PY_JAVA_ENV = py_java_env

TEMPER_ALARM_LIST = ["0x50000003", "0x100000DB", "0x12000009", "0x12000001"]


def execute(rest):
    """
    检查温度状态
    :param env:
    :return:
    """
    ret_list = []
    err_info_list = []
    observer = PY_JAVA_ENV.get("progressObserver")
    progress_map = {}
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        param_dict = dict()
        param_dict["env"] = PY_JAVA_ENV
        param_dict["ret_list"] = ret_list
        param_dict["logger"] = LOGGER
        param_dict["err_info_list"] = err_info_list
        param_dict["ITEM_ID"] = ITEM_ID
        param_dict["progress_map"] = progress_map
        check_temper(param_dict, None, err_info_list, ret_list)
        all_ret = common.save_cli_ret_to_file(
            ret_list, ITEM_ID, PY_JAVA_ENV, LOGGER
        )
        if err_info_list:
            return common.INSPECT_UNNORMAL, all_ret, "".join(err_info_list)
        return common.INSPECT_PASS, all_ret, ""

    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            common.save_cli_ret_to_file(
                ret_list, ITEM_ID, PY_JAVA_ENV, LOGGER
            ),
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


@common.check_all_ibmc_node
def check_temper(param_dict, cluster_dev_node, err_info_list, ret_list):
    """
    检查系统温度信息
    :param param_dict: 参数列表
    :param ibmc_dev_node: ibmc 节点
    :param err_info_list: 错误消息
    :param ret_list: 回文
    :return:
    """
    flag = check_temper_alarm(cluster_dev_node, ret_list, err_info_list)
    if not flag:
        flag, ret_json = common.get_system_over_view_info(cluster_dev_node)
        if not flag:
            if check_temp_health(cluster_dev_node, ret_list):
                return
            err_info_list.append(
                common.get_err_msg(
                    LANG,
                    "hardware.status.check.failed",
                    common.get_node_ip(cluster_dev_node),
                )
            )
        show_ret = "{}\n{}".format("/SystemOverview", ret_json)
        ret_list.append(show_ret)


def check_temp_health(cluster_dev_node, ret_list):
    """
    通过接口/Chassis/1/ThresholdSensors查询系统的温度状态
    :param cluster_dev_node: 节点
    :param ret_list: 回文
    :return:
    """
    try:
        flag, ret_json, path = common.get_chassis_hardware_resource(cluster_dev_node, LOGGER, "ThresholdSensors")
        show_ret = "{}\n{}".format(path, ret_json)
        ret_list.append(show_ret)
        return flag
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return False


def check_temper_alarm(cluster_dev_node, ret_list, err_info_list):
    """
    获取内存详情
    :param cluster_dev_node: ibmc节点
    :param ret_list: 原始信息列表
    :param err_info_list: 错误消息
    :return:
    """
    flag, ret, res_list = common.get_alam_major_certical(cluster_dev_node)
    cluster_node_ip = common.get_node_ip(cluster_dev_node)
    ret_list.append(cli_util.get_format_header_ret(cluster_node_ip, ret))
    if flag is not True:
        err_info_list.append(
            common.get_err_msg(
                LANG,
                "hardware.status.check.failed",
                cluster_node_ip,
            )
        )
        return False
    tmp_err_list = []
    for line in ret.splitlines():
        # 如果存在温度告警(0x50000003/0x100000DB/0x12000009/0x12000001)则检查不通过
        for alarm_id in TEMPER_ALARM_LIST:
            if alarm_id in line:
                tmp_err_list.append("\n{}".format(line))
                break
    if tmp_err_list:
        err_info_list.append(
            common.get_err_msg(
                LANG,
                "hardware.temper.status.not.pass",
                (cluster_node_ip, "".join(tmp_err_list)),
            )
        )
        return False
    return True
