# coding: UTF-8

# noinspection PyUnresolvedReferences
from com.huawei.ism.exception import IsmException

import common
import cli_util

# noinspection PyUnresolvedReferences
LANG = common.getLang(py_java_env)
# noinspection PyUnresolvedReferences
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "https_cert_verify_status"
# noinspection PyUnresolvedReferences
PY_JAVA_ENV = py_java_env


def execute(rest):
    """
    检查服务器https服务证书校验开关
    :param env:
    :return:
    """
    ret_list = []
    err_info_list = []
    observer = PY_JAVA_ENV.get("progressObserver")
    progress_map = {}
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        param_dict = dict()
        param_dict["env"] = PY_JAVA_ENV
        param_dict["logger"] = LOGGER
        param_dict["ITEM_ID"] = ITEM_ID
        param_dict["progress_map"] = progress_map
        check_https_cert_verify_status(param_dict, None, err_info_list, ret_list)
        all_ret = common.save_cli_ret_to_file(
            ret_list, ITEM_ID, PY_JAVA_ENV, LOGGER
        )
        if err_info_list:
            return common.INSPECT_UNNORMAL, all_ret, "".join(err_info_list)
        return common.INSPECT_PASS, all_ret, ""

    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            common.save_cli_ret_to_file(
                ret_list, ITEM_ID, PY_JAVA_ENV, LOGGER
            ),
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


@common.check_all_ibmc_node
def check_https_cert_verify_status(param_dict, cluster_dev_node, err_info_list, ret_list):
    """
    检查服务器https服务证书校验开关
    :param cluster_dev_node: 节点
    :param param_dict: 参数列表
    :param err_info_list: 错误消息
    :param ret_list: 回文
    :return:
    """
    redfish_conn = common.get_redfish_conn(cluster_dev_node)
    cmd_url = "/Managers/1/SecurityService"
    flag, ret_json = cli_util.execute_redfish_get(redfish_conn, cmd_url)
    cluster_node_ip = common.get_node_ip(cluster_dev_node)
    LOGGER.logError("execute_redfish_get_info--- {}\n{}".format(flag, ret_json))
    if not flag:
        err_info_list.append(
            common.get_err_msg(
                LANG,
                "httpscertverify.status.check.failed",
                (cluster_node_ip, "/redfish/v1".join(cmd_url))
            )
        )
        return
    show_ret = "{}\n{}".format("/Managers/1/SecurityService", ret_json)
    ret_list.append(cli_util.get_format_header_ret(cluster_node_ip, show_ret))
    #没有HttpsTransferCertVerification字段说明版本不符合预期，巡检失败
    https_cert_verify_status = ret_json.get("HttpsTransferCertVerification", "")
    if str(https_cert_verify_status).upper() != "FALSE":
        err_info_list.append(
            common.get_err_msg(
                LANG,
                "httpscertverify.status.check.not.pass",
                (cluster_node_ip, "HttpsTransferCertVerification")
            )
        )
