# coding: UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
from com.huawei.ism.exception import IsmException

import cli_util
import common

ITEM_ID = "jbod_strategy"
LANG = common.getLang(py_java_env)
RAID_3008 = "3008"
RAID_3152 = "3152"
QUERY_URI = "/redfish/v1/Systems/1/Storages/"


def execute(rest_conn):
    """
    检查JBod开关配置
    :param rest_conn: 集群rest连接
    :return:
    """
    item = common.ItemEntity(py_java_env, ITEM_ID, PY_LOGGER, __file__)
    item.update_progress(1)
    try:
        check(item.build_param_dict(), None, item.err_info_list, item.ret_list)
        return item.get_check_result()
    except (IsmException, Exception) as exception:
        item.logger.logException(exception)
        return item.get_failed_result(common.get_err_msg(LANG, "query.result.abnormal"))


@common.check_all_ibmc_node
def check(param_dict, cluster_dev_node, err_info_list, ret_list):
    cluster_node_ip = common.get_node_ip(cluster_dev_node)
    redfish_conn = common.get_redfish_conn(cluster_dev_node)
    ret_by_node = []
    unexpected_list = []
    logger = param_dict.get("logger")
    try:
        flag, info = cli_util.direct_execute_redfish_get(redfish_conn, QUERY_URI)
        ret_by_node.append(str(info))
        for path in cli_util.get_storage_path(info):
            flag, info = cli_util.direct_execute_redfish_get(redfish_conn, path)
            ret_by_node.append(str(info))

            control_info = info.get("StorageControllers")
            flag, unexpected_rets = check_jbod_strategy(control_info, "JBODState", True)
            if flag:
                unexpected_list.extend(unexpected_rets)

        if unexpected_list:
            logger.logNoPass("Strategy not pass {} .".format(str(unexpected_list)))
            err_info_list.append(common.get_err_msg(LANG, "strategy.status.not.pass", cluster_node_ip))
    except Exception as exception:
        logger.logException(exception)
        err_info_list.append(common.get_err_msg(LANG, "item.check.abnormal", cluster_node_ip))
    finally:
        ret_list.append(cli_util.get_format_header_ret(cluster_node_ip, "\n".join(ret_by_node)))


def need_check_jbod(raid_card_info):
    """
    是否需要检查JBOD配置
    :param raid_card_info: raid卡信息
    :return: 是否需要检查
    """
    model = raid_card_info.get("Model")
    return RAID_3008 not in model and RAID_3152 not in model


def check_jbod_strategy(storage_ctrls_info, key, except_value):
    """
    检查存储控制器的参数是否符合预期,等值比较,适用于Systems/1/Storages/RAIDStorage${ctrlId}
    :param record_dict: redfish的响应结果
    :param key: 取值的key
    :param except_value: 预期的值
    :return: 是否存在不符合预期的，若值为None则不判断
    """
    unexpected_list = []
    for storage_ctrl_info in storage_ctrls_info:
        if not need_check_jbod(storage_ctrl_info):
            continue
        huawei_info = storage_ctrl_info.get("Oem").values()[0]
        if key in huawei_info and huawei_info.get(key) is not None and huawei_info.get(key) != except_value:
            msg = "MemberId {} : {}={}\n"
            unexpected_list.append(msg.format(storage_ctrl_info.get("MemberId"), key, str(huawei_info.get(key))))
    return len(unexpected_list) != 0, unexpected_list
