# coding: UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2024. All rights reserved.

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException
import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
ITEM_ID = "network_platform_info"
HANDLE = py_java_env.get("preInspectHandle")
PRE_ITEM_ID = "osInfoForNetworkSiteDeployment"


# 1-》"both_front_backend_and_self_manage_self_iscsi",
# 2: "self_backend_and_both_front_manage_split_by_vlan_and_self_iscsi",
# 3: "self_backend_and_self_front_and_self_manage_self_iscsi"
# 4: "self_front_and_both_backend_manage_split_by_vlan_and_self_iscsi"

def execute(rest):
    """
    检查集群节点网络平面
    :param
    :return:
    """
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progress_map = dict()
    try:
        progress_map[ITEM_ID] = 1
        product_version = str(dev_node.getProductVersion())
        if not is_involve_product_version(product_version):
            msg = common.get_err_msg(LANG, "query.version.na", product_version)
            return common.INSPECT_NOSUPPORT, msg, msg
        observer.updateProgress(progress_map)
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        is_block_res = is_block(base_uri, rest, progress_map, observer)
        if is_block_res == 2:
            msg = common.get_err_msg(LANG, "fsm.device.not.has.pool")
            return common.INSPECT_UNNORMAL, msg, msg
        if is_block_res == 0:
            msg = common.get_err_msg(LANG, "query.version.na", product_version)
            return common.INSPECT_NOSUPPORT, msg, msg
        if check_not_support(dev_node):
            msg = common.get_err_msg(LANG, "query.version.na", product_version)
            return common.INSPECT_NOSUPPORT, msg, msg
        result_ip_dict = check_version_result(base_uri, rest, progress_map, observer)
        def_platform = ""
        is_error = False
        error_ips = ""
        LOGGER.logInfo("result_ip_dict {}".format(result_ip_dict))
        for key, val in result_ip_dict.items():
            if val == "platform_error":
                is_error = True
                error_ips = error_ips + "[" + key + "]"
                continue
            if is_error:
                continue
            if def_platform == "":
                def_platform = val
            if def_platform != val:
                msg = common.get_err_msg(LANG, "cluster.platform.error")
                return common.INSPECT_UNNORMAL, msg, msg
        if is_error:
            msg = common.get_err_msg(LANG, "node.platform.error", error_ips)
            return common.INSPECT_UNNORMAL, msg, msg
        return common.INSPECT_PASS, common.get_err_msg(LANG, "cluster.platform.pass"), ""
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        ret_list.append(common.get_err_msg(LANG, "cluster.platform.error"))
        return common.INSPECT_UNNORMAL, "\n has exception", ""


def check_not_support(dev_node):
    for cluster_node in dev_node.getClusterNodes():
        roles = cluster_node.getRoles()
        if "storage" not in roles:
            continue
        node_ip = common.get_node_ip(cluster_node)
        ret = HANDLE.getPreInspectResult(node_ip, PRE_ITEM_ID)
        LOGGER.logInfo("ip {} ret {}".format(node_ip, ret))
        if ret != "not_support":
            return False
    return True


def is_involve_product_version(product_version):
    """
    检查版本信息：813之前的版本暂不支持该巡检项
    """
    version = product_version.replace('.', "")
    if version[0:2] > "81":
        return True
    if version[0:2] == "81" and version[2].isdigit() and version[2] >= "3":
        return True
    if len(version) >= 5:
        if version[0:2] == "81" and version[2:4] == "RC" and version[4] >= "6":
            return True
    return False


def is_block(base_uri, rest, progress_map, observer):
    progress_map[ITEM_ID] = 50
    observer.updateProgress(progress_map)
    cmd_str = "{}/dsware/service/resource/queryStoragePool?baseInfo=false".format(base_uri)
    port_bind_type_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
    port_bind_type_data = port_bind_type_json.get("storagePools", [])
    if len(port_bind_type_data) == 0:
        return 2
    service_type = port_bind_type_data[0].get("serviceType")
    if service_type == 1:
        return 1
    return 0


def check_version_result(base_uri, rest, progress_map, observer):
    progress_map[ITEM_ID] = 20
    observer.updateProgress(progress_map)
    cmd_str = "{}/api/v2/network_service/servers".format(base_uri)
    client_data = {}
    port_bind_type_json = CommonRestService.execute_post_request(rest, cmd_str, client_data)
    port_bind_type_data = port_bind_type_json.get("data", [])
    result_ip_dict = check_port_bind_type(port_bind_type_data)
    return result_ip_dict


def get_vlan_port(vlan_name, vlan_list):
    for vlan in vlan_list:
        if vlan.get("vlan_name") == vlan_name:
            return vlan.get("port_name")
    return ""


def get_bond_ports(bond_name, bond_list):
    name = []
    for bond in bond_list:
        if bond.get("bond_name") == bond_name:
            for port in bond.get("physical_ports"):
                name.append(port.get("port_name"))
            break
    return name


def get_port(port_name, ports_list):
    for port in ports_list:
        if port.get("port_name") == port_name:
            return port.get("port_name")
    return ""


def check_port_bind_type(port_bind_type_data):
    result_dict = {}
    for record in port_bind_type_data:
        roles = record.get("role")
        if "storage" not in roles:
            continue
        backend_ports, front_ports, info = get_platform_port_info(record)
        management_internal_ip = record.get("management_internal_ip")

        LOGGER.logInfo("info is {}".format(info))
        vlans = []
        bonds = []
        ports = []
        has_error = False
        for _, val in info.items():
            if val == "error":
                result_dict.update({management_internal_ip: "platform_error"})
                has_error = True
                continue
            vlans = vlans + val.get("vlan")
            bonds = bonds + val.get("bond")
            ports = ports + val.get("port")
        if has_error:
            result_dict.update({management_internal_ip: "platform_error"})
            continue
        if len(vlans) != len(set(vlans)):
            result_dict.update({management_internal_ip: "platform_error"})
            continue
        if len(bonds) == len(set(bonds)) and len(ports) == len(set(ports)):
            result_dict.update({management_internal_ip: "both_front_backend_and_self_manage_self_iscsi"}) \
                if len(backend_ports) == 0 else result_dict.update(
                {management_internal_ip: "self_backend_and_self_front_and_self_manage_self_iscsi"})
            continue
        if info.get("manage").get("bond") == info.get("front").get("bond") and len(ports) == len(set(ports)) + 2:
            result_dict.update(
                {management_internal_ip: "self_backend_and_both_front_manage_split_by_vlan_and_self_iscsi"})
            continue
        if info.get("manage").get("bond") == info.get("back").get("bond") and len(ports) == len(set(ports)) + 2:
            result_dict.update(
                {management_internal_ip: "self_front_and_both_backend_manage_split_by_vlan_and_self_iscsi"})
            continue
        result_dict.update({management_internal_ip: "platform_error"})
    return result_dict


def get_platform_port_info(record):
    bond_list = record.get("bond_list", [])
    ip_address_list = record.get("ip_address_list", [])
    vlan_list = record.get("vlan_list", [])
    ports_list = record.get("physical_ports", [])
    front_ports = []
    backend_ports = []
    manage_ports = []
    manage_out_ports = []
    iscsi_ports = []
    info = {}
    ## 获取各平面IP对应的网口
    for ip_address in ip_address_list:
        ip_usage_list = ip_address.get("ip_usage")
        if "storage_frontend" in ip_usage_list:
            front_ports.append(ip_address.get("port_name"))
        if "storage_backend" in ip_usage_list and "storage_frontend" not in ip_usage_list:
            backend_ports.append(ip_address.get("port_name"))
        if "management_internal" in ip_usage_list:
            manage_ports.append(ip_address.get("port_name"))
        if "management_external" in ip_usage_list and "management_internal" not in ip_usage_list:
            manage_out_ports.append(ip_address.get("port_name"))
        if "iscsi" in ip_usage_list:
            iscsi_ports.append(ip_address.get("port_name"))
    handle_front(bond_list, front_ports, info, ports_list, vlan_list)
    handle_backend(backend_ports, bond_list, info, ports_list, vlan_list)
    handle_iscsi(bond_list, info, iscsi_ports, ports_list, vlan_list)
    if len(manage_ports) > 1 or len(manage_ports) == 0:
        info.update({"manage": "error"})
    info.update({"manage": get_manage_infos(manage_ports[0], vlan_list, bond_list, ports_list)})
    if len(manage_out_ports) > 1:
        info.update({"manage_out": "error"})
    if len(manage_out_ports) == 1:
        info.update({"manage_out": get_manage_infos(manage_out_ports[0], vlan_list, bond_list, ports_list)})
    return backend_ports, front_ports, info


def handle_iscsi(bond_list, info, iscsi_ports, ports_list, vlan_list):
    if len(iscsi_ports) > 0:
        if len(iscsi_ports) == 1:
            info.update({"iscsi": get_storage_infos_for_bond(iscsi_ports[0], vlan_list, bond_list, ports_list)})
        else:
            info.update({"iscsi": "error"})


def handle_backend(backend_ports, bond_list, info, ports_list, vlan_list):
    if len(backend_ports) > 0:
        if len(backend_ports) > 1:
            info.update({"back": get_storage_infos_for_muti(backend_ports, vlan_list, ports_list)})
        else:
            info.update({"back": get_storage_infos_for_bond(backend_ports[0], vlan_list, bond_list, ports_list)})


def handle_front(bond_list, front_ports, info, ports_list, vlan_list):
    if len(front_ports) > 1:
        info.update({"front": get_storage_infos_for_muti(front_ports, vlan_list, ports_list)})
    else:
        info.update({"front": get_storage_infos_for_bond(front_ports[0], vlan_list, bond_list, ports_list)})


def get_storage_infos_for_muti(front_ports, vlan_list, ports_list):
    vlan_ports = []
    nic_ports = []
    for front_port in front_ports:
        port_name = get_vlan_port(front_port, vlan_list)
        if port_name == "":
            return "error"
        port_name = get_port(port_name, ports_list)
        if port_name == "":
            return "error"
        vlan_ports.append(front_port)
        nic_ports.append(port_name)
    return {"vlan": vlan_ports, "bond": [], "port": nic_ports}


def get_storage_infos_for_bond(front_port, vlan_list, bond_list, ports_list):
    nic_ports = []
    vlan_name = []
    bond_name = get_vlan_port(front_port, vlan_list)
    if bond_name == "":
        bond_name = front_port
    else:
        vlan_name.append(front_port)

    bond_port = get_bond_ports(bond_name, bond_list)
    if len(bond_port) != 2:
        return "error"
    for nic in bond_port:
        port_name = get_port(nic, ports_list)
        if port_name == "":
            return "error"
        nic_ports.append(port_name)
    return {"vlan": vlan_name, "bond": [bond_name], "port": nic_ports}


def get_manage_infos(front_port, vlan_list, bond_list, ports_list):
    name = get_vlan_port(front_port, vlan_list)
    if name != "":
        vlan_name = front_port
        bond_port = get_bond_ports(name, bond_list)
        if len(bond_port) == 2:
            nic_ports = check_bond_ports(bond_port, ports_list)
            if len(nic_ports) != 2:
                return "error"
            return {"vlan": [vlan_name], "bond": [name], "port": nic_ports}
        if len(bond_port) != 0:
            return "error"
        port_name = get_port(name, ports_list)
        if port_name == "":
            return "error"
        return {"vlan": [vlan_name], "bond": [], "port": [port_name]}
    bond_port = get_bond_ports(front_port, bond_list)
    if len(bond_port) != 0:
        if len(bond_port) != 2:
            return "error"
        nic_ports = check_bond_ports(bond_port, ports_list)
        if len(nic_ports) != 2:
            return "error"
        return {"vlan": [], "bond": [front_port], "port": nic_ports}
    port_name = get_port(front_port, ports_list)
    if port_name == "":
        return "error"
    return {"vlan": [], "bond": [], "port": [port_name]}


def check_bond_ports(bond_port, ports_list):
    nic_ports = []
    for nic in bond_port:
        port_name = get_port(nic, ports_list)
        if port_name != "":
            nic_ports.append(port_name)
    return nic_ports


def get_ip_msg(port_map, ip_address, ip_usage_list, node_ip_list, vlan_list):
    ip_dict = {}
    if "storage_frontend" in ip_usage_list and "storage_backend" in ip_usage_list:
        front_back_list = ["storage_frontend", "storage_backend"]
        if vlan_list:
            # 获取vlan
            vlan_map = {}
            for vlan in vlan_list:
                vlan_map.update({vlan.get("vlan_name"): vlan.get("port_name")})
            vlan_port_name = vlan_map.get(ip_address.get("port_name"))
            bond_name = port_map.get(vlan_port_name)
        else:
            bond_name = port_map.get(ip_address.get("port_name"))
        storage_ip = ip_address.get("ip_address")
        ip_dict.update({"ipaddress": storage_ip, "ip_usage": front_back_list, "port": bond_name})
        node_ip_list.append(ip_dict)
        return
    if "storage_frontend" in ip_usage_list:
        if vlan_list:
            # 获取vlan
            vlan_map = {}
            for vlan in vlan_list:
                vlan_map.update({vlan.get("vlan_name"): vlan.get("port_name")})
            vlan_port_name = vlan_map.get(ip_address.get("port_name"))
            bond_front = port_map.get(vlan_port_name)
        else:
            bond_front = port_map.get(ip_address.get("port_name"))
        storage_ip = ip_address.get("ip_address")
        ip_dict.update({"ipaddress": storage_ip, "ip_usage": "storage_frontend", "port": bond_front})
        node_ip_list.append(ip_dict)
        return
    if "storage_backend" in ip_usage_list:
        if vlan_list:
            # 获取vlan
            vlan_map = {}
            for vlan in vlan_list:
                vlan_map.update({vlan.get("vlan_name"): vlan.get("port_name")})
            vlan_port_name = vlan_map.get(ip_address.get("port_name"))
            bond_back = port_map.get(vlan_port_name)
        else:
            bond_back = port_map.get(ip_address.get("port_name"))
        storage_ip = ip_address.get("ip_address")
        ip_dict.update({"ipaddress": storage_ip, "ip_usage": "storage_backend", "port": bond_back})
        node_ip_list.append(ip_dict)
