# coding: UTF-8
from pprint import pformat
from time import time
import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException
import common
from ds_rest_util import CommonRestService
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = u'not_splitted_dual_ns_rep_async_pair'
SPLITTED = u'26'
FILE_SYSTEM = u'40'
ASYNC_REPLICATION = u'2'
IS_PRIMARY = u'true'
# 五分钟超时
TIMEOUT = 300
MAX_PAIR_CNT_EACH_REQ = 40
isPrimaryExists = False
isSecondaryExists = False
primaryPairs = []
secondaryPairs = []
executionRecords = []
allRepPairs = []


def checkPairs(repPairs):

    global isPrimaryExists
    global isSecondaryExists
    global primaryPairs
    global secondaryPairs
    global executionRecords
    for i, pair in enumerate(repPairs):
        if pair.get('RUNNINGSTATUS') == SPLITTED:
            # 是分裂状态
            continue
        if pair.get('LOCALRESTYPE') != FILE_SYSTEM:
            # 不是FS
            continue
        if pair.get('REPLICATIONMODEL') != ASYNC_REPLICATION:
            # 不是异步复制
            continue
        if pair.get('ISPRIMARY') == IS_PRIMARY:
            isPrimaryExists = True
            primaryPairs.append(pformat(pair.get('ID'), indent=4, width=1))
        else:
            isSecondaryExists = True
            secondaryPairs.append(pformat(pair.get('ID'), indent=4, width=1))
    executionRecords.append('[ * ] Primaries: \n' + pformat(primaryPairs, indent=4, width=1))
    executionRecords.append('[ * ] Secondaries: \n' + pformat(secondaryPairs, indent=4, width=1))
    isInspectationPassed = not (isPrimaryExists and isSecondaryExists)
    return isInspectationPassed


def requestRepPairs(rest, baseURI, startIndex):

    global executionRecords
    global allRepPairs
    # 接口每次查询数量最大为MAX_PAIR_CNT_EACH_REQ
    cmdStr = "{}/dsware/service/v1.3/REPLICATIONPAIR/?range=[{}-{}]".format(
        baseURI, startIndex, startIndex + MAX_PAIR_CNT_EACH_REQ)
    executionRecords.append('[-->] ' + cmdStr)
    response = CommonRestService.exec_get_gor_big_by_ds(rest, cmdStr)
    executionRecords.append('[<--] ' + pformat(response, indent=4, width=1))
    repPairs = response.get("data")
    executionRecords.append('[ * ] ' + 'Got replication pairs: {} + {}'.format(len(allRepPairs), len(repPairs)))
    allRepPairs += repPairs
    return repPairs


def get_cluster_json(base_uri, rest):
    """
    批量查询复制集群信息
    :param base_uri: str
    :param rest: class
    :return: tuple
    """
    cmd_str = "{}/dsware/service/serviceCmd".format(base_uri)
    client_data = {
        "op": "drCmd",
        "serviceType": "dr",
        "subOp": "queryControlCluster",
    }
    pools_json = CommonRestService.execute_post_request(rest, cmd_str,
                                                        client_data)
    ret_tuple = (cmd_str, str(pools_json))
    return pools_json, ret_tuple


def doesClusterExist(baseURI, rest):

    global executionRecords
    # 获取复制集群ID
    poolsJson, resTuple = get_cluster_json(baseURI, rest)
    executionRecords.extend(resTuple)
    if not poolsJson.get('serviceCmdData'):
        # 没有复制集群
        return False
    return True


def execute(rest):

    global isPrimaryExists
    global isSecondaryExists
    global primaryPairs
    global secondaryPairs
    global executionRecords
    try:
        devNode = py_java_env.get("devInfo")
        observer = py_java_env.get("progressObserver")
        targetVersion, productVersion = '8.1.0', str(devNode.getProductVersion())
        # 非8.1.0版本不涉及此巡检项
        if productVersion[:len(targetVersion)] != targetVersion:
            return (common.INSPECT_NOSUPPORT, "\n".join(executionRecords), "")
        observer.updateProgress({ITEM_ID: 10})
        repPairs, baseURI = [], RestUtil.getDstorageUrlHead(devNode)
        if not doesClusterExist(baseURI, rest):
            return (common.INSPECT_PASS, '\n'.join(executionRecords), '')
        # 1. 有NAS异步复制，且2. 既有主又有从，且3. 状态不为分裂，则检查失败
        startIndex, startTime = 0, time()
        while True:
            timeCost = time() - startTime
            if timeCost > TIMEOUT:
                executionRecords.append('[ * ] ' + 'Got replication pairs: %d' % len(repPairs))
                executionRecords.append('[ ! ] Timeout: {} seconds.'.format(TIMEOUT))
                return (
                    common.INSPECT_UNNORMAL,
                    '\n'.join(executionRecords),
                    'Querying replication pairs information failed with timeout: {} seconds.'.format(timeCost))
            repPairs = requestRepPairs(rest, baseURI, startIndex)
            startIndex += MAX_PAIR_CNT_EACH_REQ
            isInspectationPassed = checkPairs(repPairs)
            if not isInspectationPassed:
                return (
                    common.INSPECT_UNNORMAL,
                    "\n".join(executionRecords),
                    common.get_err_msg(
                        LANG,
                        "not_splitted_dual_ns_rep_async_pair.result.not.pass",
                        (
                            pformat(primaryPairs, indent=4, width=1),
                            pformat(secondaryPairs, indent=4, width=1))))
            if len(repPairs) < MAX_PAIR_CNT_EACH_REQ:
                break
        return common.INSPECT_PASS, "\n".join(executionRecords), ''
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
    return (
        common.INSPECT_UNNORMAL,
        "\n".join(executionRecords),
        common.get_err_msg(LANG, "query.result.abnormal"))
