# coding: UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException
import cli_util
import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
ITEM_ID = "port_type"


def execute(rest):
    """
    检查集群节点绑定模式
    :param
    :return:
    """
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progressMap = dict()
    try:
        progressMap[ITEM_ID] = 1
        observer.updateProgress(progressMap)
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        product_version = str(dev_node.getProductVersion())
        result_ip_dict = {}
        if "8.0.1" in product_version:
            result_ip_dict = check_version_one_result(base_uri, ret_list, rest, progressMap, observer)
            if result_ip_dict is None:
                ret_list.append(common.get_err_msg(LANG, "query.version.bond.result.pass", product_version))
                return common.INSPECT_PASS, "\n".join(ret_list), ""
        elif "8.1.0" in product_version or "8.1.1" in product_version:
            result_ip_dict = check_version_result(base_uri, ret_list, rest, progressMap, observer)
        else:
            ret_list.append(common.get_err_msg(LANG, "query.version.na", product_version))
            return common.INSPECT_NOSUPPORT, "\n".join(ret_list), ""
        # 获取第一个节点的前后端绑定模式
        node_ip_list = result_ip_dict.values()[0]
        num = node_bond_mode(node_ip_list, result_ip_dict)
        bond_mode_diff = {
            1: "front_back.bond_mode.diff",
            2: "front.bond_mode.diff",
            3: "back.bond_mode.diff"
        }
        all_ret = common.save_cli_ret_to_file(
            ret_list, ITEM_ID, PY_JAVA_ENV, LOGGER
        )
        if num in bond_mode_diff:
            return common.INSPECT_UNNORMAL, all_ret, ""
        else:
            return common.INSPECT_PASS, all_ret, ""
    except (IsmException, Exception) as ep:
        LOGGER.logException(ep)
        ret_list.append(common.get_err_msg(LANG, "query.result.abnormal"))
        return common.INSPECT_UNNORMAL, "\n".join(ret_list), ""


# 比较节点存储前后端的绑定模式
def node_bond_mode(node_ip_list, result_ip_dict):
    node_bond = None
    node_front_bond = None
    node_back_bond = None
    for node_ip in node_ip_list:
        if "storage_frontend" in node_ip.get("ip_usage") and "storage_backend" in node_ip.get("ip_usage"):
            node_bond = node_ip.get("bond_mode")
        if "storage_frontend" in node_ip.get("ip_usage"):
            node_front_bond = node_ip.get("bond_mode")
        if "storage_backend" in node_ip.get("ip_usage"):
            node_back_bond = node_ip.get("bond_mode")
    # 比较所有节点前后端绑定模式
    node_list = list(result_ip_dict.values())
    for node_map in node_list:
        for node in node_map:
            if "storage_frontend" in node.get("ip_usage") and "storage_backend" in node.get("ip_usage") and node.get(
                    "bond_mode") != node_bond:
                return 1
            if "storage_frontend" in node.get("ip_usage") and node.get("bond_mode") != node_front_bond:
                return 2
            if "storage_backend" in node.get("ip_usage") and node.get("bond_mode") != node_back_bond:
                return 3
    return 4


# 801版本
def check_version_one_result(base_uri, ret_list, rest, progressMap, observer):
    cmd_str = "{}/api/v2/network_service/network_platform?network_type=storage_frontend".format(base_uri)
    bond_model_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
    respData = bond_model_json.get("data", [])
    if respData.get("bond_mode") == "" or respData.get("bond_mode") is None:
        result_ip_dict = None
        return result_ip_dict
    else:
        progressMap[ITEM_ID] = 10
        observer.updateProgress(progressMap)
        cmd_str = "{}/api/v2/network_service/servers".format(base_uri)
        client_data = {}
        port_bind_type_json = CommonRestService.execute_post_request(rest, cmd_str, client_data)
        portBindTypeData = port_bind_type_json.get("data", [])
        result_ip_dict = check_port_bind_type(ret_list, portBindTypeData)
        return result_ip_dict


# 810/811版本
def check_version_result(base_uri, ret_list, rest, progressMap, observer):
    progressMap[ITEM_ID] = 20
    observer.updateProgress(progressMap)
    cmd_str = "{}/api/v2/network_service/servers".format(base_uri)
    client_data = {}
    port_bind_type_json = CommonRestService.execute_post_request(rest, cmd_str, client_data)
    portBindTypeData = port_bind_type_json.get("data", [])
    result_ip_dict = check_port_bind_type(ret_list, portBindTypeData)
    return result_ip_dict


def check_port_bind_type(ret_list, portBindTypeData):
    result_dict = {}
    for record in portBindTypeData:
        bond_list = record.get("bond_list", [])
        ip_address_list = record.get("ip_address_list", [])
        vlan_list = record.get("vlan_list", [])
        # 获取绑定模式的map
        bond_mode_map = {}
        for bond in bond_list:
            bond_mode_map.update({bond.get("bond_name"): bond.get("bond_mode")})
        management_internal_ip = record.get("management_internal_ip")
        node_ip_list = []
        # 查询各节点存储前后端的绑定模式、ip、管理ip
        for ip_address in ip_address_list:
            ip_usage_list = ip_address.get("ip_usage")
            get_ip_msg(bond_mode_map, ip_address, ip_usage_list, node_ip_list, vlan_list)
        result_dict[management_internal_ip] = node_ip_list
        ret_list.append(cli_util.get_format_header_ret(management_internal_ip, str(node_ip_list)))
    return result_dict


def get_ip_msg(bond_mode_map, ip_address, ip_usage_list, node_ip_list, vlan_list):
    ip_dict = {}
    if "storage_frontend" in ip_usage_list and "storage_backend" in ip_usage_list:
        front_back_list = ["storage_frontend", "storage_backend"]
        if vlan_list:
            # 获取vlan
            vlan_map = {}
            for vlan in vlan_list:
                vlan_map.update({vlan.get("vlan_name"): vlan.get("port_name")})
            vlan_port_name = vlan_map.get(ip_address.get("port_name"))
            bond_name = bond_mode_map.get(vlan_port_name)
        else:
            bond_name = bond_mode_map.get(ip_address.get("port_name"))
        storage_ip = ip_address.get("ip_address")
        ip_dict.update({"ipaddress": storage_ip, "ip_usage": front_back_list, "bond_mode": bond_name})
        node_ip_list.append(ip_dict)
        return
    if "storage_frontend" in ip_usage_list:
        if vlan_list:
            # 获取vlan
            vlan_map = {}
            for vlan in vlan_list:
                vlan_map.update({vlan.get("vlan_name"): vlan.get("port_name")})
            vlan_port_name = vlan_map.get(ip_address.get("port_name"))
            bond_front = bond_mode_map.get(vlan_port_name)
        else:
            bond_front = bond_mode_map.get(ip_address.get("port_name"))
        storage_ip = ip_address.get("ip_address")
        ip_dict.update({"ipaddress": storage_ip, "ip_usage": "storage_frontend", "bond_mode": bond_front})
        node_ip_list.append(ip_dict)
        return
    if "storage_backend" in ip_usage_list:
        if vlan_list:
            # 获取vlan
            vlan_map = {}
            for vlan in vlan_list:
                vlan_map.update({vlan.get("vlan_name"): vlan.get("port_name")})
            vlan_port_name = vlan_map.get(ip_address.get("port_name"))
            bond_back = bond_mode_map.get(vlan_port_name)
        else:
            bond_back = bond_mode_map.get(ip_address.get("port_name"))
        storage_ip = ip_address.get("ip_address")
        ip_dict.update({"ipaddress": storage_ip, "ip_usage": "storage_backend", "bond_mode": bond_back})
        node_ip_list.append(ip_dict)
