# coding: UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException
import cli_util
import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
ITEM_ID = "port_type_info"
HANDLE = py_java_env.get("preInspectHandle")
PRE_ITEM_ID = "osInfoForNetworkSiteDeployment"


def execute(rest):
    """
    检查集群节点绑定模式
    :param
    :return:
    """
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progress_map = dict()
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        product_version = str(dev_node.getProductVersion())
        result_ip_dict = {}
        if not is_involve_product_version(product_version):
            return common.INSPECT_NOSUPPORT, "\n no support version", common.get_err_msg(LANG, "query.version.na",
                                                                                         product_version)
        is_block_res = is_block(base_uri, rest, progress_map, observer)
        if is_block_res == 2:
            msg = common.get_err_msg(LANG, "fsm.device.not.has.pool")
            return common.INSPECT_UNNORMAL, msg, msg
        if is_block_res == 0:
            msg = common.get_err_msg(LANG, "query.version.na", product_version)
            return common.INSPECT_NOSUPPORT, msg, msg
        if check_not_support(dev_node):
            msg = common.get_err_msg(LANG, "query.version.na", product_version)
            return common.INSPECT_NOSUPPORT, msg, msg
        result_ip_dict = check_version_result(base_uri, ret_list, rest, progress_map, observer)
        # 获取第一个节点的前后端绑定模式
        num = node_bond_mode(result_ip_dict)
        bond_mode_diff = {
            1: "front.bond_mode.diff",
            2: "back.bond_mode.diff"
        }
        all_ret = common.save_cli_ret_to_file(
            ret_list, ITEM_ID, PY_JAVA_ENV, LOGGER
        )
        if num in bond_mode_diff:
            return common.INSPECT_UNNORMAL, all_ret, ""
        else:
            return common.INSPECT_PASS, all_ret, ""
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        ret_list.append(common.get_err_msg(LANG, "query.result.abnormal"))
        return common.INSPECT_UNNORMAL, "\n".join(ret_list), ""


def check_not_support(dev_node):
    for cluster_node in dev_node.getClusterNodes():
        roles = cluster_node.getRoles()
        if "storage" not in roles:
            continue
        node_ip = common.get_node_ip(cluster_node)
        ret = HANDLE.getPreInspectResult(node_ip, PRE_ITEM_ID)
        if ret != "not_support":
            return False
    return True


def is_block(base_uri, rest, progress_map, observer):
    progress_map[ITEM_ID] = 50
    observer.updateProgress(progress_map)
    cmd_str = "{}/dsware/service/resource/queryStoragePool?baseInfo=false".format(base_uri)
    port_bind_type_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
    port_bind_type_data = port_bind_type_json.get("storagePools", [])
    if len(port_bind_type_data) == 0:
        return 2
    service_type = port_bind_type_data[0].get("serviceType")
    if service_type == 1:
        return 1
    return 0


def is_involve_product_version(product_version):
    """
    检查版本信息：813之前的版本暂不支持该巡检项
    """
    version = product_version.replace('.', "")
    if version[0:2] > "81":
        return True
    if version[0:2] == "81" and version[2].isdigit() and version[2] >= "3":
        return True
    if len(version) >= 5:
        if version[0:2] == "81" and version[2:4] == "RC" and version[4] >= "6":
            return True
    return False


# 初始化节点bond模式
def init_platform_bond_map(node_list):
    for node_map in node_list:
        for node_ip in node_map:
            if "storage_frontend" in node_ip.get("ip_usage"):
                node_front_bond = node_ip.get("bond_mode")
            if "storage_backend" in node_ip.get("ip_usage"):
                node_back_bond = node_ip.get("bond_mode")
    return node_front_bond, node_back_bond


# 比较节点存储前后端的绑定模式
def node_bond_mode(result_ip_dict):
    node_list = list(result_ip_dict.values())
    node_front_bond, node_back_bond = init_platform_bond_map(node_list)
    # 比较所有节点前后端绑定模式
    for node_map in node_list:
        for node in node_map:
            if "storage_frontend" in node.get("ip_usage") and node.get("bond_mode") != node_front_bond:
                LOGGER.logInfo("node " + node.get("ipaddress") + "bond mode check error, frontend.bond_mode.diff")
                return 1
            if "storage_backend" in node.get("ip_usage") and node.get("bond_mode") != node_back_bond:
                LOGGER.logInfo("node " + node.get("ipaddress") + "bond mode check error, back.bond_mode.diff")
                return 2
    return 0


def check_version_result(base_uri, ret_list, rest, progress_map, observer):
    progress_map[ITEM_ID] = 20
    observer.updateProgress(progress_map)
    cmd_str = "{}/api/v2/network_service/servers".format(base_uri)
    client_data = {}
    port_bind_type_json = CommonRestService.execute_post_request(rest, cmd_str, client_data)
    port_bind_type_data = port_bind_type_json.get("data", [])
    result_ip_dict = check_port_bind_type(ret_list, port_bind_type_data)
    return result_ip_dict


def check_port_bind_type(ret_list, port_bind_type_data):
    result_dict = {}
    for record in port_bind_type_data:
        bond_list = record.get("bond_list", [])
        ip_address_list = record.get("ip_address_list", [])
        vlan_list = record.get("vlan_list", [])
        role_list = record.get("role", [])
        # 过滤纯管理节点
        if len(role_list) == 1 and role_list[0] == "management":
            continue
        # 获取绑定模式的map
        bond_mode_map = {}
        for bond in bond_list:
            bond_mode_map.update({bond.get("bond_name"): bond.get("bond_mode")})
        management_internal_ip = record.get("management_internal_ip")
        node_ip_list = []
        # 查询各节点存储前后端的绑定模式、ip、管理ip
        for ip_address in ip_address_list:
            ip_usage_list = ip_address.get("ip_usage")
            get_ip_msg(bond_mode_map, ip_address, ip_usage_list, node_ip_list, vlan_list)
        result_dict[management_internal_ip] = node_ip_list
        ret_list.append(cli_util.get_format_header_ret(management_internal_ip, str(node_ip_list)))
    return result_dict


def get_ip_msg(bond_mode_map, ip_address, ip_usage_list, node_ip_list, vlan_list):
    ip_dict = {}
    if "storage_frontend" in ip_usage_list and "storage_backend" in ip_usage_list:
        front_back_list = ["storage_frontend", "storage_backend"]
        if vlan_list:
            # 获取vlan
            vlan_map = {}
            for vlan in vlan_list:
                vlan_map.update({vlan.get("vlan_name"): vlan.get("port_name")})
            vlan_port_name = vlan_map.get(ip_address.get("port_name"))
            bond_name = bond_mode_map.get(vlan_port_name)
            if bond_name is None:
                bond_name = bond_mode_map.get(ip_address.get("port_name"))
        else:
            bond_name = bond_mode_map.get(ip_address.get("port_name"))
        storage_ip = ip_address.get("ip_address")
        ip_dict.update({"ipaddress": storage_ip, "ip_usage": front_back_list, "bond_mode": bond_name})
        node_ip_list.append(ip_dict)
        return
    if "storage_frontend" in ip_usage_list:
        if vlan_list:
            # 获取vlan
            vlan_map = {}
            for vlan in vlan_list:
                vlan_map.update({vlan.get("vlan_name"): vlan.get("port_name")})
            vlan_port_name = vlan_map.get(ip_address.get("port_name"))
            bond_front = bond_mode_map.get(vlan_port_name)
            if bond_front is None:
                bond_front = bond_mode_map.get(ip_address.get("port_name"))
        else:
            bond_front = bond_mode_map.get(ip_address.get("port_name"))
        storage_ip = ip_address.get("ip_address")
        ip_dict.update({"ipaddress": storage_ip, "ip_usage": "storage_frontend", "bond_mode": bond_front})
        node_ip_list.append(ip_dict)
        return
    if "storage_backend" in ip_usage_list:
        if vlan_list:
            # 获取vlan
            vlan_map = {}
            for vlan in vlan_list:
                vlan_map.update({vlan.get("vlan_name"): vlan.get("port_name")})
            vlan_port_name = vlan_map.get(ip_address.get("port_name"))
            bond_back = bond_mode_map.get(vlan_port_name)
            if bond_back is None:
                bond_back = bond_mode_map.get(ip_address.get("port_name"))
        else:
            bond_back = bond_mode_map.get(ip_address.get("port_name"))
        storage_ip = ip_address.get("ip_address")
        ip_dict.update({"ipaddress": storage_ip, "ip_usage": "storage_backend", "bond_mode": bond_back})
        node_ip_list.append(ip_dict)
