# coding: UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
import re
import string
import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
import common
from com.huawei.ism.exception import IsmException
from check_pool_num import CheckPoolNumUtil
from ds_rest_util import CommonRestService

import cli_util
import common
import hardware_util
import redfish_util
import entity

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
ITEM_ID = "route_same"
LANG = common.getLang(py_java_env)
HANDLE = py_java_env.get("preInspectHandle")
RES_KEY = "OS_Image_Ver"
PRE_ITEM_ID = "routeInfo"


def execute(rest):
    """
    检查集群节点网络平面
    :param
    :return:
    """
    item = common.ItemEntity(py_java_env, ITEM_ID, PY_LOGGER, __file__)
    item.update_progress(1)
    dev_node = py_java_env.get("devInfo")
    ret_list = []
    observer = py_java_env.get("progressObserver")
    progress_map = dict()
    try:
        observer.updateProgress(progress_map)
        product_version = str(dev_node.getProductVersion())
        if not is_involve_product_version(product_version):
            return common.INSPECT_NOSUPPORT, "\n no support version", common.get_err_msg(LANG, "query.version.na",
                                                                                         product_version)
        base_uri = RestUtil.getDstorageUrlHead(dev_node)
        is_block_res, all_block_ips = is_block(base_uri, rest, progress_map, observer)
        if is_block_res == 2:
            msg = common.get_err_msg(LANG, "fsm.device.not.has.pool")
            return common.INSPECT_UNNORMAL, msg, msg
        if is_block_res == 0:
            msg = common.get_err_msg(LANG, "query.version.na", product_version)
            return common.INSPECT_NOSUPPORT, msg, msg
        if check_not_support(dev_node):
            msg = common.get_err_msg(LANG, "query.version.na", product_version)
            return common.INSPECT_NOSUPPORT, msg, msg

        policy, static = get_route_infos(all_block_ips, dev_node)
        LOGGER.logInfo("policy info {}".format(policy))
        LOGGER.logInfo("static info {}".format(static))
        for pool_id, policy_route_arr in policy.items():
            if not check_arr_def(policy_route_arr):
                msg = common.get_err_msg(LANG, "node.route.error", pool_id)
                return common.INSPECT_UNNORMAL, msg, msg
        for pool_id, static_route_arr in static.items():
            if not check_arr_def(static_route_arr):
                msg = common.get_err_msg(LANG, "node.route.error", pool_id)
                return common.INSPECT_UNNORMAL, msg, msg
        return common.INSPECT_PASS, common.get_err_msg(LANG, "fsm.pass"), ""
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return item.get_failed_result(common.get_err_msg(
            LANG, "query.result.abnormal"))


def check_not_support(dev_node):
    for cluster_node in dev_node.getClusterNodes():
        roles = cluster_node.getRoles()
        if "storage" not in roles:
            continue
        node_ip = common.get_node_ip(cluster_node)
        ret = HANDLE.getPreInspectResult(node_ip, PRE_ITEM_ID)
        if ret != "not_support":
            return False
    return True


def get_route_infos(all_block_ips, dev_node):
    policy = {}
    static = {}
    ip_len = 0
    for cluster_node in dev_node.getClusterNodes():
        roles = cluster_node.getRoles()
        if "storage" in roles:
            ip_len = ip_len + 1
        else:
            continue
        node_ip = common.get_node_ip(cluster_node)
        pool_id = get_ip_id(node_ip, all_block_ips)
        if pool_id == -1:
            continue
        ret = HANDLE.getPreInspectResult(node_ip, PRE_ITEM_ID)
        routes = ret.strip().split('，')
        LOGGER.logInfo("route info {}".format(routes))
        for route_info in routes:
            if "policy" in route_info:
                check_bond_ports(pool_id, node_ip, route_info, policy)
            else:
                get_static_infos(pool_id, node_ip, route_info, static)
    return policy, static


def is_involve_product_version(product_version):
    """
    检查版本信息：813之前的版本暂不支持该巡检项
    """
    version = product_version.replace('.', "")
    if version[0:2] > "81":
        return True
    if version[0:2] == "81" and version[2].isdigit() and version[2] >= "3":
        return True
    if len(version) >= 5:
        if version[0:2] == "81" and version[2:4] == "RC" and version[4] >= "6":
            return True
    return False


def get_ip_id(node_ip, all_ips):
    for key, val in all_ips.items():
        if node_ip in val:
            return key
    return -1


def check_arr_def(arr):
    arr_list = list(arr.values())
    if len(arr_list) <= 1:
        return True
    num = 0
    index = 0
    for route_info in arr_list:
        if index == 0:
            num = len(route_info)
            index = index + 1
        if num != len(route_info):
            return False

    first = arr_list[0]
    index = 0
    for item in first:
        for route in arr_list:
            index = index + 1
            if "error" in route:
                return False
            if index == 1:
                continue
            if item not in route:
                return False

    return True


def is_block(base_uri, rest, progress_map, observer):
    progress_map[ITEM_ID] = 50
    observer.updateProgress(progress_map)
    cmd_str = "{}/dsware/service/resource/queryStoragePool?baseInfo=false".format(base_uri)
    port_bind_type_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
    port_bind_type_data = port_bind_type_json.get("storagePools", [])
    if len(port_bind_type_data) == 0:
        return 2, {}
    service_type = port_bind_type_data[0].get("serviceType")
    if service_type == 1:
        return get_pool_ips(base_uri, port_bind_type_data, rest)
    return 0, []


def get_pool_ips(base_uri, port_bind_type_data, rest):
    all_ip = {}
    for data in port_bind_type_data:
        ips = []
        pool_id = data.get("poolId")
        cmd_str = "{}/api/v2/data_service/diskpool?storagePoolId={}".format(base_uri, pool_id)
        json_res = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        data_res = json_res.get("diskPools", [])
        for disk in data_res:
            disk_id = disk.get("poolId")
            cmd_str = "{}/dsware/service/cluster/diskpool/queryNodeDiskInfo?diskPoolId={}".format(base_uri, disk_id)
            disk_res = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
            dist_data = disk_res.get("nodeInfo", [])
            for node_info in dist_data:
                ips.append(node_info.get("nodeMgrIp"))
        all_ip.update({pool_id: ips})
    return 1, all_ip


def check_bond_ports(pool_id, node_ip, info, all_route):
    if info == "":
        return
    LOGGER.logInfo("info is {}".format(info))
    policy_routes = info.strip().split('=')
    if len(policy_routes) <= 1:
        return
    policy_list = policy_routes[1].strip().split(',')
    if pool_id not in all_route:
        all_route.update({pool_id: {}})
    if node_ip not in all_route.get(pool_id):
        all_route.get(pool_id).update({node_ip: []})
    for policy_route in policy_list:
        policy_route = policy_route.strip()
        if policy_route == "":
            continue
        rout = policy_route.strip().split(' ')
        route_size = len(rout)
        if route_size == 2:
            all_route.get(pool_id).get(node_ip).append("port=" + rout[0] + ",mask=" + rout[1] + ",gateway=")
            continue
        if route_size == 3:
            all_route.get(pool_id).get(node_ip).append("port=" + rout[0] + ",mask=" + rout[1] + ",gateway=" + rout[2])
            continue
        all_route.get(pool_id).get(node_ip).append("error")


def get_static_infos(pool_id, node_ip, info, all_route):
    if info == "":
        return
    LOGGER.logInfo("info is {}".format(info))
    policy_routes = info.strip().split('=')
    if len(policy_routes) <= 1:
        return
    policy_list = policy_routes[1].strip().split(',')
    if pool_id not in all_route:
        all_route.update({pool_id: {}})
    if node_ip not in all_route.get(pool_id):
        all_route.get(pool_id).update({node_ip: []})
    for policy_route in policy_list:
        policy_route = policy_route.strip()
        if policy_route == "":
            continue
        rout = policy_route.strip().split(' ')
        route_size = len(rout)
        if route_size == 3:
            all_route.get(pool_id).get(node_ip).append("dst_ip=" + rout[0] + ",port=" +
                                                       rout[1] + ",mask=" + rout[2] + ",gateway=")
            continue
        if route_size == 4:
            all_route.get(pool_id).get(node_ip).append("dst_ip=" + rout[0] + ",port=" +
                                                       rout[1] + ",mask=" + rout[2] + ",gateway=" + rout[3])
            continue
        all_route.get(pool_id).get(node_ip).append("error")
