# coding: UTF-8

import re
import common
import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "smio_check_nvme_vendor"


def get_storage_software(dev_node):
    """
    :function: 获取存储软件版本
    :param version: 节点信息
    :return: 存储软件版本
    """
    product_version = dev_node.getProductVersion()
    patch_version = dev_node.getHotPatchVersion()

    if patch_version in product_version:
        return product_version
    elif product_version in patch_version:
        return patch_version
    elif not patch_version:
        return product_version
    else:
        return product_version + "." + patch_version


def check_storage_software(version):
    """
    :function: 存储软件风险配套检查
    :param version: 当前存储软件版本
    :return: True：检查通过；False:存在风险软件配套关系
    """
    black_product_ver = (
        "8.0.1.SPH602", "8.0.1.SPH606", "8.0.1.SPH607", "8.0.1.SPH608"
    )
    # 节点nvme盘风险版本与存储软件配套检查
    for black_ver in black_product_ver:
        if black_ver == version:
            return False
    return True


def check_new_expansion_nodes_nvme_vemdor(product_version):
    """
    获取待扩节点信息
    """
    dev_scale_nodes = py_java_env.get("newExpansionNodes")
    check_ret = True
    dapu_vendor = '1e3b'
    scale_ip = []

    for scale_node in dev_scale_nodes:
        try:
            cmd = '''lspci -mm -n -D | grep 0108 | tr -d '"'| awk '{print $3}\''''
            ssh = common.get_ssh_conn(scale_node)
            nvme_vendor_rsp = ssh.execCmdWithTimout(cmd, common.HOST_CMD_SHORT_TIMEOUT)
        except Exception as exception:
            LOGGER.logException(exception)
            return (
                common.INSPECT_UNNORMAL,
                "create ssh connect and exec cmd failed",
                common.get_err_msg(LANG, "query.result.abnormal"),
            )
        finally:
            common.release_ssh_conn(ssh)

        LOGGER.logInfo("nvme_vendor_rsp:%s " % str(nvme_vendor_rsp))
        if dapu_vendor in nvme_vendor_rsp:
            LOGGER.logInfo("NodeIP:%s find one dp nvme disk" % str(scale_node))
            check_ret = False
            scale_ip.append("".join(scale_node.getIp()))
    str_scale_ip = str(scale_ip).replace('u\'', '\'')
    if check_ret:
        return common.INSPECT_PASS, "CHECK PASS, DP NVME does not exist! productVersion:{}".format(
            product_version), ""  # 风险版本内不存在dp nvme盘，没有风险
    else:
        return common.INSPECT_UNNORMAL, "productVersion:{} problem " \
                                               "nodeIP:{} do not support DUPA NVME disk".format(
            product_version, str_scale_ip), common.get_err_msg(
            LANG, "pool.storage.nvme.disk.check.vendor", (
                str_scale_ip, product_version)),  # 查出软件版本不适配dp nvme盘


def execute(rest):
    """
    检查风险存储软件版本号
    如果不在风险版本范围内，则检查通过，否则继续执行
    """
    dev_node = py_java_env.get("devInfo")
    try:
        product_version = get_storage_software(dev_node)
        software_result = check_storage_software(product_version)
        if software_result:
            return common.INSPECT_PASS, "product_version = {}".format(
                product_version), ""  # 软件版本不在风险版本列表内，没有风险

        return check_new_expansion_nodes_nvme_vemdor(product_version)
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            "",
            common.get_err_msg(LANG, "query.result.abnormal"),
        )
