# coding: UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
from com.huawei.ism.exception import IsmException

import cli_util
import common
import constant
import hardware_util
import redfish_util

ITEM_ID = "smmu_strategy"
LANG = common.getLang(py_java_env)
SMMU_KEYS = ["EnableSMMU", "OemEnableSMMU"]
SMMU_SHOULD_VALUE = "disabled"


def execute(rest_conn):
    """
    检查SMMU配置
    :param rest_conn: 集群rest连接
    :return:
    """
    item = common.ItemEntity(py_java_env, ITEM_ID, PY_LOGGER, __file__)
    item.update_progress(1)
    try:
        check(item.build_param_dict(), None, item.err_info_list, item.ret_list)
        return item.get_check_result()
    except (IsmException, Exception) as exception:
        item.logger.logException(exception)
        return item.get_failed_result(common.get_err_msg(LANG, "query.result.abnormal"))


@common.check_all_ibmc_node
def check(param_dict, cluster_dev_node, err_info_list, ret_list):
    node_ret = []
    cluster_node_ip = common.get_node_ip(cluster_dev_node)
    redfish = common.get_redfish_conn(cluster_dev_node)
    logger = param_dict.get("logger")
    try:
        # 判断服务器类型，如果不是Taishan V2的服务器，则不检查，直接通过
        uid, ret = redfish_util.get_product_unique_id(redfish, logger)
        platform_type = hardware_util.get_platform_id(uid)
        if constant.Platform.TAI_SHAN_V2 != platform_type:
            msg = "\n node type is {},do not need check.".format(platform_type)
            node_ret.append(msg)
            return

        bios_attributes, ret = redfish_util.get_all_bios_info(redfish, logger)
        node_ret.append(ret)

        target_value = None
        for key in SMMU_KEYS:
            if key in bios_attributes:
                target_value = bios_attributes.get(key)
                break
        if target_value is not None and target_value.lower() != SMMU_SHOULD_VALUE:
            err_info_list.append(common.get_err_msg(LANG, "strategy.status.not.pass", cluster_node_ip))
    except Exception as exception:
        logger.logException(exception)
        err_info_list.append(common.get_err_msg(LANG, "item.check.abnormal", cluster_node_ip))
    finally:
        ret_list.append(cli_util.get_format_header_ret(cluster_node_ip, "\n".join(node_ret)))
