# coding: UTF-8

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "snmp_security_config"
# 不安全的鉴权算法
USM_AUTH_DICT = {"2": "MD5", "3": "SHA", "4": "SHA224"}
# 不安全的加密算法
USM_PRIV_DICT = {"2": "DES", "3": "3DES"}


def execute(rest):
    """
    检查盘状态
    :param env:
    :return:
    """
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progress_map = {}
    tmp_err_list = []
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        # 查询snmp协议
        get_snmp_protocol(dev_node, rest, ret_list, tmp_err_list)
        progress_map[ITEM_ID] = 50
        observer.updateProgress(progress_map)
        # 批量查询USM用户
        get_snmp_usm(dev_node, rest, ret_list, tmp_err_list)
        all_ret = "\n".join(ret_list)
        if tmp_err_list:
            return common.INSPECT_WARNING, all_ret, "".join(tmp_err_list)
        return common.INSPECT_PASS, all_ret, ""
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            "\n".join(ret_list),
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


def get_snmp_usm(dev_node, rest, ret_list, tmp_err_list):
    base_uri = RestUtil.getDstorageUrlHead(dev_node)
    device_esn = dev_node.getDeviceSerialNumber()
    cmd_str = "{}/deviceManager/rest/{}/snmp_usm".format(base_uri, device_esn)
    ret_list.append(cmd_str)
    snmp_usm = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
    ret_list.append(str(snmp_usm))
    snmp_usm_data = snmp_usm.get("data", [])
    if snmp_usm_data:
        check_snmp_usm(snmp_usm_data, tmp_err_list)


def check_snmp_usm(snmp_usm_data, tmp_err_list):
    for usm in snmp_usm_data:
        usm_auth = usm.get("CMO_USM_AUTH_PROT")
        usm_priv = usm.get("CMO_USM_PRIV_PROT")
        usm_id = usm.get("ID")
        # 未开启鉴权算法
        if usm_auth == "1":
            tmp_err_list.append(
                common.get_err_msg(LANG, "check_snmp_usm_auth.not.pass", usm_id))
        else:
            if usm_auth in USM_AUTH_DICT.keys():
                tmp_err_list.append(
                    common.get_err_msg(LANG, "check_snmp_usm_auth_result.not.pass", (usm_id,
                                       USM_AUTH_DICT.get(usm_auth))))
        # 未开启加密算法
        if usm_priv == "1":
            tmp_err_list.append(
                common.get_err_msg(LANG, "check_snmp_usm_priv.not.pass", usm_id))
        else:
            if usm_priv in USM_PRIV_DICT.keys():
                tmp_err_list.append(
                    common.get_err_msg(LANG, "check_snmp_usm_priv_result.not.pass", (usm_id,
                                       USM_PRIV_DICT.get(usm_priv))))


def get_snmp_protocol(dev_node, rest, ret_list, tmp_err_list):
    base_uri = RestUtil.getDstorageUrlHead(dev_node)
    cmd_str = "{}/api/v2/common/snmp_protocol".format(
        base_uri
    )
    ret_list.append(cmd_str)
    snmp_protocol = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
    ret_list.append(str(snmp_protocol))
    snmp_protocol_data = snmp_protocol.get("data")
    v1v2c_enable = snmp_protocol_data.get("v1v2c_enable")
    if v1v2c_enable == 'true':
        tmp_err_list.append(
            common.get_err_msg(LANG, "check_snmp_protocol_result.not.pass"))
