# coding: UTF-8
import common
from com.huawei.ism.exception import IsmException

LANG = common.getLang(py_java_env)
ITEM_ID = "software_version_info"
VERSION_NUM = [8, 0, 1, 5]
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(rest):
    """
    检查集群版本
    :param rest: rest
    :return: 信息
    """
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progress_map = {}
    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        version = dev_node.getProductVersion()
        error_info = common.get_err_msg(LANG, "software.version.info.error",
                                        version)
        flag = check_version(version)
        if flag:
            return common.INSPECT_PASS, "", ""
        else:
            return common.INSPECT_UNNORMAL, version, error_info
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            "",
            common.get_err_msg(LANG, "query.result.abnormal"),
        )


def check_version(version):
    """
    判断是否低于8015
    :param version: 当前版本
    :return:
    """
    item = 0
    version_list = version.split(".")
    length_versions = len(version_list)
    while item < length_versions:
        if version_list[item].isdigit():
            if int(version_list[item]) < VERSION_NUM[item]:
                return False
            elif int(version_list[item]) > VERSION_NUM[item]:
                return True
            if item == length_versions - 1 and length_versions < len(
                    VERSION_NUM):
                return False
        else:
            return True
        item += 1
    return True
