# coding: UTF-8
import json
import os

from com.huawei.ism.exception import IsmException
from com.huawei.ism.tool.inspect.fit.switchcheck.check.impl import SwitchCheckService
from com.huawei.ism.tool.inspect.fit.util import DevUtil
from com.huawei.ism.tool.obase.exception import ToolException
from com.huawei.ism.tool.protocol.utils import RestUtil

import cli_util
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
NORMAL_CODE = "0"
CODE_MSG = {
    common.INSPECT_PASS: common.get_err_msg(LANG, "fsm.pass"),
    common.INSPECT_NOSUPPORT: common.get_err_msg(LANG, "not.involved"),
}
NETWORK_TYPE_URL = "{}/api/v2/network_service/network_platform"
FRONT = "storage_frontend"
BACK = "storage_backend"
ROCE_NETWORK = "RoCE"


def execute(rest):
    """
    执行交换机检查
    :param rest: rest链接，本类没有用到
    :return: 结果
    """
    dev_node = PY_JAVA_ENV.get("devInfo")
    try:
        if not is_roce_network_type(rest, dev_node):
            return common.INSPECT_NOSUPPORT, common.get_err_msg(LANG, "not.roce.net"), ""
    except ToolException as exception:
        return common.INSPECT_UNNORMAL, "", exception.getDes()
    return do_check(dev_node)


def is_roce_network(response):
    if str(response.getContentMap().getOrDefault("errorCode", "-1")) != NORMAL_CODE:
        raise ToolException("inspsctor.wizard.fs.select.dev.query.node.error")
    return ROCE_NETWORK == json.loads(str(response.getContent())).get("data", {}).get("transfer_protocol", "")


def is_roce_network_type(rest, dev_node):
    base_uri = RestUtil.getDstorageUrlHead(dev_node)
    response = rest.execGet(NETWORK_TYPE_URL.format(base_uri), {"network_type": FRONT})
    if is_roce_network(response):
        return True
    response = rest.execGet(NETWORK_TYPE_URL.format(base_uri), {"network_type": BACK})
    return is_roce_network(response)


def do_check(dev_node):
    switch_nodes = dev_node.getSwitchNodes()
    if not switch_nodes:
        return common.INSPECT_NOSUPPORT, common.get_err_msg(LANG, "no.switch.nodes"), ""
    ssh = None
    sftp = None
    try:
        auth_node = DevUtil.findAuthedStorageNode(dev_node)
        sftp = common.get_sftp_connection(auth_node)
        ssh = common.get_ssh_conn(auth_node)
        switch_check_service = SwitchCheckService(sftp, ssh, get_resource_bundle(), auth_node.getIp())
        error_msgs = switch_check_service.batchCheckSwitch(switch_nodes)
        show_msg, pass_flag = build_error_msg(error_msgs)
        if pass_flag:
            return common.INSPECT_PASS, build_switch_info_path_tips(dev_node), show_msg
        return common.INSPECT_UNNORMAL, build_switch_info_path_tips(dev_node), show_msg
    except ToolException as tool_exception:
        LOGGER.logException(tool_exception)
        return common.INSPECT_UNNORMAL, "", tool_exception.getDes()
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return common.INSPECT_UNNORMAL, "", common.get_err_msg(LANG, "query.result.abnormal")
    finally:
        release_connection(sftp, ssh)


def build_switch_info_path_tips(dev_node):
    return common.get_err_msg(LANG, "show.switch.detail.info", build_switch_path(dev_node))


def release_connection(sftp, ssh):
    if ssh:
        common.release_ssh_conn(ssh)
    if sftp:
        common.release_sftp_conn(sftp)


def build_error_msg(error_msgs):
    show_msgs = []
    pass_flag = True
    for error_msg in error_msgs:
        if error_msg.getErrorCode() == NORMAL_CODE:
            show_msgs.append(cli_util.get_format_header_ret(error_msg.getIp(), common.get_err_msg(LANG, "fsm.pass")))
            continue
        show_msgs.append(cli_util.get_format_header_ret(error_msg.getIp(), error_msg.getErrorMsg()))
        pass_flag = False
    return "\n".join(show_msgs), pass_flag


def build_switch_path(dev_node):
    return os.path.join("data", "switch", "switch_info_{}.xlsx".format(dev_node.getIp().replace(":", "_")))


def get_resource_bundle():
    bundles = []
    bundle = PY_JAVA_ENV.get("switch_bundle")
    if bundle:
        bundles.append(bundle)
    return bundles
