# coding: UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
from com.huawei.ism.exception import IsmException

import cli_util
import common
import redfish_util

ITEM_ID = "system_disk_cache_strategy"
LANG = common.getLang(py_java_env)
STRATEGY_KEY = "DriveCachePolicy"
STRATEGY_SHOULD_VALUE = "disabled"


def execute(rest_conn):
    """
    检查系统盘缓存策略配置
    :param rest_conn: 集群rest连接
    :return:
    """
    item = common.ItemEntity(py_java_env, ITEM_ID, PY_LOGGER, __file__)
    item.update_progress(1)
    try:
        check(item.build_param_dict(), None, item.err_info_list, item.ret_list)
        return item.get_check_result()
    except (IsmException, Exception) as exception:
        item.logger.logException(exception)
        return item.get_failed_result(common.get_err_msg(LANG, "query.result.abnormal"))


@common.check_all_ibmc_node
def check(param_dict, cluster_dev_node, err_info_list, ret_list):
    node_ret = []
    cluster_node_ip = common.get_node_ip(cluster_dev_node)
    redfish = common.get_redfish_conn(cluster_dev_node)
    logger = param_dict.get("logger")
    try:
        storage_logical_drive_resources, original_info = redfish_util.get_storage_logical_drive_resource_infos(redfish,
                                                                                                               logger)
        node_ret.append(original_info)
        err_info = []
        for path, resource in storage_logical_drive_resources.items():
            target_value = resource.get("Oem").values()[0].get(STRATEGY_KEY)
            if target_value is not None and target_value.lower() != STRATEGY_SHOULD_VALUE:
                logger.logNoPass("path : {} strategy {} value {}".format(path, STRATEGY_KEY, target_value))
                err_info.append("\n{} : {} : {}\n ".format(path, STRATEGY_KEY, target_value))
        if err_info:
            msg = common.get_err_msg(LANG, "strategy.status.not.pass", cluster_node_ip)
            err_info_list.append(msg)
    except Exception as exception:
        logger.logException(exception)
        err_info_list.append(common.get_err_msg(LANG, "item.check.abnormal", cluster_node_ip))
    finally:
        ret_list.append(cli_util.get_format_header_ret(cluster_node_ip, "\n".join(node_ret)))
