# coding: UTF-8
import os
import re

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "volume_snapshot"


def is_fsm_master_node():
    if not os.path.exists('/opt/dfv/oam/oam-u/ha/ha/module/hacom/script/get_harole.sh'):
        return False
    cmd = 'sh /opt/dfv/oam/oam-u/ha/ha/module/hacom/script/get_harole.sh'
    return os.popen(cmd).read() == 'active\n'


def execute(rest):
    """
    检查包含特殊字符的volume残留快照：volume开头， _linked_clone_snap结尾

    :param env:
    :return:
    """
    LOGGER.logInfo("Start to check storage volume snapshot")
    ret_list = []
    dev_node = py_java_env.get("devInfo")
    observer = py_java_env.get("progressObserver")
    progress_map = {}

    try:
        progress_map[ITEM_ID] = 1
        observer.updateProgress(progress_map)
        base_uri = RestUtil.getDstorageUrlHead(dev_node)

        # 1、查询当前节点是否为管理节点主节点
        if not is_fsm_master_node():
            return common.INSPECT_PASS, "", ""

        # 2、批量查询快照
        cmd_str = "{}/api/v2/block_service/snapshots".format(base_uri)
        ret_list.append(cmd_str)
        pools_json = CommonRestService.exec_get_gor_big_by_ds(rest, cmd_str)
        LOGGER.logInfo('get volume snapshot info result:{}'.format(pools_json))
        ret_list.append(str(pools_json))
        if not pools_json.get("data"):
            return common.INSPECT_PASS, "\n".join(ret_list), ""

        # 3、处理结果数据，判断name是否包含特色字符
        volume_pattern = "^volume[\w-]*(_linked_clone_snap)$"
        tmp_err_dict = {}
        for volume_info in pools_json.get("data"):
            volume_name = volume_info.get("name")
            if re.match(volume_pattern, volume_name):
                tmp_list = tmp_err_dict.get(volume_name, [])
                tmp_list.append(
                    common.get_err_msg(
                        LANG, "query.volume.snapshot.result.abnormal",
                        volume_name)
                )
                tmp_err_dict[volume_name] = tmp_list

        progress_map[ITEM_ID] = 80
        observer.updateProgress(progress_map)

        all_ret = "\n".join(ret_list)
        if tmp_err_dict:
            msg_list = ["\n".join(err_msg_list) for _, err_msg_list
                        in tmp_err_dict.items()]
            return common.INSPECT_UNNORMAL, all_ret, "".join(msg_list)

        return common.INSPECT_PASS, all_ret, ""
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            common.INSPECT_UNNORMAL,
            "\n".join(ret_list),
            common.get_err_msg(LANG, "query.result.abnormal"),
        )
