# coding: UTF-8

import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.exception import IsmException

import common
from ds_rest_util import CommonRestService

# noinspection PyUnresolvedReferences
LANG = common.getLang(py_java_env)
# noinspection PyUnresolvedReferences
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "zk_rack_distribution"
# noinspection PyUnresolvedReferences
PY_JAVA_ENV = py_java_env


def execute(rest):
    """ 检查ZK节点的机柜分布
    :param rest:
    :return:
    """
    check_item = CheckZookeeperRackDistribution(rest, LANG, PY_JAVA_ENV,
                                                LOGGER)
    check_item.execute_check()
    return check_item.get_result()


class CheckZookeeperRackDistribution:
    def __init__(self, rest, lang, env, logger):
        self.rest = rest
        self.lang = lang
        self.env = env
        self.observer = env.get("progressObserver")
        self.logger = logger
        self.all_ret_list = []
        self.progressMap = {}
        self.msg_list = []
        self.result_flag = ""
        self.all_zk_ip_list = []
        self.rack_id_and_zk_ip_list_dic = {}
        self.zk_ip_in_storage_pool_lis = []

    def execute_check(self):
        try:
            self.update_progress(1)
            # 遍历存储池，获取zk节点IP与机柜id字典
            flag = self.build_dev_msg()
            if not flag:
                return
            self.update_progress(80)
            # 检查是否存在zk节点不在存储池中
            if not self.check_zookeeper():
                return
            self.update_progress(90)
            flag = self.check_rack()
            if not flag:
                self.result_flag = common.INSPECT_UNNORMAL
            else:
                self.result_flag = common.INSPECT_PASS
        except (IsmException, Exception) as exception:
            self.logger.logException(exception)
            self.result_flag = common.INSPECT_UNNORMAL
            self.msg_list.append(
                common.get_err_msg(LANG, "query.result.abnormal"))

    def check_rack(self):
        """ 检查机柜，是否有zk节点超过2的机柜
        :return:
        """
        flag = True
        for rack_id in self.rack_id_and_zk_ip_list_dic:
            zk_ip_list = self.rack_id_and_zk_ip_list_dic[rack_id]
            if len(zk_ip_list) > 2:
                flag = False
                self.msg_list.append(
                    common.get_err_msg(LANG, "zk.num.int.rack.no.pass",
                                       (rack_id, ",".join(zk_ip_list))))
        return flag

    def check_zookeeper(self):
        """ 检查zk节点，是否存在不在存储池的zk节点
        :return:
        """
        not_in_storage_pool_zk_ip_list = []
        for zk_ip in self.all_zk_ip_list:
            if zk_ip not in self.zk_ip_in_storage_pool_lis:
                not_in_storage_pool_zk_ip_list.append(zk_ip)
        if not_in_storage_pool_zk_ip_list:
            self.msg_list.append(
                common.get_err_msg(LANG, "zk.not.in.storage.pool",
                                   ",".join(
                                       not_in_storage_pool_zk_ip_list),
                                   ))
            self.result_flag = common.INSPECT_UNNORMAL
            return False
        return True

    def build_dev_msg(self):
        """ 构建设备相关信息
        :return:
        """
        dev_node = self.env.get("devInfo")
        self.base_uri = RestUtil.getDstorageUrlHead(dev_node)
        flag, storage_pools_json = self.get_all_storage()
        if not flag:
            self.result_flag = common.INSPECT_UNNORMAL
            return False
        self.update_progress(10)
        self.build_all_zookeeper_ip_list()
        # 有存储没zk，不通过，查询zk信息失败（得先有zk才能有建储池）
        if not self.all_zk_ip_list:
            self.msg_list.append(
                common.get_err_msg(LANG, "query.zk.info.error"))
            self.result_flag = common.INSPECT_UNNORMAL
            return False
        self.update_progress(30)
        # 遍历存储池，获取zk节点IP与机柜id字典
        self.build_storage_pool_detail_info(storage_pools_json)
        return True

    def get_result(self):
        """ 获取检查结果
        :return:
        """
        return self.result_flag, "\n".join(self.all_ret_list), "\n".join(
            self.msg_list)

    def update_progress(self, number):
        self.progressMap[ITEM_ID] = number
        self.observer.updateProgress(self.progressMap)

    def get_all_storage(self):
        """
        获取存储池
        :return:
        """
        url = ("{}/dsware/service/resource/"
               "queryStoragePool?baseInfo=true".format(self.base_uri))
        self.all_ret_list.append(url)
        pools_json = CommonRestService.exec_get_gor_big_by_ds(
            self.rest, url
        )
        self.all_ret_list.append(str(pools_json))
        storage_pools_json = pools_json.get("storagePools", [])
        error_code = pools_json.get("errorCode", [])
        if error_code and (str(error_code) != "0"):
            self.msg_list.append(
                common.get_err_msg(LANG, "query.storage.pool.error"))
            return False, []
        if not storage_pools_json:
            self.msg_list.append(
                common.get_err_msg(LANG, "fsm.device.not.has.pool"))
            return False, []
        return True, storage_pools_json

    def build_storage_pool_detail_info(self, storage_pools):
        """
        获取机柜id与zk节点IP字典,在存储池中的zk节点的列表
        :param storage_pools:
        :return:
        """
        for recode in storage_pools:
            pool_id = recode.get("poolId")
            cmd_str = ("{}/dsware/service/cluster/storagepool/"
                       "queryStorageNodeInfo?"
                       "poolId={}".format(self.base_uri, pool_id))
            self.all_ret_list.append(cmd_str)
            node_json = CommonRestService.exec_get_gor_big_by_ds(
                self.rest, cmd_str
            )
            self.all_ret_list.append(str(node_json))
            self.build_rack(node_json)

    def build_rack(self, node_json):
        # 8.1.RC1，存在问题，接口实现与OMRP不符，需要遍历两层nodeInfo
        # 8.1.RC2发布前及之后的8.1.0（TR6）修复了此问题，只有一层nodeInfo
        product_version = str(self.env.get("devInfo").getProductVersion())
        if product_version == "8.1.RC1":
            for pool_node_info in node_json.get("nodeInfo", []):
                for node_info in pool_node_info.get("nodeInfo", []):
                    node_mgr_ip = node_info.get("nodeMgrIp")
                    self.build_rack_dic(node_info, node_mgr_ip)
        else:
            for node_info in node_json.get("nodeInfo", []):
                node_mgr_ip = node_info.get("nodeMgrIp")
                self.build_rack_dic(node_info, node_mgr_ip)

    def build_rack_dic(self, node_info, node_mgr_ip):
        if node_mgr_ip in self.all_zk_ip_list:
            self.zk_ip_in_storage_pool_lis.append(node_mgr_ip)
            rack = node_info.get("rack", [])
            if rack in self.rack_id_and_zk_ip_list_dic:
                self.rack_id_and_zk_ip_list_dic.get(rack).append(
                    node_mgr_ip)
            else:
                self.rack_id_and_zk_ip_list_dic[rack] = [node_mgr_ip, ]

    def build_all_zookeeper_ip_list(self):
        """
        获取zk的管理ip
        :param all_ip:
        :return:
        """
        url = ("{}/dsware/service/resource/"
               "queryDswareAllNodeIpInfo".format(self.base_uri)
               )
        self.all_ret_list.append(url)
        zk_cluster_json = CommonRestService.exec_get_gor_big_by_ds(
            self.rest,
            url
        )
        self.all_ret_list.append(str(zk_cluster_json))
        self.all_zk_ip_list = zk_cluster_json.get("zkCluster", [])
