# coding:utf-8
from com.huawei.ism.tool.obase.entity import DiskTypeEnum

import common

MIN_DISK_NUM = 2
MIN_MAX_RATE = 3
# 卡换算率
RATE_CARD = 1000
# 盘换算率
RATE_DISK = 1024


def check_main_storage(pool, tmp_err_list, tmp_warning_list, msg_head,
                       lang):
    pool_error_list = []
    # 扩池
    if not pool.getJoinedClusterNode():
        check_create_pool(pool, pool_error_list, tmp_warning_list, msg_head,
                          lang)
    # 扩节点
    else:
        check_add_node_in_pool(pool, pool_error_list, msg_head, lang)
    if pool_error_list:
        tmp_err_list.extend(pool_error_list)


def check_create_pool(pool, pool_error_list, tmp_warning_list, msg_head, lang):
    """
    创池主存盘检查
    :param pool:池信息
    :param pool_error_list:池错误信息
    :param tmp_warning_list:池告警信息
    :param msg_head:错误信息头
    :param lang: 中英文类型
    :return:
    """
    expansion_cluster_node = pool.getExpansionClusterNode()
    expansion_node = pool.getExpansionNodeList()
    # 判断数量
    node_dick_num_list = get_disk_num(expansion_cluster_node)
    node_dick_num_list.extend(get_new_disk_num(expansion_node))
    node_dick_num_list.sort()
    min_num = node_dick_num_list[0]
    max_num = node_dick_num_list[-1]
    if max_num - min_num > MIN_DISK_NUM:
        pool_error_list.append(
            common.get_err_msg(lang,
                               "hardware.main.storage.more.two",
                               msg_head))
    if (max_num - min_num) * MIN_MAX_RATE > max_num:
        pool_error_list.append(
            common.get_err_msg(lang, "hardware.main.storage.low",
                               msg_head))


def check_add_node_in_pool(pool, pool_error_list, msg_head, lang):
    """
    扩节点主存盘检查
    :param pool: 池信息
    :param pool_error_list: 池错误信息
    :param msg_head:错误信息头
    :param lang: 中英文类型
    :return:
    """
    joined_cluster_node = pool.getJoinedClusterNode()
    expansion_cluster_node = pool.getExpansionClusterNode()
    expansion_node = pool.getExpansionNodeList()
    node_dick_num_list = get_disk_num(joined_cluster_node)
    node_dick_num_list.extend(get_disk_num(expansion_cluster_node))
    node_dick_num_list.extend(get_new_disk_num(expansion_node))
    node_dick_num_list.sort()
    min_num = node_dick_num_list[0]
    max_num = node_dick_num_list[-1]
    if max_num - min_num > MIN_DISK_NUM:
        pool_error_list.append(
            common.get_err_msg(lang,
                               "hardware.main.storage.more.two",
                               msg_head))
    if (max_num - min_num) * MIN_MAX_RATE > max_num:
        pool_error_list.append(
            common.get_err_msg(lang,
                               "hardware.main.storage.low",
                               msg_head))
    # 判断盘大小
    tag_size, min_size, flag = get_disk_size(
        joined_cluster_node, expansion_cluster_node,
        expansion_node)
    if not flag:
        pool_error_list.append(
            common.get_err_msg(lang, "hardware.main.storage.size",
                               (msg_head, tag_size, min_size)))


def get_disk_num(nodes):
    """
    获取盘信息
    :param nodes: 节点信息
    :return:
    """
    node_dick_num_list = []
    for node in nodes:
        disk_num = node.getMainStorageDisk().size()
        item_storage = common.get_expansion_main_storage_disk(
            node).entrySet().iterator()
        while item_storage.hasNext():
            entry = item_storage.next()
            disk_num += entry.getValue()
        node_dick_num_list.append(disk_num)
    return node_dick_num_list


def get_new_disk_num(nodes):
    """
    获取新增盘信息
    :param nodes: 节点信息
    :return:
    """
    node_dick_num_list = []
    for node in nodes:
        disk_num = 0
        item_storage = common.get_expansion_main_storage_disk(
            node).entrySet().iterator()
        while item_storage.hasNext():
            entry = item_storage.next()
            disk_num += entry.getValue()
        if disk_num:
            node_dick_num_list.append(disk_num)
    return node_dick_num_list


def get_disk_size(joined_cluster_node, expansion_cluster_node, expansion_node):
    """
    检查主存盘大小
    :param joined_cluster_node: 池中节点
    :param expansion_cluster_node:加入了集群的扩容新增节点
    :param expansion_node:未加入集群的扩容新增节点
    :return:
    """
    min_old_disk = get_pool_min_size_main_disk(joined_cluster_node)
    for node in joined_cluster_node:
        flag, tag_size, min_size = get_min_new_size_disk(node, min_old_disk)
        if not flag:
            return tag_size, min_size, flag
    for node in expansion_cluster_node:
        flag, tag_size, min_size = get_min_new_size_disk(node, min_old_disk)
        if not flag:
            return tag_size, min_size, flag
    for node in expansion_node:
        flag, tag_size, min_size = get_min_new_size_disk(node, min_old_disk)
        if not flag:
            return tag_size, min_size, flag
    return '', '', True


def get_pool_min_size_main_disk(joined_cluster_node):
    """获取当前池里，容量最小的主存盘

    :param joined_cluster_node: 池中节点
    :return: 容量最小的主存盘
    """
    min_disk = None
    for node in joined_cluster_node:
        for disk in node.getMainStorageDisk():
            min_disk = _get_min_size_disk_between_two(disk, min_disk)
    return min_disk


def _get_min_size_disk_between_two(disk_a, disk_b):
    if not disk_a:
        return disk_b
    if not disk_b:
        return disk_a
    if int(disk_a.getCapacity()) < int(disk_b.getCapacity()):
        return disk_a
    return disk_b


def get_min_new_size_disk(node, min_disk):
    """
    检查新扩盘容量是否小于已有盘最小容量
    :param node: 节点信息
    :param min_disk: 最小容量的盘
    :return: (flag, size, rate)
             flag 代表检查是否通过
             tag_size 填写的标称盘容量+单位
             min_size 最小的盘容量+单位
    """
    item_storage = common.get_expansion_main_storage_disk(
        node).entrySet().iterator()
    while item_storage.hasNext():
        entry = item_storage.next()
        disk = entry.getKey()
        if entry.getValue() is None or int(entry.getValue()) < 1:
            continue
        tag_size = str(disk.getOriCapacity())
        tag_unit = disk.getCapacityUnit()
        min_disk_tag_size = common.get_tag_size(
            float(min_disk.getCapacity()), tag_unit, common.get_scale(tag_size))
        if float(tag_size) < float(min_disk_tag_size):
            return False, tag_size + str(tag_unit), \
                   str(min_disk_tag_size) + str(tag_unit)
    return True, '', ''

