# coding:utf-8
from com.huawei.ism.tool.obase.entity import DiskTypeEnum

import common

CATCHE_TYPE = {DiskTypeEnum.SSD_CARD_AND_NVME_SSD: "ssd_card",
               DiskTypeEnum.SSD: "ssd_disk"}


def check_pool_cache_disk(pool, tmp_err_list, msg_head, lang):
    pool_error_list = []
    joined_cluster_node = pool.getJoinedClusterNode()
    expansion_cluster_node = pool.getExpansionClusterNode()
    expansion_node = pool.getExpansionNodeList()
    # 判断盘类型
    check_disk_type(joined_cluster_node, expansion_cluster_node,
                    expansion_node, pool_error_list, msg_head, lang)
    # 检查盘数量, 仅新建池场景涉及, 扩容场景对缓存盘数量不做限制
    if pool.isExpansionCreate():
        check_disk_num(joined_cluster_node, expansion_cluster_node,
                       expansion_node, pool_error_list, msg_head, lang)
    if pool_error_list:
        tmp_err_list.extend(pool_error_list)


def check_disk_num(joined_cluster_node, expansion_cluster_node,
                   expansion_node, pool_error_list, msg_head, lang):
    """
    检查盘数量
    :param joined_cluster_node: 设备实际池内节点
    :param expansion_cluster_node:加入了集群的扩容新增节点
    :param expansion_node:未加入集群的扩容新增节点
    :param pool_error_list:池错误信息
    :param msg_head:错误信息头
    :param lang: 中英文类型
    :return:
    """
    node_dick_num_list = []
    if joined_cluster_node:
        node_dick_num_list.extend(get_disk_num(joined_cluster_node))
        node_dick_num_list.extend(get_disk_num(expansion_cluster_node))
        node_dick_num_list.extend(get_new_disk_num(expansion_node))
    else:
        node_dick_num_list.extend(get_disk_num(expansion_cluster_node))
        node_dick_num_list.extend(get_new_disk_num(expansion_node))

    if len(list(set(node_dick_num_list))) > 1:
        pool_error_list.append(
            common.get_err_msg(lang,
                               "hardware.node.cache.storage.num",
                               msg_head))


def get_disk_num(nodes):
    """
    获取池容量
    :param nodes: 多节点信息
    :return:
    """
    node_dick_num_list = []
    for node in nodes:
        disk_num = node.getCacheDisk().size()
        item_catche = common.get_expansion_cache_disk(
            node).entrySet().iterator()
        while item_catche.hasNext():
            entry = item_catche.next()
            disk_num += entry.getValue()
        node_dick_num_list.append(disk_num)
    return node_dick_num_list


def get_new_disk_num(nodes):
    """
    获取新扩容容量
    :param nodes: 扩容节点
    :return:
    """
    node_dick_num_list = []
    for node in nodes:
        disk_num = 0
        item_catche = common.get_expansion_cache_disk(
            node).entrySet().iterator()
        while item_catche.hasNext():
            entry = item_catche.next()
            disk_num += entry.getValue()
        node_dick_num_list.append(disk_num)
    return node_dick_num_list


def check_disk_type(joined_cluster_node, expansion_cluster_node,
                    expansion_node, pool_error_list, msg_head, lang):
    """
    检查盘类型
    :param joined_cluster_node: 设备实际池内节点
    :param expansion_cluster_node:加入了集群的扩容新增节点
    :param expansion_node:未加入集群的扩容新增节点
    :param pool_error_list:池错误信息
    :param msg_head:错误信息头
    :param lang: 中英文类型
    :return:
    """
    # 池中盘类型
    type_in_pool = None
    flag_type = True
    for node in joined_cluster_node:
        for disk in node.getCacheDisk():
            disk_type = CATCHE_TYPE.get(disk.getType())
            if not type_in_pool:
                type_in_pool = disk_type
                continue
            if type_in_pool is not disk_type:
                flag_type = False
        item_catche = common.get_expansion_cache_disk(
            node).entrySet().iterator()
        while item_catche.hasNext():
            entry = item_catche.next()
            disk = entry.getKey()
            disk_type = CATCHE_TYPE.get(disk.getType())
            if not type_in_pool:
                type_in_pool = disk_type
                continue
            if type_in_pool is not disk_type:
                flag_type = False
    for node in expansion_cluster_node:
        item_catche = common.get_expansion_cache_disk(
            node).entrySet().iterator()
        while item_catche.hasNext():
            entry = item_catche.next()
            disk = entry.getKey()
            disk_type = CATCHE_TYPE.get(disk.getType())
            if not type_in_pool:
                type_in_pool = disk_type
                continue
            if type_in_pool is not disk_type:
                flag_type = False
    for node in expansion_node:
        item_catche = common.get_expansion_cache_disk(
            node).entrySet().iterator()
        while item_catche.hasNext():
            entry = item_catche.next()
            disk = entry.getKey()
            disk_type = CATCHE_TYPE.get(disk.getType())
            if not type_in_pool:
                type_in_pool = disk_type
                continue
            if type_in_pool is not disk_type:
                flag_type = False
    if not flag_type:
        pool_error_list.append(
            common.get_err_msg(lang,
                               "hardware.pool.cache.storage.type", (msg_head,
                                                                    "SSD, SSD&NVME")))


def check_pool_cache_min_size_disk(disk_pool, is_block, tmp_err_list, msg_h, lang):
    """
    非结构化硬盘池内扩容缓存盘时，新扩介质的DWPD不小于已有介质-->新盘容量不小于已有介质最小容量
    """
    if is_block:
        return
    joined_cluster_node = disk_pool.getJoinedClusterNode()
    # 扩池不涉及
    if not joined_cluster_node:
        return
    min_old_disk = get_pool_min_size_cache_disk(joined_cluster_node)
    expand_list = [disk_pool.getExpansionClusterNode(), disk_pool.getExpansionNodeList()]
    for expand_info in expand_list:
        for node in expand_info:
            tag_size, min_size = check_expansion_cache_disk_size_lt_old(node, min_old_disk)
            if tag_size:
                tmp_err_list.append(
                    common.get_err_msg(lang, "hardware.cache.storage.disk.size", (msg_h, tag_size, min_size)))


def check_expansion_cache_disk_size_lt_old(node, min_disk):
    """
    检查新扩盘容量是否小于已有盘最小容量
    :param node: 节点信息
    :param min_disk: 最小容量的盘
    :return: tag_size 填写的标称盘容量+单位
             min_size 最小的盘容量+单位
    """
    item_storage = common.get_expansion_cache_disk(node).entrySet().iterator()
    while item_storage.hasNext():
        entry = item_storage.next()
        if entry.getValue() is None or int(entry.getValue()) < 1:
            continue
        disk = entry.getKey()
        tag_size = str(disk.getOriCapacity())
        tag_unit = disk.getCapacityUnit()
        min_disk_tag_size = common.get_tag_size(float(min_disk.getCapacity()), tag_unit, common.get_scale(tag_size))
        if float(tag_size) < float(min_disk_tag_size):
            return tag_size + str(tag_unit), str(min_disk_tag_size) + str(tag_unit)
    return '', ''


def get_pool_min_size_cache_disk(joined_cluster_node):
    """
    获取当前池里，容量最小的缓存盘
    :param joined_cluster_node: 池中节点
    :return: 容量最小的缓存盘
    """
    min_disk = None
    min_size = 0
    for node in joined_cluster_node:
        for disk in node.getCacheDisk():
            min_disk, min_size = get_min_size_disk_between_two(disk, min_disk, min_size)
    return min_disk


def get_min_size_disk_between_two(disk_a, disk_b, min_size):
    if not disk_a:
        return disk_b, int(disk_b.getCapacity())
    if not disk_b:
        return disk_a, int(disk_a.getCapacity())
    disk_a_size = int(disk_a.getCapacity())
    if disk_a_size < min_size:
        return disk_a, disk_a_size
    return disk_b, min_size
