# coding:utf-8

# noinspection PyUnresolvedReferences
from cbb.frame.base import jsonUtil

# noinspection PyUnresolvedReferences
import com.huawei.uMate.HWDiscover.common.SSHExecutor as SSHExecutor

TIME_OUT = 5 * 60 * 1000
STATUS_OK = "200"
RED_FISH_VERSION_V1 = "v1"


def get_execute_url(red_v, url):
    """
    组装url
    :param red_v: redfish版本
    :param url: 对象url
    :return: 可执行的url
    """
    return "/redfish/{}{}".format(red_v, url)


def execute_redfish_get(redfish_conn, obj_url, red_v=RED_FISH_VERSION_V1):
    """
    执行redfish命令,
    :param redfish_conn: 连接
    :param obj_url: 对象url
    :param red_v: redfish 版本，默认v1，后续如果有更新只改变对应的值
    :return: json
    """
    exec_url = get_execute_url(red_v, obj_url)
    return direct_execute_redfish_get(redfish_conn, exec_url)


def direct_execute_redfish_get(redfish_conn, exec_url):
    """
    执行redfish命令,
    :param redfish_conn: 连接
    :param obj_url: 对象url
    :param red_v: redfish 版本，默认v1，后续如果有更新只改变对应的值
    :return: json
    """
    result = redfish_conn.executeGet(exec_url)
    res_json = result.getResult()
    if not result.isSuccess():
        return False, res_json
    return True, jsonUtil.jsonStr2Dict(res_json)


def execute_cmd(ssh, cmd, timeout=TIME_OUT):
    """
    执行ipmc命令
    :param ssh: 连接
    :param cmd: 命令
    :param timeout: 超时时间
    :return: 执行结果
    """
    cmd_ps1 = 'PS1=\"\\u:\\h:~$\"'
    SSHExecutor.execute(ssh, cmd_ps1, timeout)
    exec_res = SSHExecutor.execute(ssh, cmd, timeout)
    ret = exec_res.getExecRet()
    flag = exec_res.isSuccess()
    return flag, ret


def get_format_header_ret(ip, ret):
    """
    统一格式化每个节点开始的回文
    :param ip: ip
    :param ret: 回文
    :return:
    """
    return u"\n------{}------:\n{}\n".format(ip, ret)


def update_ret_dict(ret_dict, ip, ret_json):
    """
    更新多节点，多命令回文串行问题
    :param ret_dict: 回文dict
    :param ip: ip
    :param ret_json: 待更新回文
    :return:
    """
    tmp_list = ret_dict.get(ip, [])
    tmp_list.append(str(ret_json))
    ret_dict[ip] = tmp_list


def get_vertical_cli_ret(cli_ret):
    """
    @summary: 按逐行字典的方式获取垂直表格形式的cli回显集合
    @param cli_ret: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    """
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    dict_list = []
    line_dict = {}
    for line in cli_ret_list:
        if ":/->" in line or "~$" in line:
            if line_dict:
                dict_list.append(line_dict)
            break

        fields = line.split(":")
        if len(fields) < 2:
            continue

        key = fields[0].strip().decode("utf8")
        value = ":".join(fields[1: len(fields)]).strip().decode("utf8")

        if key in line_dict:
            dict_list.append(line_dict.copy())
            line_dict.clear()

        line_dict[key] = value

    return dict_list


def get_storage_path(record_dict):
    """
    解析redfish的回文获取
    :param record_dict:
    :return:
    """
    resources = record_dict.get("Members")
    return [resource.get("@odata.id") for resource in resources]


def execute_ssh_cmd_remove_color(ssh, cmd, timeout):
    """
    执行ssh命令，并去掉命令回显中的颜色字符
    :param ssh: 连接
    :param cmd: 命令
    :param timeout: 超时时间
    :return: 回显
    """
    return ssh.execCmdWithTimout("{} | cat".format(cmd), timeout)
