#!/usr/bin/env python
# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.

"""
得到扩容时支持扩容的CPU型号列表的方法：
1.通过CPU性能排行字典，找出原有节点中性能最低的CPU
2.由第一步查到的CPU型号，在CPU扩容兼容性定位表中，得到CPU所属的编号
3.由CPU的编号，在CPU扩容兼容性表中，得到该CPU支持扩容的型号列表
"""
# 块环境下的CPU扩容兼容性表
CPU_COMPATIBILITY_BLOCK_EXPANSION_DICT = {
    "1": ("4109T", "4110", "4208", "4114", "4210R", "5115", "C4215R"),
    "2": (
        "4214R", "5118", "5120T", "5120", "5215", "6130", "6130T", "6138T", "6138", "5218R", "C5218R", "1620S", "5220",
        "3210", "1620", "6426", "6430", "4826", "4830", "3226", "3230", "7260", "7265", "5250", "5255", "5240", "5245",
        "5230", "5235", "7261K", "5251K", "5231K", "5221K"),
    "3": (
        "5220R", "C5220R", "1620S", "5220", "3210", "5220", "3210", "1620", "6426", "6430", "4826", "4830", "3226",
        "3230", "7260", "7265", "5250", "5255", "5240", "5245", "5230", "5235", "7261K", "5251K", "5231K", "5221K"),
    "4": (
        "6230R", "6238R", "C6230R", "1620S", "5220", "3210", "1620", "6426", "6430", "4826", "4830", "3226", "3230",
        "7260", "7265", "5250", "5255", "5240", "5245", "5230", "5235", "7261K", "5251K", "5231K", "5221K"),
    "5": (
        "6138T", "6138", "5218R", "C5218R", "1620S", "5220", "3210", "1620", "6426", "6430", "4826", "4830", "3226",
        "3230", "7260", "7265", "5250", "5255", "5240", "5245", "5230", "5235", "7261K", "5251K", "5231K", "5221K"),
    "6": (
        "C4215R", "1620S", "5220", "3210", "1620", "6426", "6430", "4826", "4830", "3226", "3230", "7260", "7265",
        "5250", "5255", "5240", "5245", "5230", "5235", "7261K", "5251K", "5231K", "5221K"),
    "7": ("C5218R", "C5220R", "C6230R", "1620S", "5220", "3210", "1620", "6426", "6430", "4826", "4830", "3226", "3230",
          "7260", "7265", "5250", "5255", "5240", "5245", "5230", "5235", "7261K", "5251K", "5231K", "5221K"),
    "8": ("1616",),
    "9": (
        "1620", "6426", "6430", "4826", "4830", "3226", "3230", "7260", "7265", "5250", "5255", "5240", "5245", "5230",
        "5235", "7261K", "5251K", "5231K", "5221K", "1620S", "5220", "3210"),
}

# 块环境下的CPU扩容兼容性定位表
CPU_COMPATIBILITY_BLOCK_ORIGIN_DICT = {
    "1": ("4109T", "4110", "4208", "4114", "4210R", "5115"),
    "2": ("4214R", "5118", "5120T", "5120", "5215", "6130", "6130T", "6138T", "6138", "5218R", "C5218R"),
    "3": ("5220R",),
    "4": ("6230R", "6238R"),
    "5": ("6138T", "6138", "5218R",),
    "6": ("C4215R",),
    "7": ("C5218R", "C5220R", "C6230R",),
    "8": ("1616",),
    "9": (
        "1620", "6426", "6430", "4826", "4830", "3226", "3230", "7260", "7265", "5250", "5255", "5240", "5245", "5230",
        "5235", "7261K", "5251K", "5231K", "5221K", "1620S", "5220", "3210"),
}

# 融合环境下的CPU扩容兼容性表
CPU_COMPATIBILITY_NOT_BLOCK_EXPANSION_DICT = {
    "1": ("4109T", "4110", "4208", "4114", "4210R", "5115", "C4215R", "1620S", "5220", "3210"),
    "2": ("4214R", "5118", "5120T", "5120", "5215", "6130", "6130T", "6138T", "6138", "5218R", "C5218R", "1620", "6426",
          "6430", "4826", "4830", "3226", "3230", "7260", "7265", "5250", "5255", "5240", "5245", "5230", "5235",
          "7261K", "5251K", "5231K", "5221K"),
    "3_HDD": (
        "5220R", "C5220R", "1620S", "5220", "3210", "1620", "6426", "6430", "4826", "4830", "3226", "3230", "7260",
        "7265", "5250", "5255", "5240", "5245", "5230", "5235", "7261K", "5251K", "5231K", "5221K"),
    "3_SSD": (
        "5220R", "C5220R", "1620", "6426", "6430", "4826", "4830", "3226", "3230", "7260", "7265", "5250", "5255",
        "5240", "5245", "5230", "5235", "7261K", "5251K", "5231K", "5221K"),
    "4": (
        "6230R", "6238R", "C6230R", "1620", "6426", "6430", "4826", "4830", "3226", "3230", "7260", "7265", "5250",
        "5255", "5240", "5245", "5230", "5235", "7261K", "5251K", "5231K", "5221K"),
    "5": (
        "6138T", "6138", "5218R", "C5218R", "1620", "6426", "6430", "4826", "4830", "3226", "3230", "7260", "7265",
        "5250", "5255", "5240", "5245", "5230", "5235", "7261K", "5251K", "5231K", "5221K"),
    "6": ("C4215R", "1620S", "5220", "3210"),
    "7": ("C5218R", "C5220R", "C6230R", "1620", "6426", "6430", "4826", "4830", "3226", "3230", "7260", "7265", "5250",
          "5255", "5240", "5245", "5230", "5235", "7261K", "5251K", "5231K", "5221K"),
    "8": ("1616",),
    "9": ("1620", "6426", "6430", "4826", "4830", "3226", "3230", "7260", "7265", "5250", "5255", "5240", "5245",
          "5230", "5235", "7261K", "5251K", "5231K", "5221K"),
    "10": ("1620S", "5220", "3210"),
    # A310专属1630系列CPU型号，不能和其他类型CPU共硬盘池
    "11": ("7260Y",),
    "12": ("C6348",),
}

# 融合环境下的CPU扩容兼容性定位表
CPU_COMPATIBILITY_NOT_BLOCK_ORIGIN_DICT = {
    "1": ("4109T", "4110", "4208", "4114", "4210R", "5115"),
    "2": ("4214R", "5118", "5120T", "5120", "5215", "6130", "6130T", "6138T", "6138", "5218R"),
    "3": ("5220R",),
    "4": ("6230R", "6238R"),
    "5": ("6138T", "6138", "5218R"),
    "6": ("C4215R",),
    "7": ("C5218R", "C5220R", "C6230R"),
    "8": ("1616",),
    "9": (
        "1620", "6426", "6430", "4826", "4830", "3226", "3230", "7260", "7265", "5250", "5255", "5240", "5245", "5230",
        "5235", "7261K", "5251K", "5231K", "5221K"),
    "10": ("1620S", "5220", "3210"),
    "11": ("7260Y",),
    "12": ("C6348",),
}

# CPU性能排行字典(1616,1620,1620s三个型号特殊处理, +33的原因是，只要有其他cpu型号，就不考虑这三个型号的cpu)
CPU_PERFORMANCE_SCORE_DICT = {
    "4108": 2,
    "4109T": 3,
    "C4215R": 4,
    "4110": 5,
    "4208": 6,
    "4114": 7,
    "4210R": 8,
    "5115": 9,
    "C4310": 10,
    "5215": 11,
    "5118": 12,
    "4214R": 13,
    "C4314": 14,
    "5120T": 15,
    "5120": 16,
    "6130T": 18,
    "6130": 19,
    "6138T": 20,
    "6138": 21,
    "5218R": 23,
    "C5218R": 24,
    "C4316": 25,
    "5220R": 26,
    "C5220R": 27,
    "C5318Y": 28,
    "6230R": 29,
    "C6230R": 30,
    "C6330": 31,
    "6238R": 32,
    "C6348": 33,
    "7260Y": 34,
}

CPU_16_SCORE_DICT = {
    "1616": 1,
    # 1620S有很多型号
    "1620S": 17,
    "5220": 17,
    "3210": 17,
    # 1620有很多型号
    "1620": 22,
    "6426": 22,
    "6430": 22,
    "4826": 22,
    "4830": 22,
    "3226": 22,
    "3230": 22,
    "7260": 22,
    "7265": 22,
    "5250": 22,
    "5255": 22,
    "5240": 22,
    "5245": 22,
    "5230": 22,
    "5235": 22,
    "7261K": 22,
    "5251K": 22,
    "5231K": 22,
    "5221K": 22,
}


def get_score(cpu):
    if cpu in CPU_PERFORMANCE_SCORE_DICT:
        return CPU_PERFORMANCE_SCORE_DICT.get(cpu)
    else:
        return CPU_16_SCORE_DICT.get(cpu, 999)
