# -*- coding: UTF-8 -*-
import json
from cbb.frame.base import jsonUtil
from com.huawei.ism.exception import IsmException
from java.lang import Exception as JException

REST_CAN_NOT_EXECUTE = "1077936891"  # 命令执行失败


class CommonRestService():
    '''
    执行大量数据的get类型的rest命令
    '''

    @staticmethod
    def exec_get_gor_big_by_ds(rest, url, need_check_resp=True, params=""):
        try:
            params_str = json.dumps(params) if params else params
            if need_check_resp:
                response = rest.execGet(url, params_str)
            else:
                response = rest.execGetNotCheckResp(url, params_str, None, None)
            errCode = response.getContentMap().get("errorCode")
            if errCode is None or (str(errCode) == "0"):
                return jsonUtil.jsonStr2Dict(str(response.getContent()))
            else:
                description = response.getContentMap().get("description")
                raise IsmException(int(errCode), description)
        except IsmException as exception:
            raise exception
        except JException as exception:
            raise IsmException(int(REST_CAN_NOT_EXECUTE), exception)

    @staticmethod
    def execute_post_request(rest, url, client_data):
        try:
            response = rest.execPost(url, client_data)
            err_code = response.getContentMap().get("errorCode")
            if err_code is None or (str(err_code) == "0"):
                return jsonUtil.jsonStr2Dict(str(response.getContent()))
            else:
                description = response.getContentMap().get("description")
                raise IsmException(int(err_code), description)
        except IsmException as exception:
            raise exception
        except JException as exception:
            raise IsmException(int(REST_CAN_NOT_EXECUTE), exception)
