#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
import re


def get_digit_str(str_ver):
    match_ret = re.compile("\d+").findall(str_ver)
    if not match_ret:
        return "0"
    return "".join(match_ret)


class Compare(object):
    @staticmethod
    def compare_digital_version(version1, version2):
        if not version1:
            return -1 if version2 else 0
        elif not version2:
            return 1

        def str_to_int(str_ver):
            try:
                return int(get_digit_str(str_ver))
            except ValueError:
                raise Exception("not int version {}".format(str_ver))

        match = re.compile(r'[.-]')
        version1_sections = match.split(version1)
        version2_sections = match.split(version2)
        for index in range(
                max(len(version1_sections), len(version2_sections))):
            if index == len(version1_sections):
                version1_sections.append("0")
            if index == len(version2_sections):
                version2_sections.append("0")
            if str_to_int(version1_sections[index]) > str_to_int(version2_sections[index]):
                return 1
            elif str_to_int(version1_sections[index]) < str_to_int(version2_sections[index]):
                return -1
        return 0
