# -*- coding: UTF-8 -*-

ERROR_MSG_DICT = {
    "query.zk.info.error": {
        "zh": u"\n查询zk节点信息失败。",
        "en": "\nFailed to query ZooKeeper node information.",
    },
    "query.storage.pool.error": {
        "zh": u"\n查询存储池信息失败。",
        "en": "\nFailed to query the storage pool information.",
    },
    "zk.not.in.storage.pool": {
        "zh": u"\nZK节点【IP：%s】不在存储池中",
        "en": "\nZK node [IP:%s] is not in the storage pool.",
    },
    "zk.num.int.rack.no.pass": {
        "zh": u"\n机柜[编码：%s]所属ZK节点数[IP:%s]大于2",
        "en": "\nIn cabinet[ID: %s], the number of ZooKeeper nodes [IP: %s] is greater than 2.",
    },
    "hardware.disk.status": {
        "zh": u"\n节点%s存在下列盘不正常：\n%s",
        "en": "\nThe following disks on node %s are abnormal:\n%s",
    },
    "query.result.abnormal": {
        "zh": u"\n获取信息失败。",
        "en": "\nThere is an error in getting information.",
    },
    "query.result.busy": {
        "zh": u"\n获取信息失败。请重新执行该巡检项。若重试失败，请联系技术工程师。",
        "en": "\nFailed to obtain information. Perform the check again. If the retry fails, "
              "contact technical support engineers.",
    },
    "service.date.abnormal":
        {
            "zh": u"\n内部错误，请联系维护工程师",
            "en": "\nInternal error. Contact maintenance engineers.",
        },
    "service.date.overdue":
        {
            "zh": u"\n服务时间已过期或即将过期",
            "en": "\nThe service date has expired or is about to expire.",
        },
    "hardware.status.check.failed": {
        "zh": u"\n获取节点(IP:%s)信息失败。",
        "en": "\nThere is an error in getting device (IP: %s) information.",
    },
    "query.pool.result.abnormal": {
        "zh": u"\n获取信存储池%s信息失败。",
        "en": "\nFailed to obtain the information about storage pool %s.",
    },
    "hardware.bbu.status.not.pass": {
        "zh": u"\n节点(IP:%s)BBU(ID:%s)状态异常。",
        "en": "\nDevice's (IP: %s) BBU (ID: %s) is abnormal.",
    },
    "hardware.bbu.status.not.exist": {
        "zh": u"\n获取节点(IP:%s)BBU信息失败。",
        "en": "\nThere is an error in getting device (IP: %s) "
              "BBU information.",
    },
    "hardware.history.warning.not.pass": {
        "zh": u"\n节点(IP:%s)中存在告警。",
        "en": "\nDevice (IP address: %s) has alarms.",
    },
    "fsm.device.not.has.pool": {
        "zh": u"\n该设备不存在存储池。",
        "en": "\nNo storage pool exists on the device.",
    },
    "fsm.node.not.in.pool": {
        "zh": u"\nFSM节点【IP：%s】不在存储池中。",
        "en": "\nFSM node [IP address: %s] is not in a storage pool.",
    },
    "fsm.node.same.rack": {
        "zh": u"\nFSM节点【IP：%s，%s】属于同一机柜【编号：%s】。",
        "en": "\nFSM nodes [IP addresses: %s, %s] belong to the same cabinet [No.: %s].",
    },
    "hardware.system.health.status.not.pass": {
        "zh": u"\n节点(IP:%s)系统健康状态不正常，告警[%s]数量大于0。",
        "en": "\nThe health status of the device (IP address: %s) "
              "is abnormal. The number of alarms [%s] is greater than 0.",
    },
    "hardware.cpu.health.status.not.pass": {
        "zh": u"\n节点(IP:%s)CPU状态异常。",
        "en": "\nHealth status of CPUs on device (IP address: %s) are "
              "abnormal.",
    },
    "hardware.mem.health.status.not.pass": {
        "zh": u"\n节点(IP:%s)内存状态异常。",
        "en": "\nThe memory status of device (IP address: %s) is "
              "abnormal."
    },
    "hardware.fan.status.not.pass": {
        "zh": u"\n节点(IP:%s)下列风扇[Position:%s]状态异常。",
        "en": "\nOn device (IP address: %s), fan modules "
              "(positions: %s) are abnormal.",
    },
    "hardware.fan.not.pass": {
        "zh": u"\n节点(IP:%s)风扇状态异常。",
        "en": "\nOn device (IP address: %s), fan modules are abnormal.",
    },
    "hardware.fan.status.not.pass.fan.alarm": {
        "zh": u"\n节点(IP:%s)下存在风扇不在位告警。%s",
        "en": "\nOn device (IP address: %s), fan not in position alarm "
              "is generated: %s.",
    },
    "hardware.power.status.not.pass": {
        "zh": u"\n节点(IP:%s)中存在电源告警[ID:%s]。",
        "en": "\nOn device (IP address: %s), alarms are "
              "generated for PSUs [ID: %s].",
    },
    "hardware.temper.status.not.pass": {
        "zh": u"\n节点(IP:%s)温度状态异常，详情：%s",
        "en": "\nThe temperature of device (IP address: %s) is "
              "abnormal. Details: %s",
    },
    "hardware.node.has.no.auth": {
        "zh": u"\n节点(IP:%s)未鉴权，请在选择节点时鉴权。",
        "en": "\nThe device (IP address: %s) is not authenticated. "
              "Authenticate the device when selecting a node.",
    },
    "hardware.node.has.no.auth.detach.check": {
        "zh": u"\n节点(IP:%s)未鉴权，请在鉴权界面进行鉴权。",
        "en": "\nThe device (IP address: %s) is not authenticated. "
              "Authenticate the device on the authentication card.",
    },
    "ret.show.more.information": {
        "zh": u"\n最多展示%s个命令原始信息, 更多节点信息请查看报告根目录下：\n%s。",
        "en": "\nThe original information about a maximum of %s commands"
              " is displayed. \nFor that about more nodes, check the "
              "following file in the root directory of the report:\n%s .",
    },
    "hardware.storage.node.num.five": {
        "zh": u"\n%s扩容存储节点数超过已有节点数的5倍。",
        "en": "\nThe number of storage nodes to be added to "
              "%s is more than 5 times that of existing "
              "storage nodes in the storage pool.",
    },
    "hardware.storage.node.num.total": {
        "zh": u"\n扩容后存储节点总数超过256个，当前配置为%s。",
        "en": "\nThe total number of storage nodes in the cluster "
              "exceeds 256 after capacity expansion. Current number: %s.",
    },
    "hardware.storage.node.num.new.min": {
        "zh": u"\n%s节点少于%s个，当前配置为%s。",
        "en": "\n%s contains less than %s nodes. "
              "Current number: %s",
    },
    "hardware.storage.node.disk.num.total": {
        "zh": u"\n%s的节点主存盘少于4个，当前配置为%s。",
        "en": "\nIn %s, "
              "the number of main storage disks on node xx is less than 4, "
              "Current number: %s.",
    },
    "hardware.storage.node.num.max": {
        "zh": u"\n%s扩容后节点超过推荐值40个，当前配置为%s。",
        "en": "\nThe number of storage nodes in %s exceeds "
              "recommended value 40 after capacity expansion, "
              "Current number: %s",
    },
    "hardware.storage.node.disk.average": {
        "zh": u"\n%s单个节点内单个主存盘少于40GB缓存，当前配置为%s。",
        "en": "\nA single main storage disk on a single node in "
              "%s is allocated with less than 40 GB cache, "
              "Current number : %s.",
    },
    "hardware.storage.node.cache.size": {
        "zh": u"\n%s新扩节点的缓存盘容量小于当前池内原有缓存盘总容量最小的节点的缓存盘总容量，当前配置为%s",
        "en": "The total cache disk capacity of new node in %s is less than "
              "that of the node with the least cache disk capacity in the pool."
              "Current size : %s"
    },
    "hardware.storage.pool.error": {
        "zh": u"存储池配置存在错误。",
        "en": "\nThere is a configuration error in storage pool.",
    },
    "hardware.storage.pool.warning": {
        "zh": u"存储池配置存在告警。",
        "en": "\nThere is a configuration warning in storage pool.",
    },
    "hardware.main.storage.low": {
        "zh": u"%s节点间的主存盘数量相差比例高于33%%。",
        "en": "The difference between the numbers of main storage "
              "disks on nodes in %s is greater than 33%%.",
    },
    "hardware.main.storage.more.two": {
        "zh": u"%s节点间的主存盘数量相差超过2块。",
        "en": "The difference between the numbers of main storage "
              "disks on nodes in %s is greater than 2.",
    },
    "hardware.main.storage.size": {
        "zh": u"%s新扩容的盘容量（%s）不能低于已有盘的最小容量（%s）。",
        "en": "The capacity of a disk to be added to %s (%s) "
              "is smaller than that of the smallest disk in the "
              "pool (%s).",
    },
    "hardware.cache.storage.disk.size": {
        "zh": u"%s新扩容的缓存盘容量（%s）不能低于已有盘的最小容量（%s）。",
        "en": "The capacity of a disk to be added to %s (%s) "
              "is smaller than that of the smallest disk in the "
              "pool (%s).",
    },
    "hardware.cache.storage.disk.same.model": {
        "zh": u"%s池内第三方缓存盘与自研盘共池。(%s)节点与(%s)节点内缓存盘类型不一致",
        "en": "Third-party cache disks and self-developed disks are in the "
              "pool (%s).The type of cache disk in node (%s) and node (%s) is inconsistent",
    },
    "hardware.node.cache.storage.num": {
        "zh": u"%s节点间的缓存盘数量不一致。",
        "en": "The numbers of cache disks on nodes in "
              "%s are different.",
    },
    "hardware.pool.cache.storage.type": {
        "zh": u"%s内缓存盘类型不一致，同时存在盘类型 %s。",
        "en": " The types of cache disks on nodes in %s "
              "are different. The storage pool contains the following "
              "types of cache disks:%s",
    },
    "hardware.pool.cache.storage.only": {
        "zh": u"存储池存在节点新扩容主存盘为0，Ip:[%s]。",
        "en": " There is no added storage disk on nodes in a storage pool. "
              "ip:[%s].",
    },
    "pool.main.storage.disk.num.below.min": {
        "zh": u"%s,disk zone中主存盘数量小于4的节点：[%s]。",
        "en": " In %s, Nodes with less than 4 main storage disks in the disk zone are as follows:[%s].",
    },
    "pool.main.storage.disk.num.exceeds.max": {
        "zh": u"%s,disk zone中主存盘数量大于15的节点：[%s]。",
        "en": "In %s, nodes with more than 15 main storage disks in the disk zone are as follows:[%s].",
    },
    "can.not.select.pacific.node": {
        "zh": u"%s，主存盘类型是SSD卡&NVMe SSD，不能选择STL6SPCM节点[%s]。",
        "en": "In %s, the main storage disk type is SSD card and NVMe SSD. STL6SPCM node [%s] cannot be selected.",
    },
    "can.not.select.atlantic.node": {
        "zh": u"%s，主存盘类型不是SSD卡&NVMe SSD，不能选择STL6SPCN节点[%s]。",
        "en": "In %s, the main storage disk type is not SSD card or NVMe SSD. STL6SPCN node [%s] cannot be selected.",
    },
    "can.not.select.atlantic.node.storage": {
        "zh": u"%s，主存盘类型不是SSD卡&NVMe SSD，不能选择STL6SPCN或STL6SPCNE节点[%s]。",
        "en": "In %s, the main storage disk type is not SSD card or NVMe SSD. STL6SPCN node "
              "or STL6SPCNE node [%s] cannot be selected.",
    },
    "pacific.cache.disk.num.non.conformity": {
        "zh": u"%s, 缓存盘数量不为1~4的节点：[%s]。",
        "en": "In %s, nodes whose number of cache disks is out of range (1 to 4): [%/s].",
    },
    "east.cache.disk.num.non.conformity.1to4": {
        "zh": u"%s, 缓存盘数量不为1~4的节点：[%s]。",
        "en": "In %s, nodes whose number of cache disks is out of range (1 to 4): [%/s].",
    },
    "east.cache.disk.num.non.conformity.1or2": {
        "zh": u"%s, 缓存盘数量不为1或2的节点：[%s]。",
        "en": "In %s, nodes whose number of cache disks is out of range (1 or 2): [%/s].",
    },
    "fsm.bmc.time.not.pass": {
        "zh": u"\n节点(IP:%s)BMC时区不正确。",
        "en": "\nthe Time Zone of the BMC (IP address: %s) is incorrect.",
    },
    "software.version.info.error": {
        "zh": u"集群版本过低,当前版本为[%s]。",
        "en": "The serving version is too low,the current version is [%s]. "
    },
    "vbs.check.config.error": {
        "zh": u"%s:\n"
              u"VBS配置文件中配置项与FSM不一致。",
        "en": "%s:\n"
              "Configuration items in the VBS configuration file "
              "are inconsistent with those on the FSM node. ",
    },
    "vbs.check.config.fsm.error": {
        "zh": u"\n收集FSM配置文件失败。",
        "en": "\nFailed to collect the FSM configuration file.",
    },
    "vbs.check.config.handle.error": {
        "zh": u"\n处理预收集信息失败。",
        "en": "\nFailed to process pre-collected information.",
    },
    "vbs.check.config.item": {
        "zh": u"——[%s]——\n"
              u"不匹配配置项：\n"
              "%s",
        "en": "——[%s]——\n"
              "Mismatched configuration:\n"
              "%s",
    },
    "vbs.check.config.pass": {
        "zh": u"通过",
        "en": "pass",
    },
    "expansion.config.info": {
        "zh": u"扩容相关配置见巡检结果包中的Configuration_Summary.xlsx。",
        "en": "For details about capacity expansion configurations, "
              "see Configuration_Summary.xlsx in the "
              "inspection result package.",
    },
    "query.ntp.result.not.pass": {
        "zh": u"未配置或开启第三方ntp服务器时间同步功能。",
        "en": "\nThe time synchronization function of the third-party NTP server is not configured or enabled.",
    },
    "call.home.ca.cert.expire.time.no.pass": {
        "zh": u"当前系统时间距离Call Home CA证书有效期截止时间的天数小于90天。",
        "en": "The time difference between the system time and the Call Home CA certificate expiration date is "
              "shorter than 90 days."
    },
    "storage.pool.disk.pool.msg": {
        "zh": u"存储池[%s]中的硬盘池[%s]",
        "en": "In disk pool [%s] of storage pool [%s]",
    },
    "storage.pool.msg": {
        "zh": u"存储池[%s]",
        "en": "In storage pool [%s]",
    },
    "fsm.zk.node.count.not.match": {
        "zh": u"zk数量不匹配，当前存储节点数量为[%s]，当前ZK节点数量为[%s]。",
        "en": "The number of zk does not match, the current number of storage nodes is [%s], and the current number "
              "of ZK nodes is [%s].",
    },
    "query.pool.name.not.pass": {
        "zh": u"不存在可信区存储池。",
        "en": "No trusted zone storage pool"
    },
    "fsm.node.count.not.pass": {
        "zh": u"FSM节点个数不为2",
        "en": "The number of FSM nodes is not 2."
    },
    "fsm.or.zk.ip.not.pass": {
        "zh": u"%s节点[IP：%s]不在存储池中",
        "en": "%s Node [IP address:%s] is not in the storage pool."
    },
    "fsm.and.zk.ip.not.pass": {
        "zh": u"FSM节点[IP：%s]不在存储池中,\nZK节点[IP：%s]不在存储池中",
        "en": "FSM Node [IP address:%s] is not in the storage pool.\nZK Node [IP address:%s] "
              "is not in the storage pool."
    },
    "fsm.or.zk.pool.name_not.trust": {
        "zh": u"%s节点[IP：%s]所在存储池[Name：%s]不在可信区",
        "en": "The %s node[IP address:%s] storage pool[Name:%s] is not in the trusted zone."
    },
    "fsm.and.zk.pool.name_not.trust": {
        "zh": u"FSM节点[IP：%s]所在存储池[Name：%s]不在可信区,\nZK节点[IP：%s]所在存储池[Name：%s]不在可信区",
        "en": "The FSM node[IP address:%s] storage pool[Name:%s] is not in the trusted zone,\nThe "
              "ZK node[IP address:%s] storage pool[Name:%s] is not in the trusted zone."
    },
    "query.replication.cluster.address.pool.result.abnormal": {
        "zh": u"复制集群IP地址池[%s]存在IP个数小于2的节点",
        "en": "The number of IP addresses in the replication cluster IP address pool [%s] is less than 2."
    },
    "query.volume.snapshot.result.abnormal": {
        "zh": u"当前环境存在临时未删除的快照，快照名：[%s]",
        "en": "Temporary snapshots that are not deleted exist in the current environment: [%s]"
    },
    "default_password_check.result.not.pass": {
        "zh": u"存储系统帐号[Name：%s]密码为默认密码",
        "en": "The password of the storage system account [Name:%s] is the default password."
    },
    "not_splitted_dual_ns_rep_async_pair.result.not.pass": {
        "zh": u"存在状态不为分裂的命名空间异步远程复制Pair，且本端资源角色既有为主端的命名空间，又有为从端的命名空间\n主端:\n%s\n从端:\n%s\n",
        "en": u"There are remote replication pairs whose exist local resource role of namespaces exists both Primary "
              u"and Secondary.\nPrimaries,\n%s\nSecondaries,\n%s\n",
    },
    "plogserver.upgradezone.has.risk": {
        "zh": u"\n池[ID:%s]的升级域划分存在风险。",
        "en": "\nThe upgrade domain division of the pool[ID:%s] is risky."
    },
    "strategy.status.not.pass": {
        "zh": u"节点[IP：%s] 配置不正确\n",
        "en": "Node [IP address:%s] configuration is incorrect.\n"
    },
    "version.mapping.not.pass": {
        "zh": u"节点[IP：%s] 当前版本:%s， 配套版本:%s 。\n",
        "en": "Node [IP address:%s] current version : %s ,matching version : %s.\n"
    },
    "item.check.abnormal": {
        "zh": u"节点[IP：%s] 获取信息失败\n",
        "en": "Node [IP address:%s] failed to obtain information\n"
    },
    "es3000.driver.mapping.not.pass": {
        "zh": u"节点[IP：%s] 类型:驱动， 当前版本:%s， 配套版本:%s 。\n",
        "en": "Node [IP address:%s] Type : Driver, current version : %s, matching version : %s.\n"
    },
    "es3000.tool.mapping.not.pass": {
        "zh": u"节点[IP：%s] 类型:工具， 当前版本:%s， 配套版本:%s 。\n",
        "en": "Node [IP address:%s] Type : Tool, current version : %s, matching version : %s.\n"
    },
    "es3000.fw.ver.not.match": {
        "zh": u"节点[IP：%s] 类型：V%s固件， esn:%s， 当前版本:%s， 配套版本:%s 。\n",
        "en": "Node [IP address:%s] Type : V%s firmware, esn:%s, current version : %s, matching version : %s.\n"
    },
    "query.version.bond.result.pass": {
        "zh": u"环境版本:%s，当前未指定绑定模式\n",
        "en": "Environment version: %s,No binding mode is currently specified.\n"
    },
    "query.version.na": {
        "zh": u"不涉及,版本:%s。\n",
        "en": "N/A, version:%s.\n"
    },
    "common.error": {
        "zh": u"系统存在异常: %s。\n",
        "en": "System exception: %s.\n"
    },
    "check.fail.over.status.error": {
        "zh": u"检测到故障倒换状态不正常的节点为: %s。\n",
        "en": "The node whose failover status is abnormal is :%s.\n"
    },
    "check.result.dsm.bios.missmatch": {
        "zh": u"待扩容节点[IP: %s]的BIOS版本[Version: %s]和存储软件版本:%s存在不配套风险。\n",
        "en": "Node [IP address: %s] BIOS[Version: %s] and storage software version %s may not match.\n"
    },
    "check.result.dsm.scale.in": {
        "zh": u"存储软件版本:%s 集群做过缩容操作。\n",
        "en": "Storage software version: %s The cluster has been scaled in.\n"
    },
    "expand.node.count.difference.exceeds.threshold": {
        "zh": u"以下硬盘池将在扩容后节点数差异过大：%s。\n",
        "en": "The node count difference will exceed recommended limit among these disk pools after expansion: %s.\n"
    },
    "expand.node.count.difference.disk.pool.template": {
        "zh": u"硬盘池%d[名称：%s，扩容后节点数：%d]",
        "en": "Disk Pool %d[Name: %s, Node Count After Expansion: %d]"
    },
    "hotpatch.check.failed": {
        "zh": u"当前集群热补丁版本：{}，推荐版本：{}，建议升级至推荐版本\n企业网：{}\n运营商：{}\n",
        "en": "Current cluster version: {}, recommended version: {}, upgrade to the recommended version\n"
              "Enterprise network: {}\nCarrier network: {}\n"
    },
    "check.sever.num.not.pass": {
        "zh": u"以下硬盘池节点数量小于数据块数量加校验块数量之和：\n硬盘池ID {}\n",
        "en": "The number of nodes in the following disk pool is less than "
              "the total number of data blocks and parity blocks. Disk pool ID:{}"
    },
    "check.data.units.not.pass": {
        "zh": u"以下硬盘池冗余策略为ec，且块池中数据块大于8：\n硬盘池ID {}\n",
        "en": "The redundancy policy of the following disk pools is ec, "
              "and the number of data blocks in the block pool is greater than 8:\nDisk pool ID {}\n"
    },
    "check.cache.main.rate.not.pass": {
        "zh": u"以下硬盘池缓存主存比小于0.03：\n硬盘池ID {}\n",
        "en": "The cache/main storage ratio of the following disk pools is less than 0.03:\nDisk pool ID {}\n"
    },
    "check.cache.main.rate.for.warning": {
        "zh": u"以下硬盘池缓存主存比小于0.0133,可能存在性能风险：\n硬盘池ID {}\n",
        "en": "The cache/main storage ratio of the following disk pools is less than 0.03:\nDisk pool ID {}\n"
    },
    "check.node.number.failed": {
        "zh": u"存储节点数量小于5节点。\n",
        "en": "The number of storage nodes is less than 5.\n"
    },
    "check.storage.node.iscsi.not.pass": {
        "zh": u"存储节点未开启iscsi服务。{}\n",
        "en": "The iSCSI service is not enabled on the storage node.{}\n"
    },
    "check.zk.number.failed": {
        "zh": u"zk节点数量不足。\n",
        "en": "The number of ZooKeeper nodes is insufficient.\n"
    },
    "check.zk.type.for.warning": {
        "zh": u"zk元数据盘性能不足。\n",
        "en": "The performance of the ZooKeeper metadata disk is insufficient."
    },
    "check.zk.type.failed": {
        "zh": u"元数据盘类型不支持dir或partition。\n",
        "en": "The metadata disk type does not support dir or partition.\n"
    },
    "check.zk.type.failed.for.sys.disk": {
        "zh": u"不建议使用系统盘作为zk元数据盘。\n",
        "en": "You are not advised to use the system disk as the ZooKeeper metadata disk.\n"
    },
    "pool.storage.recon.band.width": {
        "zh": u"存储软件版本:%s， 集群中的存储池[name: %s]检查不通过，具体错误信息[info: %s]。\n",
        "en": "storage software version %s, storage pools [name: %s] check fails, detail info[info: %s].\n"
    },
    "pool.storage.nvme.disk.check.vendor": {
        "zh": u"待扩容节点[IP: %s]存在DUPA NVME盘，和存储软件版本:%s存在不配套风险。\n",
        "en": "Node [IP address: %s] exist DUPA NVME disks and storage software version %s may not match.\n"
    },
    "pool.storage.tag.check": {
        "zh": u"当前节点[IP: %s]版本为:%s，不在目标版本:%s 电子标签范围内。\n",
        "en": "Current node [IP: %s] version: %s, which is not within the electronic label range"
        " of target version:%s.\n"
    },
    "pool.storage.tag.check.pass": {
        "zh": u"检查通过，槽位号无变更风险！产品版本：%s。\n",
        "en": "CHECK PASS, The slot number does not change! productVersion:%s.\n"
    },
    "pool.storage.tag.check.unnormal": {
        "zh": u"检查不通过，产品版本：%s 问题节点：%s 电子标签不支持升级。\n",
        "en": "productVersion:%s problem nodeIP:%s tag do not support upgrade.\n"
    },
    "node.platform.error": {
        "zh": u"节点%s网络平面配置错误\n",
        "en": "The network plane configuration of node %s is incorrect.\n"
    },
    "cluster.platform.pass": {
        "zh": u"集群网络平面配置巡检通过\n",
        "en": "The check result of the cluster network plane configuration is Passed.\n"
    },
    "fsm.pass": {
        "zh": u"通过\n",
        "en": "Passed.\n"
    },
    "cluster.platform.error": {
        "zh": u"集群内存储节点的网络平面存在不一致\n",
        "en": "The network planes of storage nodes in the cluster are inconsistent.\n"
    },
    "node.route.error": {
        "zh": u"存储池%s路由不一致\n",
        "en": "The routes of storage pools %s are inconsistent.\n"
    },
    "pool.storage.spdk.consistency": {
        "zh": u"集群中的存储池[name: %s]检查不通过，具体错误信息[info: %s]。\n",
        "en": "storage pools [name: %s] check fails, detail info[info: %s].\n"
    },
    "close.io.hanging.failed": {
        "zh": u"关闭IO悬挂开关失败",
        "en": "Failed to disable I/O suspension."
    },
    "config.lldp.no.auth.node.failed": {
        "zh": u"节点：{} 无鉴权信息，不满足要求，无法执行配置",
        "en": "Node {} does not have authentication information and does not meet the requirements. "
              "The configuration cannot be performed."
    },
    "config.lldp.no.storage.node.failed": {
        "zh": u"节点：{} 非存储节点，不满足要求，无法执行配置",
        "en": "Node {} is not a storage node and does not meet the requirements. The configuration cannot be performed."
    },
    "config.thin.rate.capacity.check.failed": {
        "zh": u"当前存储池的已分配容量不小于总容量，请联系技术工程师",
        "en": "The allocated capacity of the current storage pool is no less than its total capacity. "
              "Contact technical support engineers."
    },
    "config.thin.rate.failed": {
        "zh": u"当前存储池关闭超分配开关失败，请联系技术工程师",
        "en": "Failed to disable the overcommitment switch for the current storage pool. "
              "Contact technical support engineers."
    },
    "config.scsi.abort.timeout.failed": {
        "zh": u"设置SCSI驱动层IO超时时间失败",
        "en": "Failed to configure the I/O timeout period at the SCSI driver layer."
    },
    "config.compression.ratio.failed": {
        "zh": u"配置精简比失败。",
        "en": "Failed to execute small-scale configuration."
    },
    "config.compression.ratio.not.involved.version": {
        "zh": u"不涉及，存储版本：%s。",
        "en": "Not involve, product version: %s."
    },
    "config.compression.ratio.not.involved.no.pool.info": {
        "zh": u"不涉及，查询存储池信息失败。",
        "en": "Not involve, can not found the pool info."
    },
    "config.compression.ratio.not.involved.pool.type": {
        "zh": u"不涉及，poolType：%s。",
        "en": "Not involve, poolType: %s."
    },
    "disk.num.and.plog.num.check.failed": {
        "zh": u"%s，扩盘数量和plog数量，不满足要求，请按照修复建议操作。",
        "en": "%s,The number of disks to be added and the number of plogs does not meet the requirements. "
              "Perform operations according to the suggestions."
    },
    "expand.disk.expansion.cnt.exceed.threshold": {
        "zh": u"扩容盘数超出阈值, 可能影响业务性能, 如果当前非业务场景请忽略, 各存储池扩容盘数阈值如下(未提到的池按需):\n%s",
        "en": "If the number of disks to be added exceeds the threshold, service performance may be affected."
              "The thresholds for the number of disks to be added in each storage pool are as follows:\n%s"
    },
    "expand.storage.pool.capacity.expansion.solution": {
        "zh": u"存储池[id: %s][名称: %s], 其中各硬盘池扩容盘数阈值如下(未提到的池按需):\n%s",
        "en": "Disk Pool [id: %s][Name: %s],"
              "Thresholds for the number of disks to be added to each disk pool in Storage Pool are as follows:\n%s"
    },
    "expand.disk.pool.capacity.expansion.solution": {
        "zh": u"硬盘池[id: %s][名称：%s, 扩容盘数阈值: %d][巡检结果：%s]\n",
        "en": "Disk Pool[id: %s][Name: %s, Threshold of the number of disks to be added: %d][inspect result: %s]\n"
    },
    "pre.inspection.mdc.cluster.abnormal": {
        "zh": u"查询主MDC节点失败，请检查MDC集群。",
        "en": "The pre-inspection script fails to obtain information. Check the MDC cluster."
    },
    "pre.inspection.production_config.abnormal": {
        "zh": u"主MDC节点/opt/dfv/oam/public/conf/product.ini配置文件查询产品版本失败，请检查配置文件。",
        "en": "No version information is found in the /opt/dfv/oam/public/conf/product.ini configuration "
              "file on the master MDC node. Please check the configuration file."
    },
    "pre.inspection.master.mdc.abnormal": {
        "zh": u"预巡检脚本获取信息失败，请检查主MDC节点。",
        "en": "The pre-check script fails to obtain information. Check the master MDC node."
    },
    "pre.inspection.master.mdc.query.disk.pool.info.error": {
        "zh": u"预巡检脚本获取信息失败，主MDC查询硬盘池容量和主存盘数量失败。",
        "en": "The pre-check script fails to obtain information."
              "Failed to query the disk pool capacity on the active MDC."
    },
    "not.involved": {
        "zh": u"不涉及",
        "en": "Not involved"
    },
    "raid.card.not.compatibility": {
        "zh": u"待扩节点[%s]的[%s]raid卡与产品版本[%s]不兼容。",
        "en": "The RAID card [%s] of the node [%s] to be expanded is incompatible with the product version [%s]."
    },
    "node.exception": {
        "zh": u"节点[%s]异常。",
        "en": "The node [%s] is abnormal."
    },
    "httpscertverify.status.check.failed": {
        "zh": u"节点[%s]iBMC[%s]访问异常。",
        "en": "The node [%s] iBMC [%s] access is abnormal."
    },
    "httpscertverify.status.check.not.pass": {
        "zh": u"节点[%s]iBMC[%s]不符合预期。",
        "en": "The node [%s] iBMC [%s] does not meet the expectation."
    },
    "cert.expire": {
        "zh": u"证书[证书类型：%s]、CA证书[CA证书类型：%s]剩余有效期大于180天且小于365天，建议替换对应证书和CA证书；\n"
              u"证书[证书类型：%s]、CA证书[CA证书类型：%s]剩余有效期小于等于180天，需要替换对应证书和CA证书。",
        "en": "The remaining validity period of the certificate [certificate type: %s] and CA certificate "
              "[CA certificate type: %s] is greater than 180 days and less than 365 days. You are advised to replace "
              "the certificate and CA certificate. \nThe remaining validity period of the certificate "
              "[certificate type: %s] and CA certificate [CA certificate type: %s] is less than or equal to 180 days. "
              "You are required to replace the certificate and CA certificate."
    },
    "check.pool.redundancy.not.pass": {
        "zh": u"id为{}的硬盘池冗余策略不正确 \n",
        "en": "The redundancy policy of the disk pool whose ID is {} is incorrect.\n"
    },
    "or": {
        "zh": u"或",
        "en": "or"
    },
    "show.switch.detail.info": {
        "zh": u"\n交换机详细信息, 请查看报告根目录下：\n%s。",
        "en": "\nFor the switch detail information please check the "
              "following file in the root directory of the report:\n%s .",
    },
    "no.switch.nodes": {
        "zh": u"未添加交换机",
        "en": "No switches are added",
    },
    "not.roce.net": {
        "zh": u"非RoCE组网场景",
        "en": "Not RoCE Networking Scenario",
    },
    "check.node.memory.pass": {
        "zh": u"扩容节点内存检查通过",
        "en": "check expansion node memory pass",
    },
    "check.memory.not.pass.node": {
        "zh": u"池名称:[{}] 扩容节点内存检查不通过:\n原有节点内存总量最小值：[{}] GB\n不通过节点：\n{}",
        "en": "Pool name: [{}] check expansion node memory not pass:\n"
              "Minimum total memory of the original node:[{}] GB\nnot pass node:\n{}",
    },
    "check.memory.query.fail.node": {
        "zh": u"池名称:[{}] 扩容评估内存检查时，发生查询失败:\n查询失败节点：\n{}",
        "en": "Pool name: [{}] when check expansion node memory, query failed:\nquery failed node:\n{}",
    },
    "check.memory.disk.pool.info": {
        "zh": u"池名称:[{}]\n原有节点信息:\n节点IP - 节点内存总量\n{}\n待扩节点信息:\n节点IP - 节点内存总量\n{}",
        "en": "Pool name: [{}]\nOriginal node information:\nNode IP address - Node memory size\n{}\n"
              "Information about nodes to be added:\nNode IP address - Node memory size\n{}",
    },
    "nfsv41_check.result.not.pass": {
        "zh": u"nfsv4业务状态检查不通过",
        "en": "check nfsv4 service status not pass",
    },
    "get.trim.white.list.failed": {
        "zh": u"获取trim白名单失败",
        "en": "Failed to obtain the trim whitelist",
    },
    "has.ssd.models.not.in.trim.white.ls": {
        "zh": u"%s, 有SSD盘的model号不在trim白名单:%s",
        "en": "%s, the following models of SSDs are not in the trim whitelist: %s",
    },
    "block.not.involved": {
        "zh": u"块不涉及（仅非结构化涉及）",
        "en": "It is not involved in block scenarios (only involved in unstructured scenarios)",
    },
    "checkWriteSame.result.not.pass": {
        "zh": u"该环境由801版本升级，建议优化",
        "en": "The software is upgraded from version 801. You are advised to optimize the environment.)",
    },
    "check_1822_roce_driver_version.result.not.pass": {
        "zh": u"1822 驱动版本检测不通过",
        "en": "1822 Driver version detection failed.",
    },
    "check_cluster_nodes_total_length.not.pass": {
        "zh": u"集群节点总长度检查不通过",
        "en": "The total length of the cluster nodes fails to pass the check.",
    },
    "check_msi_irq.result.not.pass": {
        "zh": u"中断rpm包不符合预期",
        "en": "The interruption RPM package is not as expected.",
    },
    "check_snmp_protocol_result.not.pass": {
        "zh": u"当前系统开启了SNMPv1&SNMPv2c协议\n",
        "en": "SNMPv1 and SNMPv2c are enabled in the system.\n",
    },
    "check_snmp_usm_auth_result.not.pass": {
        "zh": u"USM用户%s使用了不安全的鉴权算法%s\n",
        "en": "The USM user %s uses the insecure authentication algorithm %s.\n",
    },
    "check_snmp_usm_priv_result.not.pass": {
        "zh": u"USM用户%s使用了不安全的加密算法%s\n",
        "en": "The USM user %s uses the insecure encryption algorithm %s.\n",
    },
    "check_snmp_usm_auth.not.pass": {
        "zh": u"USM用户%s未启用鉴权算法\n",
        "en": "The USM user %s does not enable the authentication algorithm.\n",
    },
    "check_snmp_usm_priv.not.pass": {
        "zh": u"USM用户%s未启用加密算法\n",
        "en": "The USM user %s does not enable the encryption algorithm.\n",
    },
    "checkDusSwitch.result.not.pass1": {
        "zh": u"该环境开启了重删压缩，请关闭重删压缩",
        "en": "Deduplication and compression are enabled in the environment. Disable deduplication and compression.",
    },
    "checkDusSwitch.result.not.pass2": {
        "zh": u"该环境开启了重删压缩，请升级到最新补丁版本",
        "en": "Deduplication and compression are enabled in the environment. "
              "Upgrade the system to the latest patch version.",
    },
    "check_backplane_is_risk.result.not.pass": {
        "zh": u"执行检查任务失败的节点如下：\n%s",
        "en": "Nodes that failed the check are listed as follows:\n%s",
    },
    "check_disk_forcewb.result.not.pass": {
        "zh": u"执行forcewb巡检项检查失败的节点如下：\n%s",
        "en": "The nodes on which the forcewb inspection item fails to be checked are as follows:\n%s",
    },
    "check_disk_forcewb_result.node.warning": {
        "zh": u"节点: %s\n建议优化：集群中存在硬盘池[poolid=%s]满足forcewb特性开启条件但未开启\n",
        "en": "Node: %s\nRecommended optimization: One or more disk pools[poolids=%s] in the cluster"
              " meets the requirements for enabling the forcewb feature but is disabled.\n",
    },
    "check_disk_forcewb_result.node.normal": {
        "zh": u"节点: %s\n正常\n",
        "en": "Node: %s\nNormal.\n"
    },
    "check_disk_forcewb_result.node.no.support": {
        "zh": u"节点: %s\n不涉及\n",
        "en": "Node: %s\nN/A.\n"
    },
    "check_pi_key_cnt.result.not.pass": {
        "zh": u"PI元数据KEY个数检查不通过：\n%s",
        "en": "The number of PI metadata keys fails to pass the check:\n%s",
    },
    "check.vbs.node.version.not.pass": {
        "zh": u"以下节点版本与管理节点版本不一致:\n%s",
        "en": "The version of the following nodes is inconsistent with that of the management node:\n%s",
    },
    "check.cpu.compatibility.pass": {
        "zh": u"CPU兼容性检查通过",
        "en": "The CPU compatibility check is passed",
    },
    "get.cluster.node.info.failed": {
        "zh": u"{}：获取集群内节点信息失败",
        "en": "{}:Failed to obtain node information in the cluster",
    },
    "get.not.cluster.node.info.failed": {
        "zh": u"{}：获取集群外节点信息失败",
        "en": "{}:Failed to obtain node information outside the cluster",
    },
    "check.cpu.build.pool.check.failed": {
        "zh": u"新建硬盘池:{}:\n待扩节点CPU不兼容",
        "en": "New Build Disk pool:{}:\nThe CPUs of the nodes to be added are incompatible",
    },
    "check.cpu.node.not.support": {
        "zh": u"硬盘池:{}：\n节点CPU不在支持列表中:\n{}\n",
        "en": "Disk pool:{}: \nThe CPUs of the nodes are not in the supported list:\n{}\n",
    },
    "check.cpu.all.not.support": {
        "zh": u"硬盘池[{}]中所有节点的CPU都不在支持列表中\n",
        "en": "None of the nodes in disk pool [{}] has CPUs in the support list\n",
    },
    "check.cpu.1620.1620s.can.not.in.same.disk.pool": {
        "zh": u"硬盘池:{}:\nCPU为1620、1620s的设备不能共硬盘池",
        "en": "Disk pool:{}:\nDevices with 1620 and 1620s CPUs cannot share a disk pool.",
    },
    "check.cpu.1620s.need.811": {
        "zh": u"CPU为1620s的设备需要升级到8.1.1及以后的版本",
        "en": "The device with a 1620s CPU must be upgraded to 8.1.1 or later.",
    },
    "check.cpu.810.811.cluster.not.support.mult.arch": {
        "zh": u"8.1.1及之前版本,不支持ARM、X86架构共集群",
        "en": "In 8.1.1 and earlier versions, ARM and x86 architectures cannot be deployed in the same cluster",
    },
    "check.cpu.expansion.not.match.support.dict": {
        "zh": u"硬盘池:{}:\n支持列表为:{}\n待扩容节点cpu信息为:\n{}",
        "en": "Disk pool:{}:\n Supported list: {}\n CPU information of the node to be expanded:\n{}",
    },
    "default_password_check.result.warning": {
        "zh": u"请确认存储系统是否存在admin账号，如不存在则忽略该检查项结果，如存在则使用admin账号重新执行该巡检项",
        "en": "Check whether the admin account exists in the storage system. If the account does not exist,"
              " ignore the check result. If the account exists, use the admin account to perform the check again."
    },
    "check.node.fips.pass": {
        "zh": u"集群已开启FIPS，待扩节点支持FIPS，检查通过",
        "en": "If FIPS has been enabled in the cluster and the node to be added supports FIPS, "
              "the check result is Passed."
    },
    "product.version.not.involve.check": {
        "zh": u"当前设备版本不涉及检查",
        "en": "No check is required for the current device version."
    },
    "cluster.fips.not.open": {
        "zh": u"集群未开启FIPS，不涉及检查",
        "en": "FIPS is not enabled in the cluster. No check is required."
    },
    "cluster.fips.not.node.outside.cluster": {
        "zh": u"未扩容集群外节点，不涉及检查",
        "en": "Nodes outside the cluster are not expanded. No check is involved."
    },
    "check.fips.not.pass.node": {
        "zh": u"集群已开启FIPS，不支持FIPS的节点：\n[{}]",
        "en": "FIPS has been enabled in the cluster. Nodes that do not support FIPS: \n[{}]"
    },
    "data.cluster.modules.result.missing": {
        "zh": u"巡检节点应包含所有节点或至少包含主管理节点。",
        "en": "The nodes to be checked must contain all nodes or at least the active management node."
    },
    "data.cluster.modules.result.offline": {
        "zh": u"数据集群模块（%s）已离线。",
        "en": "The data cluster module(%s) is offline."
    },
    "data.cluster.modules.result.abnormal": {
        "zh": u"设备（%s）所在框的两个数据集群模块没有全部添加。",
        "en": "Not all the two data cluster modules of the chassis where the device (%s) resides are added."
    },
    "check.major.alarm": {
        "zh": u"存在未恢复告警。",
        "en": "Uncleared Alarms Exist."
    },
    "alarm.info": {
        "zh": u"级别:{}\nID:{}\n描述:{}\n发生时间:{}\n详细信息:{}\n",
        "en": "Severity:{}\nID:{}\nDescription:{}\nOccurred:{}\nDetails:{}\n"
    },
    "alarm.level.5": {
        "zh": u"重要",
        "en": "major"
    },
    "alarm.level.6": {
        "zh": u"紧急",
        "en": "critical"
    },
    "alarm.level.3": {
        "zh": u"警告",
        "en": "warning"
    },
    "checkPangeaSASDriverUpgrade.result.not.pass": {
        "zh": u"SAS驱动版本检测不通过",
        "en": "SAS Driver version detection failed.",
    },
    "check.cache.watermark.result.pass": {
        "zh": u"节点: {}\n正常.Cache水位: {}\n",
        "en": "Node: {}\nNormal.cache watermark: {}\n"
    },
    "check.cache.watermark.result.not.pass": {
        "zh": u"节点: {}\n异常.Cache水位: {}\n",
        "en": "Node: {}\nAbormal.cache watermark: {}\n"
    },
    "check.cache.watermark.abnormal.tips": {
        "zh": u"水位检查不通过，扩容存在风险",
        "en": "watermark is abnormal. Capacity Expansion may be risky."
    },
    "check.metadata.not.pass": {
        "zh": u"db:{} 元数据数量({})超限",
        "en": "db:{}, metadata({}) exceeds the limit."
    },
    "check.plognum.not.pass": {
        "zh": u"table类型:{}, 存储池:{}, vnode:{} plog数量({})超限",
        "en": "table type:{}, storage pool:{}, vnode:{} plog num ({}) exceeds the limit."
    },
    "check.mig.status.not.pass": {
        "zh": u"存储池:{}后台迁移中",
        "en": "Storage pool: {} is being migrated in the background."
    },
    "check.storage.pool.water.level.not.pass": {
        "zh": u"存储池:{}水位超限",
        "en": "Storage pool: {} water level exceeded the threshold."
    },
    "check.cluster.numa.consistent.not.pass": {
        "zh": u"存储池(Id:{})内节点的Numa开关不一致",
        "en": "The Numa switch of nodes in the storage pool (Id:{}) is inconsistent."
    },
    "check.uce.normal": {
        "zh": u"内存UCE事件无法正常上报",
        "en": "Memory UCE events cannot be reported."
    },
    "check_iam_status_is_risk.result.not.pass": {
        "zh": u"一跳升级检查不通过：\n%s",
        "en": "Nodes that failed the check are listed as follows:\n%s"
    },
}
