# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
from com.huawei.ism.tool.devicemanager.entity import ProductUniqueIdConfig

from constant import VE_SUPPORTED_MAIN_BOARD_UIDS, V6_SUPPORTED_MAIN_BOARD_UIDS


def is_ve_supported_main_board(product_unique_id):
    """
    判断是否是VE机型
    :param product_unique_id: 主板的UID
    :return: 是/否
    """
    return product_unique_id in VE_SUPPORTED_MAIN_BOARD_UIDS


def is_v6_supported_main_board(product_unique_id):
    """
    判断是否是V6服务器类型
    :param product_unique_id:
    :return:
    """
    return product_unique_id in V6_SUPPORTED_MAIN_BOARD_UIDS


def get_mapping_attribute(context, uid, key):
    strategy_map = context.get("mappingStrategy").getStrategy().get("nfv.dedicated")
    if strategy_map.isEmpty():
        return ""

    platform_strategy = strategy_map.get(get_platform_id(uid))
    if not platform_strategy:
        return ""

    value = platform_strategy.findAttributeValue(key)
    if value == "--":
        return ""
    return value


def get_platform_id(uid):
    """
    获取设备平台id，例如x86_64，在strategy.xml中配置
    :param uid:设备的uid号码
    :return: 设备平台id
    """
    return ProductUniqueIdConfig.INS.getPlatformTypeByUid(uid).getId()


def get_mapping_fw_version(context, uid, key):
    """
    获取配套的固件版本，包含海燕机型的判断
    :param context: 上下文
    :param uid 设备的UID号
    :param key: mapping key
    :return: 配套版本
    """
    return get_mapping_attribute(context, uid, key)
