# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

from resource_client import ManagerResourceClient, SystemsResourceClient


def get_product_unique_id(redfish_conn, logger):
    """
    获取服务器product unique id
    :param redfish_conn: redfish连接
    :param logger: 日志
    :return: productUniqueId
    :raise: IsmException 获取失败异常
    """
    client = ManagerResourceClient(redfish_conn, logger)
    info = client.get_assign_resource_info()
    try:
        unique_id = info.get("Oem").values()[0].get("ProductUniqueID")
        logger.logInfo("[ProductUniqueID] {}".format(unique_id))
        return str(unique_id).lower(), str(info)
    except AttributeError as error:
        raise Exception("Get unique id error: {}".format(error))


def get_all_bios_info(redfish, logger):
    """
    获取所有Bios信息
    :param redfish: redfish 连接
    :param logger: 日志
    :return: bios信息 dict
    """
    logger.logInfo("start get all bios info.")
    client = SystemsResourceClient(redfish, logger)
    bios_info, resource = client.get_bios_info()
    logger.logInfo("[All Bios Info] {} ".format(bios_info))
    return bios_info, str(resource)


def get_storage_logical_drive_resource_infos(redfish, logger):
    """
    获取存储的逻辑驱动器资源信息
    :param redfish: redfish接口
    :param logger: 日志
    :return: 逻辑驱动器信息
    """
    client = SystemsResourceClient(redfish, logger)
    return client.get_storage_logical_drive_resource_infos()


def get_ibmc_main_board_num(redfish, logger):
    """
    获取ibmc主板编号
    :param redfish:redfish接口
    :param logger: 日志
    :return: 取值的主板编号
    """
    client = ManagerResourceClient(redfish, logger)
    info = client.get_assign_resource_info()
    manager_type_2_main_bord_num = {"iBMC": "1710", "iBMC3": "1711"}
    manager_type = info.get("Model")
    if manager_type in manager_type_2_main_bord_num:
        return manager_type_2_main_bord_num.get(manager_type), str(info)
    raise Exception("unidentifiable manager type.")


def get_managers_info(redfish, logger):
    return ManagerResourceClient(redfish, logger).get_assign_resource_info()
