#!/bin/bash

########################################################################################
#ڵdedupǷ
#أ1   ڵdedupѴ
#أ0   ڵdedupδ
########################################################################################
SCRIPT_NAME=$(basename $0)

declare -r MODULE_NAME="is_dedup_check"
declare -r MICROSERVICE_NAME="Common"
declare -r LOG_PATH="/opt/dfv/oam/public/result/inspect/${MICROSERVICE_NAME}/"
declare -r LOG_NAME="inspect_${MODULE_NAME}.sh.rst"
declare -r LOG_FILE=${LOG_PATH}/${LOG_NAME}

#־·ļ
if [ ! -d ${LOG_PATH} ];then
    mkdir -p ${LOG_PATH}
    chmod 750 ${LOG_PATH}
fi

if [ ! -f ${LOG_FILE} ];then
    touch ${LOG_FILE}
    chmod 640 ${LOG_FILE}
fi

#ѯMONGO DB·
declare -r IS_DEDUP_OUTPUT="/tmp/is_dedup_output"

#ѲϸϢ
function log()
{
    local param1=$1
    local param2=$2
    local param3=$3

    echo "[""$(date +'%F %T')""]""[""${param1}""]""[""${param2}""]""[""${param3}""]" >> "${LOG_FILE}" 2>/dev/null
}

function do_dedup_check()
{
    if [ -f "${IS_DEDUP_OUTPUT}" ]; then
        rm -f ${IS_DEDUP_OUTPUT}
    fi
    
    local is_dedup_open=""
    
    echo "use dfv_s3_object_service
          db.account.find().limit(1000)
          exit
          "|mongoshell client >${IS_DEDUP_OUTPUT} 2>&1
    
    is_dedup_open=`cat ${IS_DEDUP_OUTPUT} | grep "\"df\" : true"`
    if [ ! -z "${is_dedup_open}" ];then
        return 1
    fi
    
    return 0 
}

function main()
{
    log "INFO: begin to inspect. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPT_NAME}
    do_dedup_check
    if [ $? -ne 0 ]; then
        log "INFO: The dedup is open. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPT_NAME}
        return 4
    else
        log "INFO: The dedup is not open. [Line:${LINENO}]" ${FUNCNAME} ${SCRIPT_NAME}
        return 0
    fi

}

main