# -*- coding: UTF-8 -*-
import re 
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 级联模块状态检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    controllerID = ""
    status = ""
    errMsg = ""
    
    cliRet = cli.execCmd("showexpmodule")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."
        return (flag, cliRet, errMsg)    
    
    for field in list:
        field = field.replace(" ", "").replace("|", "")
        if field.startswith("ControllerID"):
            controllerID = field.replace("ControllerID", "")
        elif field.startswith("Status"):
            status = field.replace("Status", "")
            if status != "Normal":
                flag = False
                if "zh" == lang:
                    errMsg += u"\n控制器（控制器ID：" + controllerID + u"）的级联模块存在异常（" + status + u"）。"
                else:
                    errMsg += "\nThe status of expansion module of controller (controller-id:" \
                              + controllerID + ") is abnormal(" + status + ")."
  
    return (flag, cliRet, errMsg)