# -*- coding: UTF-8 -*-
import re 
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 框状态检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    enclosureList = []
    fanList = ['0', '1', '2', '3']
    fanStatus = ""
    errMsg = ""
    
    cliRet = cli.execCmd("showenclosure")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, True):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."        
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 7:
            continue
        enclosureList.append(list2[0])

    for enclosureID in enclosureList:
        for fanID in fanList:
            cliRet2 = cli.execCmd("showfan -e " + enclosureID + " -f " + fanID)
            list3 = cliRet2.splitlines()
            for field2 in list3:
                field2 = field2.replace(" ", "").replace("|", "")
                if field2.startswith("Status"):
                    cliRet += cliRet2
                    fanStatus = field2.replace("Status", "")
                    if fanStatus != "Normal":
                        flag = False
                        if "zh" == lang:
                            errMsg += u"\n风扇（框ID：" + enclosureID + u"风扇ID：" + fanID\
                                      + u"）的状态存在异常（" + fanStatus + u"）。"
                        else:
                            errMsg += "\nThe status of fan (enclosure-id:" + enclosureID + ", fan-id:" \
                              + fanID + ") is abnormal(" + fanStatus + ")."

    return (flag, cliRet, errMsg)
