# -*- coding: UTF-8 -*-
import common
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    
    cliRet = cli.execCmd("showdisk -logic")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, True):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information." 
        return (flag, cliRet, errMsg)
    i = 0
    freeHotSpareDiskNum = 0
    for field in list:
        i = i + 1
        if i >= 7:
            list2 = field.split()
            if len(list2) < 2:
                continue
            if "Free spare" in field:
                freeHotSpareDiskNum += 1
    if freeHotSpareDiskNum == 0:
        flag = False
        if lang == "zh":
            errMsg = u"空闲热备盘不足。"
        else:
            errMsg = "Hot spare disks are insufficient."
    return (flag, cliRet, errMsg)
