﻿# -*- coding: UTF-8 -*-
import common
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    errMsg = ""
    lang = py_java_env.get("lang")
    cliRet = cli.execCmd("showpool")
    list = cliRet.splitlines()
    #系统存在pool才巡检通过，否则巡检失败
    if len(list) < 7:
        flag = False
        if lang == "zh":
            errMsg = u"\n资源池信息无效。"
        else:
            errMsg = "\nInvalid pool information." 
        return (flag, cliRet, errMsg)
    if "RAID" in list[6]:
        poolStatus = list[6].split()[1]
        if poolStatus in ['Fault', 'Degrade']:
            flag = False
            if 'zh' == lang:
                errMsg = u"系统资源池状态存在异常（" + poolStatus + u"）。"
            else:
                errMsg = "The status of system pool is abnormal (" + poolStatus + ")."
    else:
        flag = False
        if lang == "zh":
            errMsg = u"\n资源池信息无效。"
        else:
            errMsg = "\nInvalid pool information."
    return (flag, cliRet, errMsg)
