# -*- coding: UTF-8 -*-

"""电源状态判断条件增加 added Begin"""
import re
"""电源状态判断条件增加 added End"""
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 电源状态检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    powerStatus = ""
    errMsg = ""
    
    cliRet = cli.execCmd("showpower")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, True):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 4:
            continue
        # There are three kinds of status: Normal, No Input and Fault.
        # The status "No Input" is special(a space between the two words),
        # therefore it should be special treated. 
        """电源状态判断条件增加 added Begin"""
        if list2[2] in ["No", "Input", "Not", "I2C", "Voltage", "Switch"]:
            powerStatus = list2[2] + " " + list2[3]
        else:
            powerStatus = list2[2]
        """电源状态判断条件增加 added End"""
            
        if powerStatus != "Normal":
            flag = False
            if "zh" == lang:
                errMsg += u"\n电源（框ID：" + list2[0] + u"，电源ID：" + list2[1]\
                          + u"）状态不正常（" + powerStatus + u"）。"
            else:
                errMsg += "\nThe status of power (enclosure-id:" + list2[0] + ", power-id:" \
                          + list2[1] + ") is abnormal(" + powerStatus + ")."

    return (flag, cliRet, errMsg)