# -*- coding: UTF-8 -*-
from java.io import File
from java.lang import Exception
from cbb.frame.util.tar_util import decompress_tar_all_file
import os
import re
import string
import common
import shutil
import traceback

# **************************************************************************** #
# 函数名称: getDeviceSNNumber
# 功能说明: 获取设备SN号
# 输入参数: cli
# **************************************************************************** #
def getDeviceSNNumber(cli): 

    deviceSnNum = ""
    
    ctrlSpc = cli.execCmd('showsys')
    lineList = ctrlSpc.splitlines()
    
    for line in lineList:
        if re.search("Device Serial Number", line, re.IGNORECASE):
            deviceSnNum = line.split("|")[-1].strip()
            break

    return deviceSnNum

# **************************************************************************** #
# 函数名称: decompressPKG
# 功能说明: 解压告警文件
# 输入参数: filePath，depressPath
# **************************************************************************** #
def decompressPKG(filePath, depressPath):
    decompress_tar_all_file(filePath, depressPath)

# **************************************************************************** #
# 函数名称: secureGetEventFile
# 功能说明: 安全红线后的版本：获取告警文件
# 输入参数: cli
# **************************************************************************** #
def secureGetEventFile(cli):
    
    flag = True
    errMsg = ""
    remoteFile = ""
    lang = py_java_env.get("lang")
    
    #通过Cli命令导出告警文件
    cliRet = cli.execCmd("exportsysevent -t alarm")
    #Cli回文异常，直接返回不通过
    if not bool(re.search("Path", cliRet, re.IGNORECASE)):
        flag = False
        if "zh" == lang:
            errMsg = u"\n通过CLI命令生成告警文件失败，请通过登录ISM查看是否存在未恢复告警。"
        else:
            errMsg = "\nRunning cli command to creat alarm file failed, please check the unrecovered alarm by ISM."
        return (flag, errMsg, remoteFile)
    
    lineList = cliRet.splitlines()    
    for line in lineList:
        if re.search("Path :", line, re.IGNORECASE):
            remoteFile =  line.replace("Path :", "").replace(" ", "")
            break 
    
    return (flag, errMsg, remoteFile)

# **************************************************************************** #
# 函数名称: deleteRemoteFile
# 功能说明: 清理设备临时文件
# 输入参数: collectRemotePath阵列端文件路径
# **************************************************************************** #
def deleteRemoteFile(collectRemotePath):
    try:
        sftp = py_java_env.get("sftp")
        logger = py_java_env.get("logger")
        #使用sftp自带接口删除远端临时文件
        if not collectRemotePath:
            logger.error("[deleteRemoteFile] delete file is:" + str(collectRemotePath))
            return False
        else:
            sftp.deleteFile(collectRemotePath)
            return True
    except:
        logger.error("[deleteRemoteFile] except trace back:" + str(traceback.format_exc()))
        return False

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 脚本执行接口
# 输入参数: cli
# **************************************************************************** #
def execute(cli):

    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""

    #P12V-2951 未恢复告警检查项优化 modified 20130807 Begin
    #工具传入的SFTP为空，检查失败
    cliRet = ""
    sftp = py_java_env.get("sftp")
    if sftp is None:
        if "zh" == lang:
            errMsg = u"工具传入SFTP为空，检查失败，请通过登录ISM查看是否存在未恢复告警。"
        else:
            errMsg = "The sftp provided by tool is None, check failed, please check the unrecovered alarm by ISM."
        return (False, cliRet, errMsg)
    
    #获取设备SN号，唯一标识设备
    deviceSnNum = getDeviceSNNumber(cli)

    #获取告警文件
    iRet = secureGetEventFile(cli)
    
    #判断有效性
    if not iRet[0]:
        return (False, cliRet, iRet[1])
    
    #获取远程文件路径
    remoteFile = iRet[2]
    
    #创建文件保存路径
    saveDir = 'tmp' + os.path.sep + deviceSnNum + os.path.sep
    if not os.path.exists(saveDir):
        os.mkdir(saveDir)
    
    localFileName = saveDir + 'event_export.tar'
    try:
        sftp.getFile(remoteFile, localFileName, None)
    except Exception:
        shutil.rmtree(saveDir, True)
        if "zh" == lang:
            errMsg += u"\n告警文件" + remoteFile + u"不存在。"
        else:
            errMsg += "\nAlarm file " + remoteFile + " does not exist."
        return (False, cliRet, errMsg)
    finally:
        deleteRemoteFile(remoteFile)
    #解压文件
    decompressPKG(localFileName, saveDir)
    alarmFile = open(saveDir + os.sep + 'local_alm_file.txt', "r")
    alarmIDs = []
    cliRet = "Raised  Local Time    Alarm ID    Alarm Level    Recovered Local Time    Description\n"
    for line in alarmFile:
        if line.find("Event list") >= 0:
            break
        
        list = line.split()
        if len(list) < 5:
            continue
        if list[4] != "None":
            continue
        if list[3] not in ("Major", "Critical", "Warning"):
            continue
        
        flag = False
        # 将Suggestion字段之前的字符串添加到原始信息cliRet中。
        index = line.find("Step 1")
        cliRet += line[0:index]
        cliRet += "\n"

        alarmIDs.append(list[2])
    alarmFile.close()
    
    if not flag:
        if "zh" == lang:
            errMsg += u"\n存在未恢复告警，告警ID列表：" + str(alarmIDs).replace("[", "").replace("]", "") + u"。"
        else:
            errMsg += "\nThere are unrecovered alarms: " + str(alarmIDs).replace("[", "").replace("]", "")\
                      + "."
    
    #删除临时文件
    shutil.rmtree(saveDir, True)
    
    return (flag, cliRet, errMsg)