# -*- coding: UTF-8 -*-

import re

normalInfo = "command operates successfully|license|not exist|not support"

# **************************************************************************** #
# 函数名称: checkCliInfoValid
# 功能说明: 查询当前获取的Cli信息是否有效
# 输入参数: cliInfo：命令回文信息（String）
#                   necessaryData：系统中必须包含的配置为True（如控制器、框等）（boolean）
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def checkCliInfoValid(cliInfo, necessaryData):
    
    #异常模式
    if re.search("-bash", cliInfo, re.IGNORECASE):
        return False
    
    #命令回文大于5行，说明必然有数据，检查通过
    lineList = cliInfo.splitlines()
    if len(lineList) >= 5:
        return True

    #系统中必须包含的配置（如控制器、框等）
    if necessaryData:
        return False

    #非必需配置项，按照如下标准检查
    flag = False
    if re.search(normalInfo, cliInfo, re.IGNORECASE):
        flag = True
    else:
        flag = False
        
    return flag

# **************************************************************************** #
# 函数名称: changeCli2Developer
# 功能说明: 从Cli模式进入developer模式
# 输入参数:ssh
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeCli2Developer(ssh, py_java_env):
    developerPwd = py_java_env.get("devPwd").get("developer")
    if not developerPwd:
        return False

    temp = ssh.execCmd("developer")
    if re.search("Are you sure", temp, re.IGNORECASE):
        temp1 = ssh.execCmd("y")
        if re.search("Enter Password", temp1, re.IGNORECASE):
            temp2 = ssh.execCmdNoLog(developerPwd)
            if re.search("developer:", temp2, re.IGNORECASE):
               return True
    else:
        if re.search("Enter Password", temp, re.IGNORECASE):
            temp1 = ssh.execCmdNoLog(developerPwd)
            if re.search("developer:", temp1, re.IGNORECASE):
                return True
        
    #进入developer模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False

def changeAnyModel2Cli(ssh, sftp = None):
    '''
            当从minisystem模式退到CLI模式时需要重连SFTP
    '''
    counter = 0
    while True:
        temp = ssh.execCmd("showsys")
        #非developer模式下，cli回文正确，则认为回到了cli
        if re.search("System Name", temp, re.IGNORECASE) \
            and not re.search("developer", temp, re.IGNORECASE):
                break
        #老版本在minisystem下直接exit会退出连接，需要重连
        elif re.search("minisystem>", temp, re.IGNORECASE):
            temp1 = ssh.execCmd("exit")
            if re.search("Are you sure", temp1, re.IGNORECASE):
                try:
                    ssh.execCmd("y")
                except:
                    ssh.reConnect()
                    if sftp !=None:
                        sftp.reConnect()
                continue

        #其他情况下，直接exit
        else:
            temp1 = ssh.execCmd("exit")
            if re.search("Are you sure", temp1, re.IGNORECASE):
                ssh.execCmd("y")
        
        #单控的命令模式最多4层
        counter += 1
        if counter >= 4:
            break

def getHorizontalStandardCliRet(cliRet):
    '''
    @summary: 按逐行字典的方式获取垂直表格形式的cli回显集合
    @param cliRet: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    '''
    try:
        lineDict = {}
        cliRetList = cliRet.encode("utf8").splitlines()
        for line in cliRetList:
            split_Mark_Colon =":"
            split_Mark_Equal ="|"
            
            key = ""
            val = ""
            if split_Mark_Colon in line:
                list = line.split(split_Mark_Colon)
                key = list[0].strip()
                #对值进行有效性判断
                val = list[1].strip()
                lineDict.setdefault(key,val)
            if split_Mark_Equal in line:
                list = line.split(split_Mark_Equal)
                key = list[0].strip()
                val = list[1].strip()
                lineDict.setdefault(key,val)
        return lineDict
    except:
        return {}
    
def switchValidVersion(version):
    '''
    @summary: 将版本号转化成有效的版本号（17位：V100R002C00SPC001 或者11位：V100R005C02）
    @param version: the version of device
    @return: validVersion
    '''
    validVersion = ""
    
    startIndex = version.index("V100")
    if re.search("SPC", version, re.IGNORECASE):
        endIndex = startIndex + 17  #格式：V100R002C00SPC001
    else:
        endIndex = startIndex + 11  #格式：V100R005C02
    
    #提取有效的版本号信息
    validVersion = version[startIndex: endIndex]
    
    return validVersion