# -*- coding: UTF-8 -*-

import re 
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: BBU电量检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    BBUID = ""
    errMsg = ""
    
    cliRet = cli.execCmd("showbbu")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, True):
            flag = False
            if lang == "zh":
                errMsg = u"\n获取BBU信息无效。"
            else:
                errMsg = "\nGet BBU information invalid."
        return (flag, cliRet, errMsg)   
       
    for field in list:
        field = field.replace(" ", "").replace("|", "")
        
        if field.startswith("BBUID"):
            BBUID = field.replace("BBUID", "")
        elif field.startswith("BBUPower"):
            if field.replace("BBUPower", "") != "Sufficient":
                flag = False
                if "zh" == lang:
                    errMsg += u"\nBBU（BBU ID：" + BBUID + u"）的电量不足。"
                else:
                    errMsg += "\nThe power of BBU (bbu-id:" + BBUID + ") is insufficient."
    
    return (flag, cliRet, errMsg)