# -*- coding: UTF-8 -*-

#P11G-5564 CPU利用率巡检项新需求  modified Begin
from time import sleep
#P11G-5564 CPU利用率巡检项新需求  modified End
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: CPU利用率检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    controllerID = ""

    #P11G-5564 CPU利用率巡检项新需求  modified Begin
    allcliRet = ''
    
    counter_A = 0
    counter_B = 0
    counter = 0
    
    CPUUtility_A = 0
    CPUUtility_B = 0
    
    AverageCpuUtility_A = 0
    AverageCpuUtility_B = 0
    
    while True:
        #初始化CPU利用率信息
        CPUUtility = 0
        cliRet = cli.execCmd("showcontroller")
        list = cliRet.splitlines()
        if len(list) < 7:
            if "zh" == lang:
                errMsg = u"\n未取到有效的控制器信息。"
            else:
                errMsg = "\nFailed to get valid controller information."

            return (False, cliRet, errMsg)

        for field in list:
            field = field.replace(" ", "").replace("|", "")
            
            if field.startswith("ControllerID"):
                controllerID = field.replace("ControllerID", "")                    
            elif field.startswith("CPUUtility(%)"):                
                CPUUtility = int(field.replace("CPUUtility(%)", ""))
                
                #指定控制器CPU利用率信息取得
                if 'A' == controllerID:
                    counter_A += 1
                    CPUUtility_A += CPUUtility
                elif 'B' == controllerID:
                    counter_B += 1
                    CPUUtility_B += CPUUtility
                else:
                    break
                

        allcliRet += '\n' + cliRet
        
        counter += 1
        
        if counter >=4:
            break
        else:
            sleep(5)
    
    #计算每个控制器的平均CPU利用率
    if counter_A != 0:
        AverageCpuUtility_A = CPUUtility_A / counter_A
    if counter_B != 0:
        AverageCpuUtility_B = CPUUtility_B / counter_B
    
    #控制器A的CPU利用率判断及错误信息打印
    if AverageCpuUtility_A >= 80:
        flag = False
        if "zh" == lang:
            errMsg += u"\n控制器A" + u"的CPU平均使用率为" + str(AverageCpuUtility_A)\
                        + u"%，阵列处于工作繁忙状态。"
        else:
            errMsg += "\nThe average CPU utility of controller A"\
                        + " is " + str(AverageCpuUtility_A) + "%, so the disk array is overloaded."
    
    #控制器B的CPU利用率判断及错误信息打印
    if AverageCpuUtility_B >= 80:
        flag = False
        if "zh" == lang:
            errMsg += u"\n控制器B" + u"的CPU平均使用率为" + str(AverageCpuUtility_B)\
                        + u"%，阵列处于工作繁忙状态。"
        else:
            errMsg += "\nThe average CPU utility of controller B"\
                        + " is " + str(AverageCpuUtility_B) + "%, so the disk array is overloaded."

    return (flag, allcliRet, errMsg)
    #P11G-5564 CPU利用率巡检项新需求  modified End
