# -*- coding: UTF-8 -*-
import re
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 控制器状态检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    controllerID = ""
    operationStatus = ""
    healthStatus = ""
    
    cliRet = cli.execCmd("showcontroller")
    if not re.search("Controller Information", cliRet, re.IGNORECASE):
        flag = False
        if lang == "zh":
            errMsg = u"\n获取控制器信息无效。"
        else:
            errMsg = "\nController information invalid."
        return (False, cliRet, errMsg)
    list = cliRet.splitlines()
    for field in list:
        field = field.replace(" ", "").replace("|", "")
        if field.startswith("ControllerID"):
            controllerID = field.replace("ControllerID", "")
        elif field.startswith("OperationStatus"):
            operationStatus = field.replace("OperationStatus", "")
            if "Normal" != operationStatus:
                flag = False
                if "zh" == lang:
                    errMsg += u"\n控制器（控制器ID：" + controllerID + u"）的操作状态存在异常（" + operationStatus + u"）。"
                else:
                    errMsg += "\nThe operation status of controller (controller-id:" + controllerID\
                              + ") is abnormal(" + operationStatus + ")."
        elif field.startswith("HealthStatus"):
            healthStatus = field.replace("HealthStatus", "")
            if "Normal" != healthStatus:
                flag = False
                if "zh" == lang:
                    errMsg += u"\n控制器（控制器ID：" + controllerID + u"）的健康状态存在异常（" + healthStatus + u"）。"
                else:
                    errMsg += "\nThe health status of controller (controller-id:" + controllerID\
                              + ") is abnormal(" + healthStatus + ")."
    return (flag, cliRet, errMsg)