# -*- coding: UTF-8 -*-

import re
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 硬盘逻辑状态检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : check Disk Logical Status 
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    import re

    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    
    #P11G-5709 重构完成的盘为异常 modified 20130218 Begin
    normalStatus = "Normal|Free spare|Used spare|Reconstruction is in progress|Copyback is in process"
    #P11G-5709 重构完成的盘为异常 modified 20130218 End
    normalStatus = re.compile(normalStatus)

    cliRet = cli.execCmd("showdisk -logic")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, True):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information." 
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 2:
            continue
        if not re.search(normalStatus, field):
            flag = False
            if "zh" == lang:
                errMsg += u"\n硬盘" + list2[0] + u"的逻辑状态存在异常（" + list2[1] + u"）。"
            else:
                errMsg += "\nThe logical status of disk " + list2[0] \
                          + " is abnormal(" + list2[1] + ")."

    return (flag, cliRet, errMsg)