# -*- coding: UTF-8 -*-
import re 
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 硬盘物理状态检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    
    cliRet = cli.execCmd("showdisk -physic")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, True):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."         
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 2:
            continue
        if "Normal" != list2[1]:
            flag = False
            #取得硬盘物理状态
            physicStatus = ""
            if "Single" == list2[1]:
                physicStatus = "Single path"
            elif "Write" == list2[1]:
                physicStatus = "Write protect"
            elif "Off" == list2[1]:
                physicStatus = "Off line"
            else:
                physicStatus = list2[1]
                
            if "zh" == lang:
                errMsg += u"\n硬盘" + list2[0] + u"的物理状态存在异常（" + physicStatus + u"）。"
            else:
                errMsg += "\nThe physical status of disk " + list2[0] \
                          + " is abnormal(" + physicStatus + ")."

    return (flag, cliRet, errMsg)