# -*- coding: UTF-8 -*-

#P11G-5588检查FC端口误码巡检项修改 20121214 modified Begin
from time import sleep
import re
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: FC误码检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):

    """cli回显信息格式
    ===============================================
                   FC Port Bit Error
    -----------------------------------------------
      Control ID            | A
      Interface Module ID   | 0
      Port ID               | P0
      Link Status           | Link Up
      Lost Signals          | 0
      Link Errors Codes     | 0
      Lost Synchronizations | 0
      Failed Connections    | 0
      Start Time            | 2012-12-12 18:11:48
    -----------------------------------------------
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    cliRet = ""
    cliRetTmp = ""
    
    controlID = ""
    interfaceModuleID = ""
    portID = ""
    numberOfErrorCodes = ""
    counter = 0
    firstTime = True

    #保存第一次cli命令取得的误码信息
    FirstTimePortErrCodeInfo = ""
    #保存检查不通过的端口信息
    PortErrCodeCheckError = ""

    #循环发送6次cli命令，提取并检查误码信息
    while True:
        cliRetTmp = cli.execCmd("showfcber")
        
        # 如果没有取得有效信息，则直接返回巡检成功
        if not bool(re.search("FC Port Bit Error", cliRetTmp)):
            #判断cli信息是否有效
            flag = True
            if not common.checkCliInfoValid(cliRetTmp, False):
                flag = False
                if lang == "zh":
                    errMsg = u"\nCli信息无效。"
                else:
                    errMsg = "\nInvalid Cli information."            
            return (flag, cliRetTmp, errMsg)
        
        #解析cli回显信息
        list = cliRetTmp.splitlines()
        for field in list:
            #过滤掉无用字符，便于分析
            field = field.replace(" ", "").replace("|", "")
            
            #解析端口相关信息
            if field.startswith("ControlID"):
                controlID = field.replace("ControlID", "")            
            elif field.startswith("InterfaceModuleID"):
                interfaceModuleID = field.replace("InterfaceModuleID", "")
            elif field.startswith("PortID"):
                portID = field.replace("PortID", "")
            elif field.startswith("LinkErrorsCodes"):
                numberOfErrorCodes = field.replace("LinkErrorsCodes", "")
            else:
                continue

            #如果误码不为空，则说明已经统计完一个端口的数据,保存数据到指定的信息中
            if "" != numberOfErrorCodes:
                if True == firstTime:
                    """第一次cli统计：提取的所有端口信息并保存"""
                    FirstTimePortErrCodeInfo = ProcessFirstTimeCli(controlID, interfaceModuleID, portID, numberOfErrorCodes, FirstTimePortErrCodeInfo)

                else:
                    """非第一次cli统计：搜索第一次cli提取的所有端口信息，匹配指定的端口，并将误码数插入字符串尾部"""
                    PortErrCodeCheckError = ProcessLastTimeCli(controlID, interfaceModuleID, portID, numberOfErrorCodes, FirstTimePortErrCodeInfo, PortErrCodeCheckError)
                
                """重新清空误码信息"""
                numberOfErrorCodes = ""
            else:
                continue
  
        #循环控制
        cliRet += "\n" + cliRetTmp
        if firstTime == True:
            firstTime = False

        counter += 1
        if counter >= 6:
            break
        else:
            sleep(10)

    if PortErrCodeCheckError != "":
        flag = False
        #将所有误码检查不通过的端口信息打印
        list = PortErrCodeCheckError.splitlines()
        for field in list:
            portinfo = field.split()
            #误码检查返回信息修改 modified 20140421 Begin
            if "zh" == lang:
                errMsg += u"\nFC端口（控制器ID：" + portinfo[0] + u"接口模块ID：" + portinfo[1]\
                          + u"，端口ID：" + portinfo[2] + u"）存在增加误码。"
            else:
                errMsg += "\n" + "Error packets are generated at the system FC port (controller-id:" + portinfo[0]\
                + ", interface-module-id:" + portinfo[1] + ", port-id:" +  portinfo[2] + ")."
            #误码检查返回信息修改 modified 20140421 End
                    
    return (flag, cliRet, errMsg)

# **************************************************************************** #
# 函数名称: ProcessFirstTimeCli
# 功能说明: 处理第一次cli统计信息：提取的所有端口信息并保存
# 输入参数: controlID, interfaceModuleID, portID, numberOfErrorCodes, FirstTimePortErrCodeInfo
# 输出参数: 无
# 返 回 值: FirstTimePortErrCodeInfo
# **************************************************************************** # 
def ProcessFirstTimeCli(controlID, interfaceModuleID, portID, numberOfErrorCodes, FirstTimePortErrCodeInfo):

    #统计端口信息
    insertInfo = controlID + " " + interfaceModuleID + " " + portID + " " + numberOfErrorCodes + "\n"
    FirstTimePortErrCodeInfo += insertInfo
    
    return FirstTimePortErrCodeInfo

# **************************************************************************** #
# 函数名称: ProcessLastTimeCli
# 功能说明: 处理非第一次cli统计信息：与第一次信息进行对比
# 输入参数: controlID, interfaceModuleID, portID, numberOfConsistErrors, FirstTimePortErrCodeInfo, PortErrCodeCheckError
# 输出参数: 无
# 返 回 值: PortErrCodeCheckError
# **************************************************************************** # 
def ProcessLastTimeCli(controlID, interfaceModuleID, portID, numberOfErrorCodes, FirstTimePortErrCodeInfo, PortErrCodeCheckError):
    
    #设定匹配信息:控制器ID+接口模块ID+端口ID
    searchInfo = controlID + " " + interfaceModuleID + " " + portID
    
    #如果此端口已经检查不通过，则不需要再判断
    if bool(re.search(searchInfo, PortErrCodeCheckError, re.IGNORECASE)):
        return PortErrCodeCheckError

    #将非第一次取得的端口信息与第一次取得信息比较
    list = FirstTimePortErrCodeInfo.splitlines()
    for field in list:
        #匹配信息成功，同一个端口
        if field.startswith(searchInfo):
            
            #获取第一次取得的误码数据
            ErrorPacketsNumberFirst = field.replace(searchInfo, "").replace(" ", "")
            
            if numberOfErrorCodes != ErrorPacketsNumberFirst:
                #误码检查不通过，将此端口信息填入检查失败列表中
                PortErrCodeCheckError += searchInfo + "\n"
                flag = False
            break
        else:
            continue
    
    return PortErrCodeCheckError
    
#P11G-5588检查FC端口误码巡检项修改 20121214 modified End
