# -*- coding: UTF-8 -*-
import common

#P11G-5630 巡检空闲热备盘策略修改 added 20130221 Begin
import re
#P11G-5630 巡检空闲热备盘策略修改 added 20130221 End

def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : check Hot Spare Disk Status
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    freeNum = 0

    #P11G-5630 巡检空闲热备盘策略修改 modified 20130221 Begin
    allDiskInfoList = ()
    diskInfoDict = {'Location':'', 'logicStatus': '', 'Physical Type':'', 'Usable Capacity':''}
    freeSpareDiskInfoList = ()
    
    cliRet = ""

    """获取Raid组信息"""
    raidGroupInfo = cli.execCmd("showrg")
    list = raidGroupInfo.splitlines()
    if len(list) < 7:
        if not common.checkCliInfoValid(raidGroupInfo, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information." 
        return (flag, raidGroupInfo, errMsg)
    #查询是否存在Raid组,如果不存在raid组，则检查通过
    if not re.search('RAID Group Information', raidGroupInfo, re.IGNORECASE):
        return (True, raidGroupInfo, "")
        
    diskLogicalInfo = cli.execCmd("showdisk -logic")
    
    cliRet = raidGroupInfo + '\n' + diskLogicalInfo
    if not common.checkCliInfoValid(diskLogicalInfo, False):
        flag = False
        if lang == "zh":
            errMsg = u"\n获取硬盘逻辑信息失败。"
        else:
            errMsg = "\nFailed to get the logic of disk." 
        return (flag, cliRet, errMsg)
    
    diskPhysicalInfo = cli.execCmd("showdisk -physic")
    
    cliRet += '\n' + diskPhysicalInfo
    if not common.checkCliInfoValid(diskPhysicalInfo, False):
        flag = False
        if lang == "zh":
            errMsg = u"\n获取硬盘物理信息失败。"
        else:
            errMsg = "\nFailed to get the physic of disk." 
        return (flag, cliRet, errMsg)

    """获取所有盘的信息列表（物理信息+逻辑信息）"""
    allDiskInfoList = getAllDiskInfoList(diskLogicalInfo, diskPhysicalInfo)
    if len(allDiskInfoList) == 0:
        return (flag, cliRet, errMsg)

    """获取所有热备盘信息列表"""
    freeSpareDiskInfoList = getFreeSpareDiskInfoList(allDiskInfoList)

    """获取所有Raid组信息"""
    RaidGroupList = getRaidGroupList(allDiskInfoList, raidGroupInfo)
    if len(RaidGroupList) == 0:
        return (flag, cliRet, errMsg)
    
    """查看热备盘是否满足当前Raid组要求"""
    iRet = checkFreeSpareSufficient(RaidGroupList, freeSpareDiskInfoList, lang)
    flag = iRet[0]
    errMsg += iRet[1]

    #P11G-5630 巡检空闲热备盘策略修改 modified 20130221 End
    return (flag, cliRet, errMsg)

#P11G-5630 巡检空闲热备盘策略修改 added 20130221 Begin
# **************************************************************************** #
# 函数名称: getRaidGroupList
# 功能说明: 获取Raid组和ThinPool列表信息
# 输入参数:  allDiskInfoList：所有盘的信息, raidGroupInfo：Raid组的cli回显信息
# 输出参数:  无
# 返回值  :  raidGroup_ListInfo：查询到的Raid组信息
# 其 他   :  无
#**************************************************************************#   
def getRaidGroupList(allDiskInfoList, raidGroupInfo):
    """showrg
    ======================================================================
                            RAID Group Information
    ----------------------------------------------------------------------
      ID    Level    Status    Free Capacity(MB)    Disk List    Name     
    ----------------------------------------------------------------------
      0     RAID0    Normal    264064               0,7;         RAID001  
      1     RAID0    Normal    245632               0,5;         RAID002  
      2     RAID1    Normal    237440               0,0;0,2;     RAID003  
      3     RAID0    Normal    1806848              0,1;         RAID004  
    ======================================================================
    
    admin:/>    
    """
    
    RaidGroupList = []
    #查询所有Raid组
    linelistRG = raidGroupInfo.splitlines()
    counter = len(linelistRG)
    if counter > 7:
        #轮训获取每一个Raid组的信息
        for raidInfo in linelistRG[6:]:
            raidGroup_Dict = {'ID': '', 'Level': '', 'Type': '', 'MinDiskCapacity':''}
            field = raidInfo.split()
            
            if len(field) < 2:
                break
            elif len(field) < 4:
                continue
            else:
                raidGroup_Dict['ID'] = field[0]
                raidGroup_Dict['Level'] = field[1]
                diskList = field[4].replace(';', ' ').split()
                
                iRet = getRGTypeAndMinCapacity(allDiskInfoList, diskList)
                raidGroup_Dict['Type'] = iRet[0]
                raidGroup_Dict['MinDiskCapacity'] = iRet[1]
                
                RaidGroupList.append(raidGroup_Dict)
    return RaidGroupList

# **************************************************************************** #
# 函数名称: getRGTypeAndMinCapacity
# 功能说明: 获取Raid组的成员盘的类型和其中的最小可用容量
# 输入参数： allDiskInfoList：所有硬盘的信息, diskList：Raid组成员盘列表
# 输出参数: NA
# 返 回 值: （diskType：Raid组成员盘类型, minDiskCapacity：构成Raid组硬盘中的最小可用容量） 
# 其 他   :  无
# **************************************************************************** # 
def getRGTypeAndMinCapacity(allDiskInfoList, diskList):

    diskType = ''
    minDiskCapacity = 0
    diskInfoDict = {'Location':'', 'logicStatus': '', 'Physical Type':'', 'Usable Capacity':''}

    """计算出Raid组的类型和最小硬盘容量:不需要关注成员盘的状态是否为Normal"""
    for diskLocation in diskList:

        for diskInfoDict in allDiskInfoList:

            if diskLocation == diskInfoDict['Location'].replace('(', '').replace(')', ''):
                #P12V-2824 热备盘巡检流程修改 modified 20130924 Begin
                if diskType == "" and diskInfoDict['Physical Type'] != "":
                    diskType = diskInfoDict['Physical Type']
                #P12V-2824 热备盘巡检流程修改 modified 20130924 End
                
                """计算容量最小值"""
                temp = int(diskInfoDict['Usable Capacity'])
                if minDiskCapacity == 0 or minDiskCapacity > temp:
                    minDiskCapacity = temp
    
    return (diskType, minDiskCapacity)          

# **************************************************************************** #
# 函数名称: getFreeSpareDiskInfoList
# 功能说明: 获取设备所有热备盘的信息
# 输入参数： allDiskInfoList：所有硬盘的信息
# 输出参数: NA
# 返 回 值: freeSpareDiskInfoList：所有热备盘列表
# 其 他   :  无
# **************************************************************************** # 
def getFreeSpareDiskInfoList(allDiskInfoList):
    freeSpareDiskInfoList = []
    diskInfoDict = {'Location':'', 'logicStatus': '', 'Physical Type':'', 'Usable Capacity':''}

    """获取热备盘信息"""
    for diskInfoDict in allDiskInfoList:
        if diskInfoDict['logicStatus'] == 'Free spare':
            freeSpareDiskInfoList.append(diskInfoDict)

    return freeSpareDiskInfoList
            
# **************************************************************************** #
# 函数名称: getDiskLogicDetailInfo
# 功能说明: 通过CLI信息取得硬盘的逻辑信息
# 输入参数： diskLogicInfo   设备逻辑硬盘信息 
# 输出参数: NA
# 返 回 值: logicLocation框号、槽位号，logicStatus逻辑状态，logicCapacity逻辑容量
# 其 他   :  无
# **************************************************************************** # 
def getDiskLogicDetailInfo(diskLogicInfo):
    
    logicLocation = ''
    logicStatus = ''
    logicCapacity = ''

    field = diskLogicInfo.split()
    
    logicLocation = field[0]

    """获取硬盘逻辑status:重构中"""
    if re.search('Reconstruction is in progress', diskLogicInfo, re.IGNORECASE):
        logicStatus = 'Reconstruction is in progress'
        
        if re.search('SmartCache Member', diskLogicInfo, re.IGNORECASE):
            logicCapacity = int(field[7])
        else:
            logicCapacity = int(field[6])
            
        return (logicLocation, logicStatus, logicCapacity)
            
    """获取硬盘逻辑status:空闲热备盘"""
    if re.search('Free spare', diskLogicInfo, re.IGNORECASE):
        logicStatus = 'Free spare'
        
        if re.search('SmartCache Member', diskLogicInfo, re.IGNORECASE):
            logicCapacity = int(field[5])
        else:
            logicCapacity = int(field[4])

        return (logicLocation, logicStatus, logicCapacity)

    """获取硬盘逻辑status:已使用热备盘"""
    if re.search('Used spare', diskLogicInfo, re.IGNORECASE):
        logicStatus = 'Used spare'
        
        if re.search('SmartCache Member', diskLogicInfo, re.IGNORECASE):
            logicCapacity = int(field[5])
        else:
            logicCapacity = int(field[4])
    
        return (logicLocation, logicStatus, logicCapacity)

    """获取硬盘逻辑status:回拷中"""
    if re.search('Copyback is in process', diskLogicInfo, re.IGNORECASE):
        logicStatus = 'Copyback is in process'
        
        if re.search('SmartCache Member', diskLogicInfo, re.IGNORECASE):
            logicCapacity = int(field[7])
        else:
            logicCapacity = int(field[6])
            
        return (logicLocation, logicStatus, logicCapacity)
     
    logicStatus = field[1]
    if re.search('SmartCache Member', diskLogicInfo, re.IGNORECASE):
        logicCapacity = field[4]
    else:
        logicCapacity = field[3]
    
    return (logicLocation, logicStatus, logicCapacity)     

# **************************************************************************** #
# 函数名称: getDiskPhysicDetailInfo
# 功能说明: 通过CLI信息取得硬盘的物理信息
# 输入参数： diskPhysicInfo   设备物理硬盘信息 
# 输出参数: NA
# 返 回 值: （logicLocation：框号、槽位号 ，physicType：物理类型） 
# 其 他   :  其中SATA与NL SAS可以互相作为热备盘，统一写成SATA
# **************************************************************************** # 
def getDiskPhysicDetailInfo(diskPhysicInfo):

    location = ''
    physicType = ''
    
    field = diskPhysicInfo.split()
    location = field[0]
    
    """获取硬盘物理类型"""
    if re.search('Off line|Single path|Write protect', diskPhysicInfo, re.IGNORECASE):  
        physicType = field[3]
    else:
        physicType = field[2]
    
    """获取硬盘物理Type:其中SATA与NL SAS可以互相作为热备盘，统一写成SATA"""
    if physicType == 'NL':
        physicType = 'SATA'
    
    return (location, physicType)
          
# **************************************************************************** #
# 函数名称: getAllDiskInfoList
# 功能说明: 获取设备所有硬盘的信息
# 输入参数： diskLogicalInfo   设备硬盘逻辑cli回显信息 
#        diskPhysicalInfo 设备硬盘物理cli回显信息
# 输出参数: NA
# 返 回 值: allDiskInfoList 所有盘信息（物理+逻辑）
# 其 他   :  无
# **************************************************************************** # 
def getAllDiskInfoList(diskLogicalInfo, diskPhysicalInfo):
    allDiskInfoList = []
    allDiskCounter = 0
    
    logicalInfoList = diskLogicalInfo.splitlines()
    
    """查询硬盘逻辑信息"""
    for logicalInfo in logicalInfoList[6:]:
        diskInfoDict = {'Location':'', 'logicStatus': '', 'Physical Type':'', 'Usable Capacity':''}
        field = logicalInfo.split()
        
        if len(field) < 4:
            break
        
        iRet = getDiskLogicDetailInfo(logicalInfo)
        location = iRet[0]
        logicStatus = iRet[1]
        logicCapacity = iRet[2]
        
        diskInfoDict['Location'] = location
        diskInfoDict['logicStatus'] = logicStatus
        diskInfoDict['Usable Capacity'] = logicCapacity
        allDiskCounter += 1
        allDiskInfoList.append(diskInfoDict)
    
    if allDiskCounter == 0:
        return allDiskInfoList 
    
    """查询硬盘物理信息"""
    physicalInfoList = diskPhysicalInfo.splitlines()

    for physicInfo in physicalInfoList[6:]:
        field = physicInfo.split()
        
        if len(field) < 4:
            break
        
        iRet = getDiskPhysicDetailInfo(physicInfo)
        location = iRet[0]
        physicalType = iRet[1]

        """搜索指定位置的盘，将硬盘类型插入到信息里"""
        for index in range(allDiskCounter):
            if location == allDiskInfoList[index]['Location']:
                allDiskInfoList[index]['Physical Type'] = physicalType
                break
            else:
                continue

    return allDiskInfoList

#P12V-2824 新增ThinPool检查 added 20130924 Begin
# **************************************************************************** #
# 函数名称: checkFreeSpareSufficient
# 功能说明: 查看热备盘是否满足所有Raid组要求
# 输入参数： raidGroup_ListInfo：Raid组列表信息, freeSpareDiskInfoList：空闲热备盘信息, lang：语言环境
# 输出参数: NA
# 返 回 值: checkPassflag：检查是否通过flag, errMsg：错误信息
# 其 他   :  无
# **************************************************************************** # 
def checkFreeSpareSufficient(RaidGroup_List, freeSpareDiskInfoList, lang):

    raidGroup_Dict = {'ID': '', 'Level': '', 'Type': '', 'MinDiskCapacity':''}
    diskInfoDict = {'Location':'', 'logicStatus': '', 'Physical Type':'', 'Usable Capacity':''}

    checkSpartFailDictList = []
    checkPassflag = False
    flag = True
    errMsg = ''
    
    """轮训查询所有Raid组"""
    for raidGroup_Dict in RaidGroup_List:
        
        #初始化信息
        checkPassflag = False
        
        raidGroup_ID = raidGroup_Dict['ID']
        raidGroup_Level = raidGroup_Dict['Level']
        raidGroup_Type = raidGroup_Dict['Type']
        raidGroup_MinCapacity = raidGroup_Dict['MinDiskCapacity']

        """Raid0级别的Raid组不需要热备盘,检查通过"""
        if raidGroup_Level == "RAID0":
            continue

        """非Raid0的Raid组：如果空闲热备盘个数为零，设定检查不通过"""
        if len(freeSpareDiskInfoList) == 0:
            checkSpartFailDictList.append(raidGroup_Dict)
            continue               
        
        """依次查询热备盘是否满足指定Raid组的要求"""
        for diskInfoDict in freeSpareDiskInfoList:
            
            diskTypeFlag = False
            freeSpare_Type = diskInfoDict['Physical Type']
            freeSpare_Capacity = diskInfoDict['Usable Capacity']
            
            """类型相同并且空闲热备盘容量要大于等于Raid组最小硬盘容量"""
            if freeSpare_Type == raidGroup_Type and freeSpare_Capacity >= raidGroup_MinCapacity:
                checkPassflag = True
            else:
                pass
        
        #查看当前Raid组或者ThinPool是否检查通过
        if not checkPassflag:
            checkSpartFailDictList.append(raidGroup_Dict)

    #判断是否检查成功
    if len(checkSpartFailDictList) == 0:
        flag = True
        return (flag, "")

    """设定失败返回信息"""
    for tempInfoDict in checkSpartFailDictList:
            flag = False
            raidGroupId = tempInfoDict['ID']
            raidGroupLevel = tempInfoDict['Level']
            raidGroupType = tempInfoDict['Type']
            
            """NL SAS和SATA盘做热备盘时可通用"""
            if raidGroupType == "SATA":
                raidGroupType = "NL SAS/SATA"
                
            raidGroupCapacity = tempInfoDict['MinDiskCapacity']
            
            if "zh" == lang:
                errMsg += u"\nRAID组（RAID组ID：" + raidGroupId + u"，RAID组级别：" + raidGroupLevel +  u"）缺少热备盘：硬盘物理类型为" \
                        + raidGroupType + u"，硬盘容量至少为" + str(raidGroupCapacity) + u"GB。"
            else:
                errMsg += "\nRaid Group (raid-group-id:" + raidGroupId + ", raid-group-level:" + raidGroupLevel +") is lack of hot spare disk: the physic type is " \
                        + str(raidGroupType) + ", the space must be at least " + str(raidGroupCapacity) + "GB."

    return (flag, errMsg)
#P11G-5630 巡检空闲热备盘策略修改 added 20130221 End
