# -*- coding: UTF-8 -*-
import common
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""

    cliRet = cli.execCmd("showlun")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."           
        return (flag, cliRet, errMsg)

    for field in list[6:]:
            list2 = field.split()
            if len(list2) < 4:
                continue
            if list2[2] not in ("Normal", "Formatting"):
                flag = False
                if "zh" == lang:
                    errMsg += u"\nRAID组（RAID组ID：" + list2[1] + u"）的LUN（LUN ID：" + list2[0] + u"）的状态存在异常。"
                else:
                    errMsg += "\nThe status of LUN (lun-id:" + list2[0] + ") of RAID group (raid-group-id:" + list2[1]\
                              + ") is abnormal."

    return (flag, cliRet, errMsg)