# -*- coding: UTF-8 -*-
"""P11G-5580 检查远程复制状态巡检项修改 20121204 modified Begin"""
import string
import re
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 远程复制信息检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    showrmtrep
    =================================================================================================
                                     Remote Replication Information
    -------------------------------------------------------------------------------------------------
      Name                    ID                  Mode            Is CG Member    Status    Role     
    -------------------------------------------------------------------------------------------------
      RemoteReplication001    0022A10B6C5C0000    Asynchronous    No              Normal    Primary  
    =================================================================================================
    """"""
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    healthstatustemp = ""
    
    cliRet = cli.execCmd("showrmtrep")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."          
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 5:
            continue
        
        #查询远程复制的运行状态
        if "Normal" != list2[4]:
            flag = False
            if "zh" == lang:
                errMsg += u"\n远程复制（远程复制ID：" + list2[1] + u"）状态存在异常（" + list2[4] + u"）。"
            else:
                errMsg += "\nThe status of remote replication (remote-replication-id:" + list2[1]\
                          + ") is abnormal(" + list2[4] + ")."
            continue

        #查询远程复制的详细状态信息
        rmtrepId = list2[1]
        iRet = checkRemoteReplication(cli, rmtrepId, lang)
        #取得回显信息和健康状态
        cliRet += '\n\n' + iRet[1]
        healthstatustemp = iRet[2]
        #设置错误显示信息
        if False == iRet[0]:
            flag = False
            if "zh" == lang:
                errMsg += u"\n远程复制（远程复制ID：" + list2[1] + u"）的健康状态存在异常（" + healthstatustemp + u"）。"
            else:
                errMsg += "\nThe health status of remote replication (remote-replication-id:" + list2[1]\
                          + ") is abnormal(" + healthstatustemp + ")."
    return (flag, cliRet, errMsg)


# **************************************************************************** #
# 函数名称: checkRemoteReplication
# 功能说明: 查询指定远程复制的健康状态
# 输出参数: 无
# **************************************************************************** # 
def checkRemoteReplication(cli, rmtrepId, lang):
    
    """cli命令回显信息
    >showrmtrepmember -rep 0022A10B6C5C0000
    ===================================================================================
                              Remote Replication Information
    -----------------------------------------------------------------------------------
      ID                  LUN ID    Array SN                Relation    Health Status  
    -----------------------------------------------------------------------------------
      0022A10B6C5C0000    2         210235G6T8Z0C4000006    Primary     Normal         
      0022A10B6C5C0000    3         210235G6T8Z0C4000007    Secondary     Normal         
    ==================================================================================="""
    #信息初始化
    flag = True
    LunID = ""
    ArraySN = ""
    healthstatus = ''
    errMsg = ""
    cliRet = ""
    
    checkCmd = "showrmtrepmember -rep " + str(rmtrepId)
    cliRet = cli.execCmd(checkCmd)
    list = string.split(cliRet, '\n')
    
    """判断cli回显信息是否满足要求"""
    count = len(list)
    if count < 7:
        if not common.checkCliInfoValid(cliRet, True):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效（命令：" + checkCmd + u"）。"
            else:
                errMsg = "\nInvalid Cli information (Command:" + checkCmd + ")."
        return(flag, cliRet, errMsg)

    """查询所有的Lun"""
    for line in list[6:]:
        
        field = line.split()
        if len(field) < 5:
            continue

        LunID = field[1]
        ArraySN = field[2]
        Relation = field[3]
        healthstatus = field[4]
        
        """查询远程复制的健康状态"""
        if "Normal" != healthstatus:
            flag = False
            if "zh" == lang:
                errMsg += u"\n远程复制（远程复制ID：" + rmtrepId + u"，阵列SN：" + ArraySN + u"，LUN Id：" + LunID + u"）的健康状态存在异常（" + healthstatus + u"）。"
            else:
                errMsg += "\nThe health status of remote replication (remote-replication-id:" + rmtrepId + ", array-sn:" + ArraySN+ ", lun-id:" + LunID\
                          + ") is abnormal(" + healthstatus + ")."
            continue
    return(flag, cliRet, healthstatus)

"""P11G-5580 检查远程复制状态巡检项修改 20121204 modified End"""
