# -*- coding: UTF-8 -*-

import re

normalInfo = "command operates successfully|license|not exist|not support"

# **************************************************************************** #
# 函数名称: checkCliInfoValid
# 功能说明: 查询当前获取的Cli信息是否有效
# 输入参数: cliInfo：命令回文信息（String）
#                   necessaryData：系统中必须包含的配置为True（如控制器、框等）（boolean）
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def checkCliInfoValid(cliInfo, necessaryData):
    
    #异常模式
    if re.search("-bash", cliInfo, re.IGNORECASE):
        return False
    
    #命令回文大于5行，说明必然有数据，检查通过
    lineList = cliInfo.splitlines()
    if len(lineList) >= 5:
        return True

    #系统中必须包含的配置（如控制器、框等）
    if necessaryData:
        return False

    #非必需配置项，按照如下标准检查
    flag = False
    if re.search(normalInfo, cliInfo, re.IGNORECASE):
        flag = True
    else:
        flag = False
        
    return flag