#!/bin/sh

CMD_FILE=./cmd_tmp_file

R8C20=803000
PRINT_HEAD=20
PRINT_LINE=17

PrintNotInstallUp()
{
    isPass=3
    errResult="UltraPath is not installed on this host, skip this item."

    WRITE_XML_ERROR 0 "${errResult}"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 1;
}

PrintNotVailedUpadm()
{
    isPass=1
    errResult="UltraPath has been installed on this host, but upadm is not effective,please excute \"/etc/init.d/hostd restart\" to make upadm effect."

    WRITE_XML_ERROR 0 "${errResult}"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 1;
}

HOST_00_ChkUltraPathExist()
{
    errResult=""
    isPass=0

    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        isPass=3
        WRITE_XML_ERROR 0 "UltraPath is not installed on this host, skip this item."
    else
        WRITE_XML_COMMON 0 "UltraPath has been installed on this host."
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

HOST_01_ChkUltraPathVersion()
{
    errResult=""
    isPass=0

    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
  
    if [ ${Esxcli_Flag}  -eq 1 ]; then
        PrintNotVailedUpadm
        return 1;
    fi  
  
    esxcli upadm show version > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        UltraPath_VERSION=`echo "#esxcli upadm show version";esxcli upadm show version`
        WRITE_XML_COMMON 0 ":${UltraPath_VERSION}"
    else
        isPass=3
        UltraPath_VERSION=`echo "#esxcli upadm show version";esxcli upadm show version`
        WRITE_XML_ERROR 0 ":${UltraPath_VERSION}"		
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

HOST_02_ChkUpServer()
{
    errResult=""
    isPass=0

    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi

    /etc/init.d/sfcbd-watchdog status | grep not > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        isPass=1
        WRITE_XML_ERROR 0 "The status of sfcbd is abnormal."
        sfcbdRst=`echo "#/etc/init.d/sfcbd-watchdog status";/etc/init.d/sfcbd-watchdog status`
        WRITE_XML_ERROR 0 ":${sfcbdRst}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi

    sfcbdRst=`echo "#/etc/init.d/sfcbd-watchdog status";/etc/init.d/sfcbd-watchdog status`
    WRITE_XML_COMMON 0 ":${sfcbdRst}"

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

HOST_03_ChkUpFiles()
{
    errResult=""
    isPass=0

    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi

    if [ ! -f /opt/UltraPath/bin/upadm ]; then
        isPass=1
        errResult="Not found file:/opt/UltraPath/bin/upadm."
        WRITE_XML_ERROR 0 ":${errResult}"
    fi

    if [ ! -f /usr/lib/vmware/esxcli/ext/esxcli-ultrapath.xml ]; then
        isPass=1
        errResult="Not found file:/usr/lib/vmware/esxcli/ext/esxcli-ultrapath.xml."
        WRITE_XML_ERROR 0 ":${errResult}"
    fi

    if [ ! -f /usr/lib/vmware/vmkmod/mp-plugin-ultrapath ]; then
        isPass=1
        errResult="Not found file:/usr/lib/vmware/vmkmod/mp-plugin-ultrapath."
        WRITE_XML_ERROR 0 ":${errResult}"
    fi

    if [ ! -f /usr/libexec/jumpstart/plugins/psa-mp-plugin-ultrapath-rules.json ]; then
        isPass=1
        errResult="Not found file:/usr/libexec/jumpstart/plugins/psa-mp-plugin-ultrapath-rules.json."
        WRITE_XML_ERROR 0 ":${errResult}"
    fi

    if [ ! -f /usr/libexec/jumpstart/plugins/psa-mp-plugin-ultrapath.json ]; then
        isPass=1
        errResult="Not found file:/usr/libexec/jumpstart/plugins/psa-mp-plugin-ultrapath.json."
        WRITE_XML_ERROR 0 ":${errResult}"
    fi

    if [ ! -f /etc/cim/config/user_cfg.xml ]; then
        isPass=1
        errResult="Not found file:/etc/cim/config/user_cfg.xml."
        WRITE_XML_ERROR 0 ":${errResult}"
    fi

    if [ ! -f /etc/cim/log/serial_oper ]; then
        isPass=1
        errResult="Not found file:/etc/cim/log/serial_oper."
        WRITE_XML_ERROR 0 ":${errResult}"
    fi

    if [ ! -f /etc/cim/openwsman/provider.conf ]; then
        isPass=1
        errResult="Not found file:/etc/cim/openwsman/provider.conf."
        WRITE_XML_ERROR 0 ":${errResult}"
    fi

    if [ ! -f /usr/lib/cim/libultrapathprovider.so ]; then
        isPass=1
        errResult="Not found file:/usr/lib/cim/libultrapathprovider.so."
        WRITE_XML_ERROR 0 ":${errResult}"
    fi

    if [ ! -f /var/lib/sfcb/registration/vmw_ultrapath-provider-providerRegister ]; then
        isPass=1
        errResult="Not found file:/var/lib/sfcb/registration/vmw_ultrapath-provider-providerRegister."
        WRITE_XML_ERROR 0 ":${errResult}"
    fi

    upVersion=`esxcli upadm show version|grep "Software Version"|awk -F ":" '{print $2}'`
    upVersion=$(echo ${upVersion})

    VMWARE_VERSION=`uname -r`
    VERSION_NUM=`echo ${VMWARE_VERSION} |awk -F"." '{print $1}'`
    if [ ${VERSION_NUM} -eq 6 ]; then
        providerdirinfo=ultrapath-provider-${upVersion}-00
    else
        providerdirinfo=ultrapath-provider-0.0
    fi

    if [ ! -f /var/lib/sfcb/registration/repository/${providerdirinfo}/ultrapath/cimv2/classSchemas ]; then
        isPass=1
        errResult="Not found file:/var/lib/sfcb/registration/repository/${providerdirinfo}/ultrapath/cimv2/classSchemas."
        WRITE_XML_ERROR 0 ":${errResult}"
    fi

    if [ ! -f /var/lib/sfcb/registration/repository/${providerdirinfo}/ultrapath/cimv2/qualifiers ]; then
        isPass=1
        errResult="Not found file:/var/lib/sfcb/registration/repository/${providerdirinfo}/ultrapath/cimv2/qualifiers."
        WRITE_XML_ERROR 0 ":${errResult}"
    fi

    if [ ! -f /var/lib/sfcb/registration/repository/${providerdirinfo}/ultrapath/cimv2/qualifiers.idx ]; then
        isPass=1
        errResult="Not found file:/var/lib/sfcb/registration/repository/${providerdirinfo}/ultrapath/cimv2/qualifiers.idx."
        WRITE_XML_ERROR 0 ":${errResult}"
    fi

    if [ ${isPass} -eq 0 ]; then
        WRITE_XML_COMMON 0 "The UltraPath files are normal."
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

HOST_04_ChkUpConfig()
{
    errResult=""
    isPass=3

    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi

    WRITE_XML_COMMON 0 "There is no config file to be checked."

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

HOST_05_ChkUpLogSpace()
{
    errResult=""
    isPass=3

    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi

    WRITE_XML_COMMON 0 "The logs of UltraPath are saved in the system logs."

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

DISK_CHK_STR="KB|MB|GB|TB"

HOST_06_ChkUpDiskStatus()
{
    errResult=""
    isPass=0
    AppendStr=""

    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
  
    if [ ${Esxcli_Flag}  -eq 1 ]; then
        PrintNotVailedUpadm
        return 1;
    fi
	
    esxcli upadm show version > /dev/null 2>&1
    if [ $? -ne 0 ]; then
        isPass=3
        errResult=`echo "#esxcli upadm show version";esxcli upadm show version`
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;
    fi

    UP_VER=`esxcli upadm show version |grep "Software Version"|awk -F":" '{print $2}' | awk -F"." '{print $1 $2}'`
    VERSION_INFO=`echo "#esxcli upadm show version";esxcli upadm show version`
    WRITE_XML_COMMON 0 ":${VERSION_INFO}"
	
    if [ ${UP_VER} -ge 803 ]; then
        AppendStr=" -t all"
    fi

    esxcli upadm show vlun ${AppendStr}|grep -E -i ${DISK_CHK_STR} > ${CMD_FILE}
    CHK_FLAG=`cat ${CMD_FILE}|wc -l`
    if [ ${CHK_FLAG} -eq 0 ]; then
        isPass=3
        errResult="Can't find any vluns in UltraPath."
        WRITE_XML_ERROR 0 ":${errResult}"
        VLUN_INFO=`echo "#esxcli upadm show vlun ${AppendStr}";esxcli upadm show vlun ${AppendStr}`
        WRITE_XML_ERROR 0 ":${VLUN_INFO}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;
    fi

    abnormal=`cat ${CMD_FILE}|grep -E -i "fault|degraded"|wc -l`

    if [ ${abnormal} -ne 0 ]; then
        isPass=1
        errResult="The status of some LUNs managed by UltraPath is abnormal."
        WRITE_XML_ERROR 0 ":${errResult}"
        DISK_INFO=`echo "#esxcli upadm show vlun ${AppendStr}";esxcli upadm show vlun ${AppendStr} | head -n ${PRINT_HEAD}`
        if [ ${CHK_FLAG} -gt ${PRINT_LINE} ]; then
            DISK_INFO=`echo -e " ${DISK_INFO} \n .................................."`
        fi
        WRITE_XML_ERROR 0 ":${DISK_INFO}"
    else
        DISK_INFO=`echo "#esxcli upadm show vlun ${AppendStr}";esxcli upadm show vlun ${AppendStr}|head -n ${PRINT_HEAD}`
        if [ ${CHK_FLAG} -gt ${PRINT_LINE} ]; then
            DISK_INFO=`echo -e " ${DISK_INFO} \n .................................."`
        fi
        WRITE_XML_COMMON 0 ":${DISK_INFO}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}


HOST_07_ChkUpPathStatus()
{
    errResult=""
    isPass=0

    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
  
    if [ ${Esxcli_Flag}  -eq 1 ]; then
        PrintNotVailedUpadm
        return 1;
    fi
	
    esxcli upadm show path > /dev/null 2>&1
    if [ $? -ne 0 ]; then
        isPass=3
        errResult=`echo "#esxcli upadm show path";esxcli upadm show path`
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;
    fi

    esxcli upadm show path  | grep -E "^[[:blank:]]*[[:digit:]]" > ${CMD_FILE}

    CHK_FLAG=`cat ${CMD_FILE}|wc -l`
    if [ ${CHK_FLAG} -eq 0 ]; then
        isPass=3
        errResult="Can't find any paths in UltraPath."
        WRITE_XML_ERROR 0 ":${errResult}"
        PATH_INFO=`echo "#esxcli upadm show path";esxcli upadm show path`
        WRITE_XML_ERROR 0 ":${PATH_INFO}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;
    fi

    PATH_CHK=`cat ${CMD_FILE}|grep -E -i "fault|degradation"|wc -l`

    if [ ${PATH_CHK} -ne 0 ]; then
        errResult="Some paths status abnormal."
        WRITE_XML_ERROR 0 ":${errResult}"
        PATH_INFO=`echo "#esxcli upadm show path";esxcli upadm show path | head -n ${PRINT_HEAD}`
        if [ ${CHK_FLAG} -gt ${PRINT_LINE} ]; then
            PATH_INFO=`echo -e " ${PATH_INFO} \n .................................."`
        fi
        WRITE_XML_ERROR 0 ":${PATH_INFO}"
        isPass=1
    else
        PATH_INFO=`echo "#esxcli upadm show path";esxcli upadm show path | head -n ${PRINT_HEAD}`
        if [ ${CHK_FLAG} -gt ${PRINT_LINE} ]; then
            PATH_INFO=`echo -e " ${PATH_INFO} \n .................................."`
        fi
        WRITE_XML_COMMON 0 ":${PATH_INFO}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

HOST_08_ChkUpRedundancyController()
{
    errResult=""
    isPass=-1

    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag} -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
  
    if [ ${Esxcli_Flag}  -eq 1 ]; then
        PrintNotVailedUpadm
        return 1;
    fi 

    esxcli upadm show diskarray > /dev/null 2>&1
    if [ $? -ne 0 ]; then
        isPass=3
        errResult=`echo "#esxcli upadm show diskarray";esxcli upadm show diskarray`
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;
    fi

    esxcli upadm show diskarray | grep -E '^[[:blank:]]*[[:digit:]]'  > ${CMD_FILE}
  
    CHK_FLAG=`cat ${CMD_FILE}|wc -l`
    if [ ${CHK_FLAG} -eq 0 ]; then
        isPass=3
        errResult="Can't find any storage device in UltraPath."
        WRITE_XML_ERROR 0 ":${errResult}"
        arrayResult=`echo "#esxcli upadm show diskarray"; esxcli upadm show diskarray`
        WRITE_XML_ERROR 0 ":${arrayResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;
    fi
	
    arrayResult=`echo "#esxcli upadm show diskarray"; esxcli upadm show diskarray`
    WRITE_XML_COMMON 0 ":${arrayResult}"

    ARRAY_ID=`cat ${CMD_FILE}| grep -E '^[[:blank:]]*[[:digit:]]' | awk '{print $1}'`
    for i in ${ARRAY_ID}
    do
        CHK_FLAG=`esxcli upadm show path -a ${i} | wc -l`
        PATH_INFO=`echo "#esxcli upadm show path -a ${i}";esxcli upadm show path -a ${i} | head -n ${PRINT_HEAD}`		
        if [ ${CHK_FLAG} -gt ${PRINT_LINE} ]; then
            PATH_INFO=`echo -e " ${PATH_INFO} \n .................................."`
        fi		
        WRITE_XML_COMMON 0 ":${PATH_INFO}"
		
        CtlCount=`esxcli upadm show path -a ${i} | grep -i -E "normal|degradation" | awk -F " " '{print $4}' | sort | uniq | wc -l`
        if [ ${CtlCount} -eq 0 ]; then
            if [ ${isPass} -ne 0 ]; then
                isPass=3
            fi
        elif [ ${CtlCount} -eq 1 ]; then
            isPass=1
            errResult="Some storage devices managed by UltraPath only connect single controller."
            WRITE_XML_ERROR 0 ":${errResult}"
            break
        else
            isPass=0
        fi
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

HOST_09_ChkThirdMP()
{
    errResult=""
    isPass=0

    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi

    esxcli software vib list |grep vxdmpmpp > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        isPass=1
        WRITE_XML_ERROR 0 "Symantec dmp installed."
    fi

    esxcli software vib list |grep powerpath > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        isPass=1
        WRITE_XML_ERROR 0 "EMC powerpath installed."
    fi

    WRITE_XML_COMMON 0 "There is no third multi-path on this host."

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

HOST_10_ChkOsVersion()
{
    errResult=""
    isPass=0

    OS_VER=`uname -r`

    WRITE_XML_SUBCMD_HEADER $1

    WRITE_XML_COMMON 0 "The OS version is ${OS_VER}. "

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

HOST_11_ChkHcSingleDisk()
{
    errResult=""
    isPass=0

    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
  
    if [ ${Esxcli_Flag}  -eq 1 ]; then
        PrintNotVailedUpadm
        return 1;
    fi
	
    esxcli upadm show version | grep "Software" > ${CMD_FILE}
    CHK_FLAG=`cat ${CMD_FILE}|wc -l`
    if [ ${CHK_FLAG} -eq 0 ]; then
        isPass=3
        errResult=`echo "#esxcli upadm show version";esxcli upadm show version`
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;
    fi
	
    upVersion=`cat ${CMD_FILE} |awk -F ":" '{print $2}' | awk -F "." '{print $1$2$3}'`
    upVersion=$(echo ${upVersion})
    
    if [ "${upVersion}" -lt "${R8C20}" ]; then
        isPass=3
        errResult="The UltraPath version is less then v1r8c20,it cannot support hypermetro."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi	

    esxcli upadm show vlun -t hypermetro |grep -E -i ${DISK_CHK_STR} 2> /dev/null > ${CMD_FILE}

    CHK_FLAG=`cat ${CMD_FILE}|wc -l`
    if [ ${CHK_FLAG} -eq 0 ]; then
        isPass=3
        errResult="Not found hypermetro disk in UltraPath."
        WRITE_XML_ERROR 0 ":${errResult}"
        VLUN_INFO=`echo "#esxcli upadm show vlun -t hypermetro";esxcli upadm show vlun -t hypermetro`
        WRITE_XML_ERROR 0 ":${VLUN_INFO}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;
    fi
	
    VLUN_INFO=`echo "#esxcli upadm show vlun -t hypermetro";esxcli upadm show vlun -t hypermetro|head -n ${PRINT_HEAD}`
    if [ ${CHK_FLAG} -gt ${PRINT_LINE} ]; then
        VLUN_INFO=`echo -e " ${VLUN_INFO} \n .................................."`
    fi
    WRITE_XML_COMMON 0 ":${VLUN_INFO}"

    VLUN_ID=`cat ${CMD_FILE}|awk '{print $1}'|sort|uniq`

    for i in ${VLUN_ID}
    do
        esxcli upadm show vlun -l ${i} -t hypermetro > ${CMD_FILE}
        VLUN_INFO=`echo "#esxcli upadm show vlun -l ${i} -t hypermetro";esxcli upadm show vlun -l ${i} -t hypermetro`
        WRITE_XML_COMMON 0 ":${VLUN_INFO}"
        LUN_WWN_NUM=`cat ${CMD_FILE}|grep "LUN WWN"|wc -l`
        if [ ${LUN_WWN_NUM} -ne 2 ]; then
            isPass=1
            errResult="vlun_id:${i} only one storage system reports the LUN in a HyperMetro pair."
            WRITE_XML_ERROR 0 ":${errResult}"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0;
        fi
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

HOST_UltraPathChkItem()
{
    WRITE_XML_CMD_HEADER $1

    case $1 in
      100)
        HOST_00_ChkUltraPathExist "0"
        ;;
      101)
        HOST_01_ChkUltraPathVersion "0"
        ;;
      102)
       HOST_02_ChkUpServer "0"
        ;;
      103)
        HOST_03_ChkUpFiles "0"
        ;;
      104)
        HOST_04_ChkUpConfig "0"
        ;;
      105)
        HOST_05_ChkUpLogSpace "0"
        ;;
      106)
        HOST_06_ChkUpDiskStatus "0"
        ;;
      107)
        HOST_07_ChkUpPathStatus "0"
        ;;
      108)
        HOST_08_ChkUpRedundancyController "0"
        ;;
      109)
        HOST_09_ChkThirdMP "0"
        ;;
      110)
        HOST_10_ChkOsVersion "0"
        ;;
      111)
        HOST_11_ChkHcSingleDisk "0"
        ;;
      *)
        echo "No this type"
        ;;
      esac

    WRITE_XML_CMD_TAIL
}