#!/bin/bash

PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools:${PATH}"

SFTP_DOWNLOAD_TOOL="/opt/omm/oma/workspace/script/sftp_download_batch.exp"
LFTP_DOWNLOAD_TOOL="/opt/omm/oma/workspace/script/lftp_download_batch.exp"

LOG_FILE="/var/log/dsware/fusionstorage_inspect.log"
LOG_LEVEL="ERROR"
 
LOG_LEVEL_MUST="MUST"
LOG_LEVEL_ERROR="ERROR"
LOG_LEVEL_WARN="WARN"
LOG_LEVEL_INFO="INFO"
LOG_LEVEL_DEBUG="DEBUG"

file_name="$(basename $0)"

NET_WORK_TYPE_FILE="/opt/omm/oma/workspace/conf/upda.cfg"
IP_TYPE=""

function log()
{
    local log_level="$1"
    shift
    local log_msg="$@"
    local str_log="[$(date +'%Z %Y-%m-%d %H:%M:%S')][${file_name}][${FUNCNAME[1]}][${BASH_LINENO[0]}][${log_level}] ${log_msg}"
    echo "${str_log}"
    echo "${str_log}" >> ${LOG_FILE}
    
    return 0
}

function checkLogSize()
{
    #fusionstorage_inspect.log ־20M
    local STANDARD=$((20*1024))
    if [[ -f "${LOG_FILE}" ]]
    then
        log_size=$(du -sk "${LOG_FILE}"| awk '{print $1}')
        if [[ "${log_size}" -gt "${STANDARD}" ]]
        then
            > ${LOG_FILE}
        fi
    fi
}

function getCurPath()
{
    cd $(dirname $0)
    g_curPath="$PWD"
    g_myWorkPath="${g_curPath}/.."
    g_scriptName="$(basename $0)"
    cd - >/dev/null
}

function get_os_type_for_Agent()
{
    # oel rhel suse uvp centos euleros
    agent_os_type=""
    local kernel="$(uname -r)"
    if [ -n "$(echo "${kernel}" | grep "xen")" -a -f "/etc/uvp_version" ]
    then
        agent_os_type="uvp"
    elif [ "${kernel}" == "3.0.93-0.8-default" ]
    then
        agent_os_type="uvp"
    elif [ -n "$(echo "${kernel}" | grep "el" | grep "uek")" ]
    then
        agent_os_type="oel"
    elif [ -n "$(echo "${kernel}" | grep "el")" ]
    then
        if [ -n "$(cat /proc/version 2>/dev/null | grep -i centos)" ]
        then
            agent_os_type="centos"
        else
            agent_os_type="rhel"
        fi
    else
        if [ -n "$(cat /proc/version 2>/dev/null | grep -i euleros)" ] || [ -f "/etc/EulerLinux.conf" ] || [ -f "/etc/euleros-release" ]
        then
            agent_os_type="euleros"
        else
            agent_os_type="suse"
        fi
    fi
    #armֻEuler
    if [ "${agent_os_flatform}" == "aarch64" ]
    then
        agent_os_type="euleros"
    fi
}

function get_os_flatform()
{
    local hardware_arch="`uname -m`"
    agent_os_flatform=""
    if [ $hardware_arch == "aarch64" ]
    then
        agent_os_flatform="aarch64"
    else
        agent_os_flatform="x86_64"
    fi
    return 0
}

# 1. ׼ȫֱڵͣOS
function prepare()
{
    if [ -f "/opt/dsware/DSwareAgentNodeVersion" ]
    then
        IS_AGENT_NODE="Y"
        get_os_flatform
        get_os_type_for_Agent
    fi
    if [ -f "/opt/dsware/DSwareManagerNodeVersion" ]
    then
        IS_MANAGE_NODE="Y"
    fi

    return 0
}

# 2. ļԭӽűĿĿ¼Ȩ
function copy_upgrade_files()
{
    find ${downloadPath} -type f -name "*.sign" -exec rm -f {} \;
    find ${downloadPath} -type f |xargs dos2unix 1>/dev/null 2>&1

    if [[ ! -d /opt/omm/oma/flow/ ]]
    then
        log INFO "mkdir /opt/omm/oma/flow/"
        mkdir -p /opt/omm/oma/flow/
    fi

    if [[ ! -d /opt/omm/oma/flow/default/ ]]
    then
        log INFO "mkdir /opt/omm/oma/flow/default/"
        mkdir -p /opt/omm/oma/flow/default/
    fi

    if [[ -f /opt/omm/oma/flow/default/upd_atoms.lua && ! -f /opt/omm/oma/flow/default/upd_atoms.lua.bak ]]
    then
        log INFO "Backup atoms default file: /opt/omm/oma/flow/default/upd_atoms.lua"
        cp -a /opt/omm/oma/flow/default/upd_atoms.lua /opt/omm/oma/flow/default/upd_atoms.lua.bak 1>/dev/null 2>&1
    fi

    if [[ -f /opt/omm/oma/flow/upd_atoms.lua && ! -f /opt/omm/oma/flow/upd_atoms.lua.bak ]]
    then
        log INFO "Backup atoms file: /opt/omm/oma/flow/upd_atoms.lua"
        cp -a /opt/omm/oma/flow/upd_atoms.lua /opt/omm/oma/flow/upd_atoms.lua.bak 1>/dev/null 2>&1
    fi
    #滻ܵluaű
    cp -ar ${downloadPath}/update/omm/oma/flow/comm /opt/omm/oma/flow/ 1>/dev/null 2>&1 || { log ERROR "copy /opt/omm/oma/flow/comm/* failed."; return 1; }
    cp -ar ${downloadPath}/update/omm/oma/flow/upd_atoms.lua /opt/omm/oma/flow/ 1>/dev/null 2>&1 || { log ERROR "copy /opt/omm/oma/flow/upd_atoms.lua failed."; return 1; }
    cp -ar ${downloadPath}/update/flow/A/upd_atoms.lua /opt/omm/oma/flow/default/ 1>/dev/null 2>&1 || { log ERROR "copy /opt/omm/oma/flow/default/upd_atoms.lua failed."; return 1; }

    # ű
    rm -rf /opt/omm/oma/atoms/Inspect/
    mkdir -p /opt/omm/oma/atoms/Inspect/
    cp -ar ${downloadPath}/update/atoms/Inspect/* /opt/omm/oma/atoms/Inspect/ 1>/dev/null 2>&1 || { log ERROR "copy /opt/omm/oma/atoms/Inspect/* failed."; return 1; }

    cp ${downloadPath}/package.cfg /opt/omm/oma/atoms/Inspect/ || { log ERROR "copy /opt/omm/oma/atoms/Inspect/package.cfg  failed."; return 1; }

    if [ "${IS_MANAGE_NODE}" == "Y" ]
    then
        if [[ ! -d /opt/omm/oms/flow/ ]]
        then
            log INFO "mkdir /opt/omm/oms/flow/"
            mkdir -p /opt/omm/oms/flow/
        fi

        if [[ ! -d /opt/omm/oms/flow/default/ ]]
        then
            log INFO "mkdir /opt/omm/oms/flow/default/"
            mkdir -p /opt/omm/oms/flow/default/
        fi

        if [[ -f /opt/omm/oms/flow/default/upd_flows.lua && ! -f /opt/omm/oms/flow/default/upd_flows.lua.bak ]]
        then
            log INFO "Backup flows default file: /opt/omm/oms/flow/default/upd_flows.lua"
            cp -a /opt/omm/oms/flow/default/upd_flows.lua /opt/omm/oms/flow/default/upd_flows.lua.bak 1>/dev/null 2>&1
        fi

        if [[ -f /opt/omm/oms/flow/upd_flows.lua && ! -f /opt/omm/oms/flow/upd_flows.lua.bak ]]
        then
            log INFO "Backup flows file: /opt/omm/oms/flow/upd_flows.lua"
            cp -a /opt/omm/oms/flow/upd_flows.lua  /opt/omm/oms/flow/upd_flows.lua.bak 1>/dev/null 2>&1
        fi

        #滻ܵluaű
        rm -rf /opt/omm/oms/flow/comm
        mkdir -p /opt/omm/oms/flow/comm
        cp -ar ${downloadPath}/update/omm/oms/flow/comm/* /opt/omm/oms/flow/comm 1>/dev/null 2>&1

        cp -ar ${downloadPath}/update/omm/oms/flow/upd_flows.lua /opt/omm/oms/flow/upd_flows.lua 1>/dev/null 2>&1 || { log ERROR "copy /opt/omm/oms/flow/upd_flows.lua failed."; return 1; }
        cp -ar ${downloadPath}/update/flow/S/upd_flows.lua /opt/omm/oms/flow/default/ 1>/dev/null 2>&1 || { log ERROR "copy /opt/omm/oms/flow/default/upd_flows.lua failed."; return 1; }
    fi
    
    # ͳһļԭӽűȨ
    if [ "${IS_MANAGE_NODE}" == "Y" ]
    then
        chown -Rh omm:omm /opt/omm/oms/flow
        find /opt/omm/oms/flow -type d -exec chmod 700 {} \;
        find /opt/omm/oms/flow -type f -exec chmod 600 {} \;
        find /opt/omm/oms/flow -type f -name "*.sh" -exec chmod 500 {} \;
        chmod 400 /opt/omm/oms/flow/default/upd_flows.lua
        chmod 750 /opt/omm/oms/flow
        chmod 750 /opt/omm/oms/flow/common
        chown -Rh omm:omm /opt/omm/oma/atoms
        fsync /opt/omm/oms/flow/
    else
        chown -Rh root:root /opt/omm/oma/atoms
    fi
    chown -Rh root:root /opt/omm/oma/flow
    find /opt/omm/oma/flow -type d -exec chmod 700 {} \;
    find /opt/omm/oma/flow -type f -exec chmod 600 {} \;
    find /opt/omm/oma/flow -type f -name "*.sh" -exec chmod 500 {} \;
    chmod 400 /opt/omm/oma/flow/default/upd_atoms.lua
    find /opt/omm/oma/atoms -type d -exec chmod 700 {} \;
    find /opt/omm/oma/atoms -type f -exec chmod 600 {} \;
    find /opt/omm/oma/atoms -type f -name "*.sh" -exec chmod 500 {} \;
    find /opt/omm/oma/atoms -type f -name "*_tool*" -exec chmod 500 {} \;

    fsync /opt/omm/oma/flow/
    fsync /opt/omm/oma/atoms/
    
    find "${g_myWorkPath}/" -type d -exec chmod 700 {} \;
    find "${g_myWorkPath}/" -type f -exec chmod 600 {} \;
    find "${g_myWorkPath}/" -type f -name "*.sh" -exec chmod 500 {} \;

    if [[ "${IS_AGENT_NODE}" == "Y" ]]
    then
        collect_match_file="/opt/dsware/agent/tool/pmi/infoCollect/Collect_match.sh"
        collect_match_file_bak="/opt/dsware/agent/tool/pmi/infoCollect/Collect_match.sh.bak"

    if [[ -f ${collect_match_file} && ! -f ${collect_match_file_bak} ]]
    then
        log INFO "Backup file: ${collect_match_file}"
        cp -a ${collect_match_file} ${collect_match_file_bak} 1>/dev/null 2>&1
    fi

        #滻Collect_match.sh
        cp -af ${downloadPath}/update/atoms/Inspect/lib/Collect_match.sh ${collect_match_file} 1>/dev/null 2>&1 || { log ERROR "copy Collect_match.sh failed.";}
        chomd 500 ${collect_match_file}
    fi

    return 0
}

function download_one_file()
{
    local src="$1"
    local file="$2"
    local dst="$3"
    local -i count=0
    local -i reps=4
    local cerfile="/opt/dsware/manager/webapps/dsware/WEB-INF/fsm_server.cer"
    local cerfile2="/opt/dsware/agent/conf/ssl/fsm_server.cer"
    local cerfile3="/opt/dsware/agent/conf/ssl/rootCA.cer"
    local srvIpPort=""
    
    [[ "Xipv4" == "X${IP_TYPE}" ]] && srvIpPort="${ftpServerIp}:30000" || srvIpPort="[${ftpServerIp}]:30000"

    if [ "${IS_MANAGE_NODE}" == "Y" ]
    then
        cp "${src}"/${file} "${dst}/" >> ${LOG_FILE} 2>&1  || { log ERROR "copy ${file} failed."; return 1; }
    elif [[ -n "${ftpType}" && 1 -eq "${ftpType}" ]]; then
        src=${src#*update/}

        if [ ! -f $cerfile -a ! -f $cerfile2 -a ! -f $cerfile3 ];then
                log ERROR "No cerfile."
                return 1
        fi

        while [ $count -lt $reps ]
        do
            count+=1

            if [ -f "$cerfile" ]; then
                echo ${ftpPasswd} | xargs -i lftp -c "lftp ftps://${srvIpPort};
                         set net:timeout 60;
                         set net:reconnect-interval-base 1;
                         set net:reconnect-interval-max 2;
                         set net:reconnect-interval-multiplier 4;
                         set net:max-retries 30;
                         set cmd:fail-exit yes;
                         set ssl:ca-file $cerfile;
                         set ssl:check-hostname no;
                         open -u ${ftpUser},{};
                         set xfer:clobber on;
                         lcd "${dst}";
                         mget "${src}"/"${file}"" >> "${LOG_FILE}" 2>&1
                if [ $? -eq 0 ];then
                    return 0
                fi
            fi

            cerfile="/opt/dsware/agent/conf/ssl/fsm_server.cer"
            if [ -f "$cerfile" ]; then
                echo ${ftpPasswd} | xargs -i lftp -c "lftp ftps://${srvIpPort};
                         set net:timeout 60;
                         set net:reconnect-interval-base 1;
                         set net:reconnect-interval-max 2;
                         set net:reconnect-interval-multiplier 4;
                         set net:max-retries 30;
                         set cmd:fail-exit yes;
                         set ssl:ca-file $cerfile;
                         set ssl:check-hostname no;
                         open -u ${ftpUser},{};
                         set xfer:clobber on;
                         lcd ${dst};
                         mget ${src}/${file}" >> "${LOG_FILE}" 2>&1
                if [ $? -eq 0 ];then
                    return 0
                fi
            fi

            cerfile="/opt/dsware/agent/conf/ssl/rootCA.cer"
            if [ -f "$cerfile" ]; then
                echo ${ftpPasswd} | xargs -i lftp -c "lftp ftps://${srvIpPort};
                         set net:timeout 60;
                         set net:reconnect-interval-base 1;
                         set net:reconnect-interval-max 2;
                         set net:reconnect-interval-multiplier 4;
                         set net:max-retries 30;
                         set cmd:fail-exit yes;
                         set ssl:ca-file $cerfile;
                         set ssl:check-hostname no;
                         open -u ${ftpUser},{};
                         set xfer:clobber on;
                         lcd ${dst};
                         mget ${src}/${file}" >> "${LOG_FILE}" 2>&1
                if [ $? -eq 0 ];then
                    return 0
                fi
            fi

            sleep 1
            cerfile="/opt/dsware/manager/webapps/dsware/WEB-INF/fsm_server.cer"
        done

        return 1
    else
        ${SFTP_DOWNLOAD_TOOL} "${ftpUser}" "${ftpPasswd}" "${ftpServerIp}" "${src}/${file}" "${dst}/" "mget" >> ${LOG_FILE} 2>&1 || { log ERROR "download ${file} failed."; return 1; }
    fi
    
    return 0
}

function download_one_file_with_try()
{
    local src="$1"
    local file="$2"
    local dst="$3"
    local max_try_num="3"
    
    local get_result=0
    for((i=0;i<${max_try_num};i++))
    do
        download_one_file "${src}" "${file}" "${dst}"
        get_result=$?
        if [ "${get_result}" -ne "0" ]
        then
            log ERROR "download  ${file} failed when time [$i].";
            sleep 1
            continue
        fi
        break
    done
    return ${get_result}
}

function download_one_file_and_verify()
{
    mkdir -p "${g_myWorkPath}/sha256"
    local src="$1"
    local file="$2"
    local dst="$3"
    local sha256Path="${g_myWorkPath}/sha256"
    
    log INFO "start down ${file} to ${dst} from ${src}, and verify it."
    
    download_one_file_with_try "${src}" "${file}.sha256" "${sha256Path}/" || { log ERROR "download_one_file_with_try ${file}.sha256 failed."; return 1; }
    local sha256FileName="$(basename "$(ls "${sha256Path}"/${file}.sha256)")"
    [ -n "${sha256FileName}" -a -f "${sha256Path}"/"${sha256FileName}" ] || { log ERROR "download_one_file_with_try ${file}.sha256 end, but it not exsit."; return 1; }
    local sha256download="$(cat "${sha256Path}"/"${sha256FileName}" | awk '{print $1}')"
    log INFO "get sha256 from download sha256file succeed, sha256download=${sha256download}"
    local rpmFileName="$(echo "${sha256FileName}" | awk -F'\\.sha256$' '{print $1}')"
    [ -n "${rpmFileName}" ] || { log ERROR "get rpm file name failed."; return 1; }
    if [ ! -f "${dst}"/"${rpmFileName}" ]
    then
        log INFO "${rpmFileName} not exsit, download it."
        download_one_file_with_try "${src}" "${rpmFileName}" "${dst}"/ || { log ERROR "download_one_file_with_try ${rpmFileName} failed."; return 1; }
        [ -f "${dst}"/"${rpmFileName}" ] || { log ERROR "download_one_file_with_try ${rpmFileName} end, but it not exsit."; return 1; }
    else
        log INFO "${rpmFileName} exsit, verify it."
    fi
    
    local sha256verify="$(sha256sum "${dst}"/"${rpmFileName}" | awk '{print $1}')"
    log INFO "sha256sum ${rpmFileName}, sha256verify=${sha256verify}"
    if [ "${sha256download}" != "${sha256verify}" ]
    then
        log ERROR "verify ${rpmFileName} failed at 1st time, maybe file broken, download it again."
        download_one_file_with_try "${src}" "${rpmFileName}" "${dst}"/ || { log ERROR "download_one_file_with_try ${rpmFileName} failed."; return 1; }
        [ -f "${dst}"/"${rpmFileName}" ] || { log ERROR "download_one_file_with_try ${rpmFileName} end, but it not exsit."; return 1; }
    else
        log INFO "${rpmFileName} verify pass, download succeed."
        return 0
    fi
    local sha256verify="$(sha256sum "${dst}"/"${rpmFileName}" | awk '{print $1}')"
    log INFO "sha256sum ${rpmFileName}, sha256verify=${sha256verify}"
    if [ "${sha256download}" != "${sha256verify}" ]
    then
        log ERROR "verify ${rpmFileName} failed at 2nd time, maybe file broken, download it again."
        download_one_file_with_try "${src}" "${rpmFileName}" "${dst}"/ || { log ERROR "download_one_file_with_try ${rpmFileName} failed."; return 1; }
        [ -f "${dst}"/"${rpmFileName}" ] || { log ERROR "download_one_file_with_try ${rpmFileName} end, but it not exsit."; return 1; }
    else
        log INFO "${rpmFileName} verify pass, download succeed."
        return 0
    fi
    local sha256verify="$(sha256sum "${dst}"/"${rpmFileName}" | awk '{print $1}')"
    log INFO "sha256sum ${rpmFileName}, sha256verify=${sha256verify}"
    if [ "${sha256download}" != "${sha256verify}" ]
    then
        log ERROR "verify ${rpmFileName} failed  at 3rd time finally, download failed."
        return 1
    else
        log INFO "${rpmFileName} verify pass, download succeed."
        return 0
    fi
    
    return 0
}

#ȡãipv4 ipv6
function getNetworkType()
{
    if [ ! -f ${NET_WORK_TYPE_FILE} ];then
        log "ERROR" "networkType file ${NET_WORK_TYPE_FILE} not exist!"
        return 1
    fi
    
    IP_TYPE=$(cat ${NET_WORK_TYPE_FILE} | grep -w -E "^P_MANAGER_IP_FAMILY" | awk -F '=' '{print $2}')
    if [ "Xipv4" != "X${IP_TYPE}" -a "Xipv6" != "X${IP_TYPE}" ];then
        [[ -z "${IP_TYPE}" ]] && IP_TYPE="ipv4" || { log "ERROR" "p_manager_ip_family:${IP_TYPE} error!" ; return 1; }
    fi   
    log "NOTICE" "P_MANAGER_IP_FAMILY=${IP_TYPE}"
    return 0
}

function check_cpu_idle()
{
    cpu_need_dle=5.0
    cpu_top_info=$(top -bn 2 | grep "Cpu" | sed -n 2p)
    log INFO "cpu_top_info:${cpu_top_info}"
    if [[ -z "$(echo ${cpu_top_info} | grep "%Cpu")" ]]
    then
        cpu_idle=$(echo ${cpu_top_info}| awk '{print $5}' | awk -F '%' '{print $1}')
    else
        cpu_idle=$(echo ${cpu_top_info}| awk '{print $8}')
    fi
    log INFO "cpu_idle=${cpu_idle}"

    [[ -z "${cpu_idle}" ]] && { log ERROR "get cpuIdle info from command [top -bn 1 | grep Cpu] is empty "; return 1; }

    if [[ $(echo "${cpu_idle} ${cpu_need_dle}" | awk '{if($1<=$2) {print 1} else {print 0}}') -eq 1 ]]
    then
        log ERROR "The cpu_idle is less than or equal to ${cpu_need_dle}%."
        return 1
    fi
    return 0
}

function check_2G_free_memory()
{
    total_memory_free=0
    free_memory_only=0
    cached_memory=0
    buffers_memory=0
    need_memory_free=2

    if [[ -f "/etc/redhat-release" ]]
    then
        free_memory_only=`free -g | grep -i mem | awk '{print$4}'`
        buffers_memory=`free -g | grep -i mem | awk '{print$6}'`
        total_memory_free=$[${free_memory_only}+${buffers_memory}]
        log INFO "free_memory_only=${free_memory_only}; buffers_memory=${buffers_memory}"
        log INFO "total_memory_free=${total_memory_free}"
    else
        free_memory_only=`free -g | grep -i mem | awk '{print$4}'`
        cached_memory=`free -g | grep -i mem | awk '{print$7}'`
        buffers_memory=`free -g | grep -i mem | awk '{print$6}'`
        total_memory_free=$[${free_memory_only}+${cached_memory}+${buffers_memory}]
        log INFO "free_memory_only=${free_memory_only}; cached_memory=${cached_memory}; buffers_memory=${buffers_memory}"
        log INFO "total_memory_free=${total_memory_free}"
    fi

    if [[ $(echo "${total_memory_free} ${need_memory_free}" | awk '{if($1<=$2) {print 1} else {print 0}}') -eq 1 ]]
    then
        log ERROR "The total_memory_free is less than or equal to ${need_memory_free}G."
        return 1
    fi
    return 0
}


# 黷CPU Сڵ5%򱨴ʣڴ Сڵ2G򱨴
function precheck()
{
    ret=0
    check_cpu_idle || ret=1
    check_2G_free_memory || ret=1
    return ${ret}
}

function main()
{
    if [ $# -lt 6 ]
    then
        log ERROR "param is not enough, at least 6."
        exit 1
    fi

    ftpServerIp="$1"
    ftpUser="$2"
    ftpPasswd="$3"
    packageType="$4"
    sourcePath="$5"
    downloadPath="$6"
    nodeType="$7"
    ftpType="$8"
    logicNodeType="$9"
    log INFO "ftpServerIp=${ftpServerIp},ftpUser=${ftpUser},ftpPasswd=,packageType=${packageType},sourcePath=${sourcePath},downloadPath=${downloadPath},nodeType=${nodeType},ftpType=${ftpType},logicNodeType=${logicNodeType}"
    log INFO "precheck..."
    precheck || { log ERROR "precheck failed."; return 1; }


    log INFO "precheck..."
    precheck || { log ERROR "precheck failed."; return 1; }
    # 1. ׼ȫֱڵͣOS͵
    log INFO "prepare..."
    prepare || { log ERROR "prepare failed."; return 1; }
    # 2. ļԭӽűĿĿ¼Ȩ
    log INFO "copy_upgrade_files..."
    copy_upgrade_files || { log ERROR "copy_upgrade_files failed."; return 1; }

    return 0
}

#######################################################
getCurPath
checkLogSize
#######################################################

log MUST "enter [$0]"
getNetworkType || { log ERROR "getNetworkType failed"; exit 1; }
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

