#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4200"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1


function check_main()
{
    filesystem_root=$(df -h / |grep -v Filesystem |grep /dev |awk '{print $5}' |awk -F '%' '{print $1}')
    filesystem_log=$(df -h /var/log  | grep -v Filesystem |grep /dev |awk '{print $5}' |awk -F '%' '{print $1}')
    filesystem_zk=$(df -h /opt/dsware/agent/zk/data  | grep -v Filesystem |grep /dev|awk '{print $5}' |awk -F '%' '{print $1}')

    if [ "$filesystem_root" -gt "90" -o "$filesystem_log" -gt "90" -o "$filesystem_zk" -gt "90" ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"   # 磁盘有分区占用率超过90%
        originalInfo="command:df -h / |grep -v Filesystem;\ndf -h /var/log  | grep -v Filesystem;\ndf -h /opt/dsware/agent/zk/data  | grep -v Filesystem;\n"
        originalInfo="${originalInfo}""review:/${filesystem_root}% /var/log${filesystem_log}% /opt/dsware/agent/zk/data${filesystem_zk}% \n"
        originalInfo="${originalInfo}""result:The disk partition occupancy rate exceeds 90%."
        log ERROR "The disk partition occupancy rate exceeds 90%./($filesystem_root) /var/log($filesystem_log) /opt/dsware/agent/zk/data($filesystem_zk)"
        log ERROR "${checkItemId}:Comm_4200:unok"
        return 1
    fi

    if [ "$filesystem_root" -gt "85" -o "$filesystem_log" -gt "85" -o "$filesystem_zk" -gt "85" ]
    then
        resultCode=2
        errorKey="${checkItemId}0002"   # 警告磁盘有分区占用率超过85%
        originalInfo="command:df -h / |grep -v Filesystem;\ndf -h /var/log  | grep -v Filesystem;\ndf -h /opt/dsware/agent/zk/data  | grep -v Filesystem;\n"
        originalInfo="${originalInfo}""review:/${filesystem_root}% /var/log${filesystem_log}% /opt/dsware/agent/zk/data${filesystem_zk}% \n"
        originalInfo="${originalInfo}""result:WARNING:The disk partition occupancy rate exceeds 85%."
        log ERROR "WARNING:The disk partition occupancy rate exceeds 85%./($filesystem_root) /var/log($filesystem_log) /opt/dsware/agent/zk/data($filesystem_zk)"
        log ERROR "${checkItemId}:Comm_4200:unok"
        return 1
    fi

    resultCode=0
    originalInfo="command:df -h / |grep -v Filesystem;\ndf -h /var/log  | grep -v Filesystem;\ndf -h /opt/dsware/agent/zk/data  | grep -v Filesystem;\n"
    originalInfo="${originalInfo}""review:/${filesystem_root}% /var/log${filesystem_log}% /opt/dsware/agent/zk/data${filesystem_zk}% \n"
    originalInfo="${originalInfo}""result:Normal disk usage."
    log INFO "Normal disk usage./($filesystem_root) /var/log($filesystem_log) /opt/dsware/agent/zk/data($filesystem_zk)"
    log INFO "${checkItemId}:Comm_4200:ok"
    return 0
}

function main()
{
    if [ "${NODE_TYPE}" == "Agent" ]
    then
        agent_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
                return 0
        else
            check_main
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        fi
    fi

    if [ "${NODE_TYPE}" == "Manager" ]
    then
        manager_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
                return 0
        else
            check_main
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        fi
    fi

    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 磁盘有分区占用率超过90%
#  0002 警告磁盘有分区占用率超过85%
#
##############################