#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4202"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1

#############################################################
# 描述：检查系统CPU使用率(common)
# 错误码：(0~9为正常，10及以上为异常)
#         0 正常，系统CPU使用率为$1
#         1 系统CPU使用率高于90%
#############################################################

cpu_threshold=90
CPU_EXCEED_THRESHOLD=10

function check_cpu_use()
{
    local cpuIdle=($(top -bn 11 | grep Cpu | awk -F ',' '{print$4}' | egrep -o '[0-9]+\.[0-9]*'))
    originalInfo="${originalInfo}""command:top -bn 11 | grep Cpu | awk -F ',' '{print\$4}'\n"
    originalInfo="${originalInfo}""review:cupIdle=${cpuIdle[@]}\n"
    
    cpuIdle_total=0
    for ((i=1;i<11;i++))
    do
        cpuIdle_total=$(awk "BEGIN{print ${cpuIdle_total} + ${cpuIdle[i]} }")
    done

    local cpuIdle_average_value=$(awk "BEGIN{print ${cpuIdle_total} / 10 }")
    local cpuUsage=$(awk "BEGIN{print 100 - ${cpuIdle_average_value} }")
    originalInfo="${originalInfo}""result:cpuIdle_average_value=${cpuIdle_average_value}%; cpuUsage=${cpuUsage}%;\n"


	if [ $(awk -v num1=${cpuUsage} -v num2=${cpu_threshold} 'BEGIN{print(num1>=num2)?"1":"0"}') -eq 1 -a $(awk -v num1=${cpuUsage} -v num2=100 'BEGIN{print(num1<=num2)?"1":"0"}') -eq 1 ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"   # 系统CPU使用率高于90%
        originalInfo="${originalInfo}""result:cpu usage is in [${cpu_threshold},100]. cpu_used is ${cpuUsage}%."
        log ERROR "Comm_${checkItemId}:cpu usage is in [${cpu_threshold},100]. cpu_used is ${cpuUsage}%."
        log ERROR "Comm_${checkItemId}:unok"
        return 1
    fi
	
    resultCode=0
    originalInfo="${originalInfo}""result:cpu usage is normal. cpu_used is ${cpuUsage}%."
    log INFO "cpu usage is normal. cpu_used is ${cpuUsage}%."
    log INFO "${checkItemId}:Comm_4202:ok"
    return 0
}

function main()
{
    if [ "${NODE_TYPE}" == "Agent" ]
    then
        agent_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
                return 0
        else
            check_cpu_use
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        fi
    fi

    if [ "${NODE_TYPE}" == "Manager" ]
    then
        manager_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
                return 0
        else
            check_cpu_use
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        fi
    fi

    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 系统CPU使用率高于90%，CPU使用率为$1
#  
#
##############################