#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4203"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1



function domain_to_ip()
{
    domain=$1
    ping_result=`timeout 3 ping $domain -c 1  2>>/dev/null`
    ret=$?
    if [ $ret -eq 0 ];then
        ping_result=`echo $ping_result | grep PING | awk -F '[()]' '{print $2}'`
        echo $ping_result
    fi
    return $ret
}

function check_ntp_config()
{
    fsp_user_judg=`id fsp 2>/dev/null`
    originalInfo="${originalInfo}""command:id fsp\n"
    originalInfo="${originalInfo}""review:${fsp_user_judg}\n"
    if [[ -n ${fsp_user_judg} ]]
    then
        originalInfo="${originalInfo}""result:there is fsp_user on the node, so this node is openstack node, no need to check."
        log INFO "Comm_${checkItemId}:there is fsp_user on the node, so this node is openstack node, no need to check."
        log INFO "Comm_${checkItemId}:ok"
        return 0
    fi

    ntp_conf="/etc/ntp.conf"
    ntp_file="/etc/sysconfig/ntpd"

    #不同的系统存在的ntp服务名字是不一样的
    if [ -f "/etc/init.d/ntp" -o -f "/usr/lib/systemd/system/ntp.service" ]; then
        ntp_service="ntp"
    #redhat 6.4/6.6/7.0和suse 12系统下为ntpd服务
    elif [ -f "/etc/init.d/ntpd" -o -f "/usr/lib/systemd/system/ntpd.service" ]; then
        ntp_service="ntpd"
    else
        resultCode=2
        errorKey="${checkItemId}0001"   # 当前服务器没有安装NTP服务
        originalInfo="${originalInfo}""command:ls /etc/init.d/ntp;ls /usr/lib/systemd/system/ntp.service;ls /etc/init.d/ntpd;ls /usr/lib/systemd/system/ntpd.service;\n"
        originalInfo="${originalInfo}""result:The current OS doesn't install NTP service."
        log ERROR "The current OS doesn't install NTP service."
        log ERROR "${checkItemId}:Comm_4203:unok"
        return 1
    fi

    ntp_info=$(ntpq -pn 2>&1)
    server_prefer_ip="`cat $ntp_conf | grep '^server' | grep prefer | awk '{print $2}'`"
    server_current_ip="`echo "${ntp_info}" | grep \* | awk '{print $1}'`"
    server_current_ip=${server_current_ip//\*/}
    if [ -z "$server_prefer_ip" ] && [ -z "$server_current_ip" ];then
        resultCode=1
        errorKey="${checkItemId}0002"   # NTP服务IP没有配置
        originalInfo="${originalInfo}""command:cat ${ntp_conf} | grep '^server' | grep prefer | awk '{print \$2}'\n"
        originalInfo="${originalInfo}""result:Ntp server ip not configure."
        log ERROR "Ntp server ip not configure."
        log ERROR "${checkItemId}:Comm_4203:unok"
        return 1
    fi

    if [ -n "`echo "${ntp_info}" | grep \"Request timed out\"`" ];then
        resultCode=1
        errorKey="${checkItemId}0003"   # Ntpd进程是停止的
        originalInfo="${originalInfo}""command:echo ${ntp_info} | grep 'Request timed out' \n"
        originalInfo="${originalInfo}""result:Ntpd process is stopped."
        log ERROR "Ntpd process is stopped."
        log ERROR "${checkItemId}:Comm_4203:unok"
        return 1
    fi
    
    ntp_server_list="`grep '^server' $ntp_conf | awk '{if(NR==1){NTP_SERVER_LIST=$2}else{NTP_SERVER_LIST=NTP_SERVER_LIST","$2}}END{print NTP_SERVER_LIST}'`"
    ntpServerIpList=(${ntp_server_list//,/ })
    
    for ntp in ${ntpServerIpList[@]};do
        ntp=`domain_to_ip $ntp`
        if [ $? -ne 0 ];then
            continue
        fi
        
        #带*开头NTP状态一定是正常的。
        if [ -n "`echo "${ntp_info}" | grep -w ${ntp} | grep '^\*'`" ];then
            resultCode=0
            originalInfo="${originalInfo}""command:echo ${ntp_info} | grep -w ${ntp} \n"
            originalInfo="${originalInfo}""result:Ntp server ip is configured"
            log INFO "Ntp server ip is configured"
            log INFO "${checkItemId}:Comm_4203:ok"
            return 0
        fi
    done
     
    resultCode=1
    errorKey="${checkItemId}0004"   # Ntp时间同步异常
    originalInfo="${originalInfo}""command:echo ${ntp_info} | grep -w ${ntp} \n"
    originalInfo="${originalInfo}""result:NTP time synchronization is abnormal."
    log ERROR "NTP time synchronization is abnormal."
    log ERROR "${checkItemId}:Comm_4203:unok"
    return 1
}


function main()
{

    if [ "${NODE_TYPE}" == "Agent" ]
    then
        agent_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
                return 0
        fi
        check_ntp_config
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi

    if [ "${NODE_TYPE}" == "Manager" ]
    then
        manager_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
                return 0
        fi
        check_ntp_config
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi
    
    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 当前服务器没有安装NTP服务
#  0002 NTP服务IP没有配置
#  0003 Ntpd进程是停止的
#  0004 Ntp时间同步异常
#
##############################