#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4205"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1


mem_threshold=10

function check_memory_idle()
{    
    local totalInfo=$(grep MemTotal /proc/meminfo | awk '{print $2}')
    local freeInfo=$(grep MemFree /proc/meminfo | awk '{print $2}')
    local bufferInfo=$(grep Buffers /proc/meminfo | awk '{print $2}')
    local cachedInfo=$(grep "^Cached" /proc/meminfo | awk '{print $2}')
    local idleSize=$(awk "BEGIN{print $freeInfo+$bufferInfo+$cachedInfo }")
    local idleSizeG=$(echo "$idleSize" | awk '{printf ("%.1f\n",$1/1024/1024)}')
    local idleInfo=$(echo "${idleSize} ${totalInfo}" | awk '{printf ("%.1f\n",100*$1/$2)}')
     
    check_info=$(echo "${idleSizeG}G@${idleInfo}%")
    if [ $(awk -v num1=$idleInfo -v num2=0 'BEGIN{print(num1>=num2)?"1":"0"}') -eq 1 -a  $(awk -v num1=$idleInfo -v num2=$mem_threshold 'BEGIN{print(num1<=num2)?"1":"0"}') -eq 1 ];then
        resultCode=1
        errorKey="${checkItemId}0001"   # 系统内存剩余小于10%
        originalInfo="${originalInfo}""review:${check_info}\n"
        originalInfo="${originalInfo}""result:idle mem is unusual. mem_used is ${idleInfo}%."
        log ERROR "idle mem is unusual. mem_used is ${idleInfo}%."
        log ERROR "${checkItemId}:Comm_4205:unok"
        return 1
    fi
    
    resultCode=0
    originalInfo="${originalInfo}""review:${check_info}\n"
    originalInfo="${originalInfo}""result:idle mem is normal. mem_used is ${idleInfo}%."
    log INFO "idle mem is normal. mem_used is ${idleInfo}%"
    log INFO "${checkItemId}:Comm_4205:ok"
    return 0
}


function main()
{
    check_memory_idle

    if [ "${NODE_TYPE}" == "Agent" ]
    then
        agent_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
                return 0
        fi
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi

    if [ "${NODE_TYPE}" == "Manager" ]
    then
        manager_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
                return 0
        fi
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi

    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 系统内存剩余小于10%
#
##############################